/*
 * Decompiled with CFR 0.152.
 */
package android.arch.lifecycle;

import android.arch.lifecycle.GenericLifecycleObserver;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.OnLifecycleEvent;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ReflectiveGenericLifecycleObserver
implements GenericLifecycleObserver {
    private final Object mWrapped;
    private final CallbackInfo mInfo;
    static final Map<Class, CallbackInfo> sInfoCache = new HashMap<Class, CallbackInfo>();
    private static final int CALL_TYPE_NO_ARG = 0;
    private static final int CALL_TYPE_PROVIDER = 1;
    private static final int CALL_TYPE_PROVIDER_WITH_EVENT = 2;

    ReflectiveGenericLifecycleObserver(Object wrapped) {
        this.mWrapped = wrapped;
        this.mInfo = ReflectiveGenericLifecycleObserver.getInfo(this.mWrapped.getClass());
    }

    @Override
    public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
        this.invokeCallbacks(this.mInfo, source, event);
    }

    private void invokeMethodsForEvent(List<MethodReference> handlers, LifecycleOwner source, Lifecycle.Event event) {
        if (handlers != null) {
            for (int i = handlers.size() - 1; i >= 0; --i) {
                MethodReference reference = handlers.get(i);
                this.invokeCallback(reference, source, event);
            }
        }
    }

    private void invokeCallbacks(CallbackInfo info, LifecycleOwner source, Lifecycle.Event event) {
        this.invokeMethodsForEvent(info.mEventToHandlers.get((Object)event), source, event);
        this.invokeMethodsForEvent(info.mEventToHandlers.get((Object)Lifecycle.Event.ON_ANY), source, event);
    }

    private void invokeCallback(MethodReference reference, LifecycleOwner source, Lifecycle.Event event) {
        try {
            switch (reference.mCallType) {
                case 0: {
                    reference.mMethod.invoke(this.mWrapped, new Object[0]);
                    break;
                }
                case 1: {
                    reference.mMethod.invoke(this.mWrapped, source);
                    break;
                }
                case 2: {
                    reference.mMethod.invoke(this.mWrapped, new Object[]{source, event});
                }
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to call observer method", e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static CallbackInfo getInfo(Class klass) {
        CallbackInfo existing = sInfoCache.get(klass);
        if (existing != null) {
            return existing;
        }
        existing = ReflectiveGenericLifecycleObserver.createInfo(klass);
        return existing;
    }

    private static void verifyAndPutHandler(Map<MethodReference, Lifecycle.Event> handlers, MethodReference newHandler, Lifecycle.Event newEvent, Class klass) {
        Lifecycle.Event event = handlers.get(newHandler);
        if (event != null && newEvent != event) {
            Method method = newHandler.mMethod;
            throw new IllegalArgumentException("Method " + method.getName() + " in " + klass.getName() + " already declared with different @OnLifecycleEvent value: previous" + " value " + (Object)((Object)event) + ", new value " + (Object)((Object)newEvent));
        }
        if (event == null) {
            handlers.put(newHandler, newEvent);
        }
    }

    private static CallbackInfo createInfo(Class klass) {
        CallbackInfo superInfo;
        Class superclass = klass.getSuperclass();
        HashMap<MethodReference, Lifecycle.Event> handlerToEvent = new HashMap<MethodReference, Lifecycle.Event>();
        if (superclass != null && (superInfo = ReflectiveGenericLifecycleObserver.getInfo(superclass)) != null) {
            handlerToEvent.putAll(superInfo.mHandlerToEvent);
        }
        Method[] methods = klass.getDeclaredMethods();
        Class<?>[] interfaces = klass.getInterfaces();
        for (Class<?> clazz : interfaces) {
            for (Map.Entry<MethodReference, Lifecycle.Event> entry : ReflectiveGenericLifecycleObserver.getInfo(clazz).mHandlerToEvent.entrySet()) {
                ReflectiveGenericLifecycleObserver.verifyAndPutHandler(handlerToEvent, entry.getKey(), entry.getValue(), klass);
            }
        }
        for (GenericDeclaration genericDeclaration : methods) {
            OnLifecycleEvent annotation = ((Method)genericDeclaration).getAnnotation(OnLifecycleEvent.class);
            if (annotation == null) continue;
            Class<?>[] params = ((Method)genericDeclaration).getParameterTypes();
            int callType = 0;
            if (params.length > 0) {
                callType = 1;
                if (!params[0].isAssignableFrom(LifecycleOwner.class)) {
                    throw new IllegalArgumentException("invalid parameter type. Must be one and instanceof LifecycleOwner");
                }
            }
            Lifecycle.Event event = annotation.value();
            if (params.length > 1) {
                callType = 2;
                if (!params[1].isAssignableFrom(Lifecycle.Event.class)) {
                    throw new IllegalArgumentException("invalid parameter type. second arg must be an event");
                }
                if (event != Lifecycle.Event.ON_ANY) {
                    throw new IllegalArgumentException("Second arg is supported only for ON_ANY value");
                }
            }
            if (params.length > 2) {
                throw new IllegalArgumentException("cannot have more than 2 params");
            }
            MethodReference methodReference = new MethodReference(callType, (Method)genericDeclaration);
            ReflectiveGenericLifecycleObserver.verifyAndPutHandler(handlerToEvent, methodReference, event, klass);
        }
        CallbackInfo info = new CallbackInfo(handlerToEvent);
        sInfoCache.put(klass, info);
        return info;
    }

    static class MethodReference {
        final int mCallType;
        final Method mMethod;

        MethodReference(int callType, Method method) {
            this.mCallType = callType;
            this.mMethod = method;
            this.mMethod.setAccessible(true);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodReference that = (MethodReference)o;
            return this.mCallType == that.mCallType && this.mMethod.getName().equals(that.mMethod.getName());
        }

        public int hashCode() {
            return 31 * this.mCallType + this.mMethod.getName().hashCode();
        }
    }

    static class CallbackInfo {
        final Map<Lifecycle.Event, List<MethodReference>> mEventToHandlers;
        final Map<MethodReference, Lifecycle.Event> mHandlerToEvent;

        CallbackInfo(Map<MethodReference, Lifecycle.Event> handlerToEvent) {
            this.mHandlerToEvent = handlerToEvent;
            this.mEventToHandlers = new HashMap<Lifecycle.Event, List<MethodReference>>();
            for (Map.Entry<MethodReference, Lifecycle.Event> entry : handlerToEvent.entrySet()) {
                Lifecycle.Event event = entry.getValue();
                List<MethodReference> methodReferences = this.mEventToHandlers.get((Object)event);
                if (methodReferences == null) {
                    methodReferences = new ArrayList<MethodReference>();
                    this.mEventToHandlers.put(event, methodReferences);
                }
                methodReferences.add(entry.getKey());
            }
        }
    }
}

