/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.util;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.database.Cursor;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TableInfo {
    public final String name;
    public final Map<String, Column> columns;
    public final Set<ForeignKey> foreignKeys;
    @Nullable
    public final Set<Index> indices;

    public TableInfo(String name, Map<String, Column> columns, Set<ForeignKey> foreignKeys, Set<Index> indices) {
        this.name = name;
        this.columns = Collections.unmodifiableMap(columns);
        this.foreignKeys = Collections.unmodifiableSet(foreignKeys);
        this.indices = indices == null ? null : Collections.unmodifiableSet(indices);
    }

    public TableInfo(String name, Map<String, Column> columns, Set<ForeignKey> foreignKeys) {
        this(name, columns, foreignKeys, Collections.emptySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableInfo tableInfo = (TableInfo)o;
        if (this.name != null ? !this.name.equals(tableInfo.name) : tableInfo.name != null) {
            return false;
        }
        if (this.columns != null ? !this.columns.equals(tableInfo.columns) : tableInfo.columns != null) {
            return false;
        }
        if (this.foreignKeys != null ? !this.foreignKeys.equals(tableInfo.foreignKeys) : tableInfo.foreignKeys != null) {
            return false;
        }
        if (this.indices == null || tableInfo.indices == null) {
            return true;
        }
        return this.indices.equals(tableInfo.indices);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.columns != null ? this.columns.hashCode() : 0);
        result = 31 * result + (this.foreignKeys != null ? this.foreignKeys.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TableInfo{name='" + this.name + '\'' + ", columns=" + this.columns + ", foreignKeys=" + this.foreignKeys + ", indices=" + this.indices + '}';
    }

    public static TableInfo read(SupportSQLiteDatabase database, String tableName) {
        Map<String, Column> columns = TableInfo.readColumns(database, tableName);
        Set<ForeignKey> foreignKeys = TableInfo.readForeignKeys(database, tableName);
        Set<Index> indices = TableInfo.readIndices(database, tableName);
        return new TableInfo(tableName, columns, foreignKeys, indices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ForeignKey> readForeignKeys(SupportSQLiteDatabase database, String tableName) {
        HashSet<ForeignKey> foreignKeys = new HashSet<ForeignKey>();
        try (Cursor cursor = database.query("PRAGMA foreign_key_list(`" + tableName + "`)");){
            int idColumnIndex = cursor.getColumnIndex("id");
            int seqColumnIndex = cursor.getColumnIndex("seq");
            int tableColumnIndex = cursor.getColumnIndex("table");
            int onDeleteColumnIndex = cursor.getColumnIndex("on_delete");
            int onUpdateColumnIndex = cursor.getColumnIndex("on_update");
            List<ForeignKeyWithSequence> ordered = TableInfo.readForeignKeyFieldMappings(cursor);
            int count = cursor.getCount();
            for (int position = 0; position < count; ++position) {
                cursor.moveToPosition(position);
                int seq = cursor.getInt(seqColumnIndex);
                if (seq != 0) continue;
                int id = cursor.getInt(idColumnIndex);
                ArrayList<String> myColumns = new ArrayList<String>();
                ArrayList<String> refColumns = new ArrayList<String>();
                for (ForeignKeyWithSequence key : ordered) {
                    if (key.mId != id) continue;
                    myColumns.add(key.mFrom);
                    refColumns.add(key.mTo);
                }
                foreignKeys.add(new ForeignKey(cursor.getString(tableColumnIndex), cursor.getString(onDeleteColumnIndex), cursor.getString(onUpdateColumnIndex), myColumns, refColumns));
            }
        }
        return foreignKeys;
    }

    private static List<ForeignKeyWithSequence> readForeignKeyFieldMappings(Cursor cursor) {
        int idColumnIndex = cursor.getColumnIndex("id");
        int seqColumnIndex = cursor.getColumnIndex("seq");
        int fromColumnIndex = cursor.getColumnIndex("from");
        int toColumnIndex = cursor.getColumnIndex("to");
        int count = cursor.getCount();
        ArrayList<ForeignKeyWithSequence> result = new ArrayList<ForeignKeyWithSequence>();
        for (int i = 0; i < count; ++i) {
            cursor.moveToPosition(i);
            result.add(new ForeignKeyWithSequence(cursor.getInt(idColumnIndex), cursor.getInt(seqColumnIndex), cursor.getString(fromColumnIndex), cursor.getString(toColumnIndex)));
        }
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Column> readColumns(SupportSQLiteDatabase database, String tableName) {
        HashMap<String, Column> columns = new HashMap<String, Column>();
        try (Cursor cursor = database.query("PRAGMA table_info(`" + tableName + "`)");){
            if (cursor.getColumnCount() > 0) {
                int nameIndex = cursor.getColumnIndex("name");
                int typeIndex = cursor.getColumnIndex("type");
                int notNullIndex = cursor.getColumnIndex("notnull");
                int pkIndex = cursor.getColumnIndex("pk");
                while (cursor.moveToNext()) {
                    String name = cursor.getString(nameIndex);
                    String type = cursor.getString(typeIndex);
                    boolean notNull = 0 != cursor.getInt(notNullIndex);
                    int primaryKeyPosition = cursor.getInt(pkIndex);
                    columns.put(name, new Column(name, type, notNull, primaryKeyPosition));
                }
            }
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Set<Index> readIndices(SupportSQLiteDatabase database, String tableName) {
        try (Cursor cursor = database.query("PRAGMA index_list(`" + tableName + "`)");){
            int nameColumnIndex = cursor.getColumnIndex("name");
            int originColumnIndex = cursor.getColumnIndex("origin");
            int uniqueIndex = cursor.getColumnIndex("unique");
            if (nameColumnIndex == -1 || originColumnIndex == -1 || uniqueIndex == -1) {
                Set<Index> set = null;
                return set;
            }
            HashSet<Index> indices = new HashSet<Index>();
            while (cursor.moveToNext()) {
                boolean unique;
                String origin = cursor.getString(originColumnIndex);
                if (!"c".equals(origin)) continue;
                String name = cursor.getString(nameColumnIndex);
                Index index = TableInfo.readIndex(database, name, unique = cursor.getInt(uniqueIndex) == 1);
                if (index == null) {
                    Set<Index> set = null;
                    return set;
                }
                indices.add(index);
            }
            HashSet<Index> hashSet = indices;
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Index readIndex(SupportSQLiteDatabase database, String name, boolean unique) {
        try (Cursor cursor = database.query("PRAGMA index_xinfo(`" + name + "`)");){
            int seqnoColumnIndex = cursor.getColumnIndex("seqno");
            int cidColumnIndex = cursor.getColumnIndex("cid");
            int nameColumnIndex = cursor.getColumnIndex("name");
            if (seqnoColumnIndex == -1 || cidColumnIndex == -1 || nameColumnIndex == -1) {
                Index index = null;
                return index;
            }
            TreeMap<Integer, String> results = new TreeMap<Integer, String>();
            while (cursor.moveToNext()) {
                int cid = cursor.getInt(cidColumnIndex);
                if (cid < 0) continue;
                int seq = cursor.getInt(seqnoColumnIndex);
                String columnName = cursor.getString(nameColumnIndex);
                results.put(seq, columnName);
            }
            ArrayList<String> columns = new ArrayList<String>(results.size());
            columns.addAll(results.values());
            Index index = new Index(name, unique, columns);
            return index;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class Index {
        public static final String DEFAULT_PREFIX = "index_";
        public final String name;
        public final boolean unique;
        public final List<String> columns;

        public Index(String name, boolean unique, List<String> columns) {
            this.name = name;
            this.unique = unique;
            this.columns = columns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Index index = (Index)o;
            if (this.unique != index.unique) {
                return false;
            }
            if (!this.columns.equals(index.columns)) {
                return false;
            }
            if (this.name.startsWith(DEFAULT_PREFIX)) {
                return index.name.startsWith(DEFAULT_PREFIX);
            }
            return this.name.equals(index.name);
        }

        public int hashCode() {
            int result = this.name.startsWith(DEFAULT_PREFIX) ? DEFAULT_PREFIX.hashCode() : this.name.hashCode();
            result = 31 * result + (this.unique ? 1 : 0);
            result = 31 * result + this.columns.hashCode();
            return result;
        }

        public String toString() {
            return "Index{name='" + this.name + '\'' + ", unique=" + this.unique + ", columns=" + this.columns + '}';
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static class ForeignKeyWithSequence
    implements Comparable<ForeignKeyWithSequence> {
        final int mId;
        final int mSequence;
        final String mFrom;
        final String mTo;

        ForeignKeyWithSequence(int id, int sequence, String from, String to) {
            this.mId = id;
            this.mSequence = sequence;
            this.mFrom = from;
            this.mTo = to;
        }

        @Override
        public int compareTo(ForeignKeyWithSequence o) {
            int idCmp = this.mId - o.mId;
            if (idCmp == 0) {
                return this.mSequence - o.mSequence;
            }
            return idCmp;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class ForeignKey {
        @NonNull
        public final String referenceTable;
        @NonNull
        public final String onDelete;
        @NonNull
        public final String onUpdate;
        @NonNull
        public final List<String> columnNames;
        @NonNull
        public final List<String> referenceColumnNames;

        public ForeignKey(@NonNull String referenceTable, @NonNull String onDelete, @NonNull String onUpdate, @NonNull List<String> columnNames, @NonNull List<String> referenceColumnNames) {
            this.referenceTable = referenceTable;
            this.onDelete = onDelete;
            this.onUpdate = onUpdate;
            this.columnNames = Collections.unmodifiableList(columnNames);
            this.referenceColumnNames = Collections.unmodifiableList(referenceColumnNames);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ForeignKey that = (ForeignKey)o;
            if (!this.referenceTable.equals(that.referenceTable)) {
                return false;
            }
            if (!this.onDelete.equals(that.onDelete)) {
                return false;
            }
            if (!this.onUpdate.equals(that.onUpdate)) {
                return false;
            }
            if (!this.columnNames.equals(that.columnNames)) {
                return false;
            }
            return this.referenceColumnNames.equals(that.referenceColumnNames);
        }

        public int hashCode() {
            int result = this.referenceTable.hashCode();
            result = 31 * result + this.onDelete.hashCode();
            result = 31 * result + this.onUpdate.hashCode();
            result = 31 * result + this.columnNames.hashCode();
            result = 31 * result + this.referenceColumnNames.hashCode();
            return result;
        }

        public String toString() {
            return "ForeignKey{referenceTable='" + this.referenceTable + '\'' + ", onDelete='" + this.onDelete + '\'' + ", onUpdate='" + this.onUpdate + '\'' + ", columnNames=" + this.columnNames + ", referenceColumnNames=" + this.referenceColumnNames + '}';
        }
    }

    public static class Column {
        public final String name;
        public final String type;
        public final boolean notNull;
        public final int primaryKeyPosition;

        public Column(String name, String type, boolean notNull, int primaryKeyPosition) {
            this.name = name;
            this.type = type;
            this.notNull = notNull;
            this.primaryKeyPosition = primaryKeyPosition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            if (Build.VERSION.SDK_INT >= 20 ? this.primaryKeyPosition != column.primaryKeyPosition : this.isPrimaryKey() != column.isPrimaryKey()) {
                return false;
            }
            if (!this.name.equals(column.name)) {
                return false;
            }
            if (this.notNull != column.notNull) {
                return false;
            }
            return this.type != null ? this.type.equalsIgnoreCase(column.type) : column.type == null;
        }

        public boolean isPrimaryKey() {
            return this.primaryKeyPosition > 0;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            result = 31 * result + (this.notNull ? 1231 : 1237);
            result = 31 * result + this.primaryKeyPosition;
            return result;
        }

        public String toString() {
            return "Column{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", notNull=" + this.notNull + ", primaryKeyPosition=" + this.primaryKeyPosition + '}';
        }
    }
}

