/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.db.framework;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.db.framework.FrameworkSQLiteDatabase;
import android.content.Context;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.support.annotation.RequiresApi;

class FrameworkSQLiteOpenHelper
implements SupportSQLiteOpenHelper {
    private final OpenHelper mDelegate;

    FrameworkSQLiteOpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, DatabaseErrorHandler errorHandler, SupportSQLiteOpenHelper.Callback callback) {
        this.mDelegate = this.createDelegate(context, name, factory, version, errorHandler, callback);
    }

    private OpenHelper createDelegate(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, DatabaseErrorHandler errorHandler, final SupportSQLiteOpenHelper.Callback callback) {
        return new OpenHelper(context, name, factory, version, errorHandler){

            public void onCreate(SQLiteDatabase sqLiteDatabase) {
                this.mWrappedDb = new FrameworkSQLiteDatabase(sqLiteDatabase);
                callback.onCreate((SupportSQLiteDatabase)this.mWrappedDb);
            }

            public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
                callback.onUpgrade((SupportSQLiteDatabase)this.getWrappedDb(sqLiteDatabase), oldVersion, newVersion);
            }

            public void onConfigure(SQLiteDatabase db) {
                callback.onConfigure((SupportSQLiteDatabase)this.getWrappedDb(db));
            }

            public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
                callback.onDowngrade((SupportSQLiteDatabase)this.getWrappedDb(db), oldVersion, newVersion);
            }

            public void onOpen(SQLiteDatabase db) {
                callback.onOpen((SupportSQLiteDatabase)this.getWrappedDb(db));
            }
        };
    }

    public String getDatabaseName() {
        return this.mDelegate.getDatabaseName();
    }

    @RequiresApi(api=16)
    public void setWriteAheadLoggingEnabled(boolean enabled) {
        this.mDelegate.setWriteAheadLoggingEnabled(enabled);
    }

    public SupportSQLiteDatabase getWritableDatabase() {
        return this.mDelegate.getWritableSupportDatabase();
    }

    public SupportSQLiteDatabase getReadableDatabase() {
        return this.mDelegate.getReadableSupportDatabase();
    }

    public void close() {
        this.mDelegate.close();
    }

    static abstract class OpenHelper
    extends SQLiteOpenHelper {
        FrameworkSQLiteDatabase mWrappedDb;

        OpenHelper(Context context, String name, SQLiteDatabase.CursorFactory factory, int version, DatabaseErrorHandler errorHandler) {
            super(context, name, factory, version, errorHandler);
        }

        SupportSQLiteDatabase getWritableSupportDatabase() {
            SQLiteDatabase db = super.getWritableDatabase();
            return this.getWrappedDb(db);
        }

        SupportSQLiteDatabase getReadableSupportDatabase() {
            SQLiteDatabase db = super.getReadableDatabase();
            return this.getWrappedDb(db);
        }

        FrameworkSQLiteDatabase getWrappedDb(SQLiteDatabase sqLiteDatabase) {
            if (this.mWrappedDb == null) {
                this.mWrappedDb = new FrameworkSQLiteDatabase(sqLiteDatabase);
            }
            return this.mWrappedDb;
        }

        public synchronized void close() {
            super.close();
            this.mWrappedDb = null;
        }
    }
}

