/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.db;

import android.arch.persistence.db.SupportSQLiteDatabase;
import android.content.Context;
import android.database.DatabaseErrorHandler;
import android.database.DefaultDatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;

public interface SupportSQLiteOpenHelper {
    public String getDatabaseName();

    @RequiresApi(api=16)
    public void setWriteAheadLoggingEnabled(boolean var1);

    public SupportSQLiteDatabase getWritableDatabase();

    public SupportSQLiteDatabase getReadableDatabase();

    public void close();

    public static interface Factory {
        public SupportSQLiteOpenHelper create(Configuration var1);
    }

    public static class Configuration {
        @NonNull
        public final Context context;
        @Nullable
        public final String name;
        @Nullable
        public final SQLiteDatabase.CursorFactory factory;
        public final int version;
        @NonNull
        public final Callback callback;
        @Nullable
        public final DatabaseErrorHandler errorHandler;

        Configuration(@NonNull Context context, @Nullable String name, @Nullable SQLiteDatabase.CursorFactory factory, int version, @Nullable DatabaseErrorHandler errorHandler, @NonNull Callback callback) {
            this.context = context;
            this.name = name;
            this.factory = factory;
            this.version = version;
            this.callback = callback;
            this.errorHandler = errorHandler;
        }

        public static Builder builder(Context context) {
            return new Builder(context);
        }

        public static class Builder {
            Context mContext;
            String mName;
            SQLiteDatabase.CursorFactory mFactory;
            int mVersion = 1;
            Callback mCallback;
            DatabaseErrorHandler mErrorHandler;

            public Configuration build() {
                if (this.mCallback == null) {
                    throw new IllegalArgumentException("Must set a callback to create the configuration.");
                }
                if (this.mContext == null) {
                    throw new IllegalArgumentException("Must set a non-null context to create the configuration.");
                }
                if (this.mErrorHandler == null) {
                    this.mErrorHandler = new DefaultDatabaseErrorHandler();
                }
                return new Configuration(this.mContext, this.mName, this.mFactory, this.mVersion, this.mErrorHandler, this.mCallback);
            }

            Builder(@NonNull Context context) {
                this.mContext = context;
            }

            public Builder errorHandler(@Nullable DatabaseErrorHandler errorHandler) {
                this.mErrorHandler = errorHandler;
                return this;
            }

            public Builder name(@Nullable String name) {
                this.mName = name;
                return this;
            }

            public Builder factory(@Nullable SQLiteDatabase.CursorFactory factory) {
                this.mFactory = factory;
                return this;
            }

            public Builder callback(@NonNull Callback callback) {
                this.mCallback = callback;
                return this;
            }

            public Builder version(int version) {
                this.mVersion = version;
                return this;
            }
        }
    }

    public static abstract class Callback {
        public void onConfigure(SupportSQLiteDatabase db) {
        }

        public abstract void onCreate(SupportSQLiteDatabase var1);

        public abstract void onUpgrade(SupportSQLiteDatabase var1, int var2, int var3);

        public void onDowngrade(SupportSQLiteDatabase db, int oldVersion, int newVersion) {
            throw new SQLiteException("Can't downgrade database from version " + oldVersion + " to " + newVersion);
        }

        public void onOpen(SupportSQLiteDatabase db) {
        }
    }
}

