/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkerParameters;
import java.lang.reflect.Constructor;

public abstract class WorkerFactory {
    private static final String TAG = Logger.tagWithPrefix("WorkerFactory");

    @Nullable
    public abstract ListenableWorker createWorker(@NonNull Context var1, @NonNull String var2, @NonNull WorkerParameters var3);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final ListenableWorker createWorkerWithDefaultFallback(@NonNull Context appContext, @NonNull String workerClassName, @NonNull WorkerParameters workerParameters) {
        Class<ListenableWorker> clazz;
        ListenableWorker worker = this.createWorker(appContext, workerClassName, workerParameters);
        if (worker != null) {
            return worker;
        }
        try {
            clazz = Class.forName(workerClassName).asSubclass(ListenableWorker.class);
        }
        catch (ClassNotFoundException e) {
            Logger.get().error(TAG, "Class not found: " + workerClassName, new Throwable[0]);
            return null;
        }
        try {
            Constructor<ListenableWorker> constructor = clazz.getDeclaredConstructor(Context.class, WorkerParameters.class);
            worker = constructor.newInstance(appContext, workerParameters);
            return worker;
        }
        catch (Exception e) {
            Logger.get().error(TAG, "Could not instantiate " + workerClassName, e);
            return null;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static WorkerFactory getDefaultWorkerFactory() {
        return new WorkerFactory(){

            @Override
            @Nullable
            public ListenableWorker createWorker(@NonNull Context appContext, @NonNull String workerClassName, @NonNull WorkerParameters workerParameters) {
                return null;
            }
        };
    }
}

