/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.model;

import android.arch.persistence.room.ColumnInfo;
import android.arch.persistence.room.Entity;
import android.arch.persistence.room.ForeignKey;
import android.arch.persistence.room.PrimaryKey;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import androidx.work.impl.model.WorkSpec;

@Entity(foreignKeys={@ForeignKey(entity=WorkSpec.class, parentColumns={"id"}, childColumns={"work_spec_id"}, onDelete=5, onUpdate=5)})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SystemIdInfo {
    @NonNull
    @PrimaryKey
    @ColumnInfo(name="work_spec_id")
    public final String workSpecId;
    @ColumnInfo(name="system_id")
    public final int systemId;

    public SystemIdInfo(@NonNull String workSpecId, int systemId) {
        this.workSpecId = workSpecId;
        this.systemId = systemId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemIdInfo that = (SystemIdInfo)o;
        if (this.systemId != that.systemId) {
            return false;
        }
        return this.workSpecId.equals(that.workSpecId);
    }

    public int hashCode() {
        int result = this.workSpecId.hashCode();
        result = 31 * result + this.systemId;
        return result;
    }
}

