/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import androidx.work.Logger;
import androidx.work.impl.Schedulers;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import java.util.List;
import java.util.concurrent.TimeUnit;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ForceStopRunnable
implements Runnable {
    private static final String TAG = Logger.tagWithPrefix("ForceStopRunnable");
    @VisibleForTesting
    static final String ACTION_FORCE_STOP_RESCHEDULE = "ACTION_FORCE_STOP_RESCHEDULE";
    private static final int ALARM_ID = -1;
    private static final long TEN_YEARS = TimeUnit.DAYS.toMillis(3650L);
    private final Context mContext;
    private final WorkManagerImpl mWorkManager;

    public ForceStopRunnable(@NonNull Context context, @NonNull WorkManagerImpl workManager) {
        this.mContext = context.getApplicationContext();
        this.mWorkManager = workManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.shouldRescheduleWorkers()) {
            Logger.get().debug(TAG, "Rescheduling Workers.", new Throwable[0]);
            this.mWorkManager.rescheduleEligibleWork();
            this.mWorkManager.getPreferences().setNeedsReschedule(false);
        } else if (this.isForceStopped()) {
            Logger.get().debug(TAG, "Application was force-stopped, rescheduling.", new Throwable[0]);
            this.mWorkManager.rescheduleEligibleWork();
        } else {
            WorkDatabase workDatabase = this.mWorkManager.getWorkDatabase();
            WorkSpecDao workSpecDao = workDatabase.workSpecDao();
            try {
                workDatabase.beginTransaction();
                List<WorkSpec> workSpecs = workSpecDao.getEnqueuedWork();
                if (workSpecs != null && !workSpecs.isEmpty()) {
                    Logger.get().debug(TAG, "Found unfinished work, scheduling it.", new Throwable[0]);
                    for (WorkSpec workSpec : workSpecs) {
                        workSpecDao.markWorkSpecScheduled(workSpec.id, -1L);
                    }
                    Schedulers.schedule(this.mWorkManager.getConfiguration(), workDatabase, this.mWorkManager.getSchedulers());
                }
                workDatabase.setTransactionSuccessful();
            }
            finally {
                workDatabase.endTransaction();
            }
            Logger.get().debug(TAG, "Unfinished Workers exist, rescheduling.", new Throwable[0]);
        }
        this.mWorkManager.onForceStopRunnableCompleted();
    }

    @VisibleForTesting
    public boolean isForceStopped() {
        PendingIntent pendingIntent = ForceStopRunnable.getPendingIntent(this.mContext, 0x20000000);
        if (pendingIntent == null) {
            ForceStopRunnable.setAlarm(this.mContext);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean shouldRescheduleWorkers() {
        return this.mWorkManager.getPreferences().needsReschedule();
    }

    private static PendingIntent getPendingIntent(Context context, int flags) {
        Intent intent = ForceStopRunnable.getIntent(context);
        return PendingIntent.getBroadcast((Context)context, (int)-1, (Intent)intent, (int)flags);
    }

    @VisibleForTesting
    static Intent getIntent(Context context) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(context, BroadcastReceiver.class));
        intent.setAction(ACTION_FORCE_STOP_RESCHEDULE);
        return intent;
    }

    static void setAlarm(Context context) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        PendingIntent pendingIntent = ForceStopRunnable.getPendingIntent(context, 0x8000000);
        long triggerAt = System.currentTimeMillis() + TEN_YEARS;
        if (alarmManager != null) {
            if (Build.VERSION.SDK_INT >= 19) {
                alarmManager.setExact(0, triggerAt, pendingIntent);
            } else {
                alarmManager.set(0, triggerAt, pendingIntent);
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class BroadcastReceiver
    extends android.content.BroadcastReceiver {
        private static final String TAG = Logger.tagWithPrefix("ForceStopRunnable$Rcvr");

        public void onReceive(Context context, Intent intent) {
            String action;
            if (intent != null && ForceStopRunnable.ACTION_FORCE_STOP_RESCHEDULE.equals(action = intent.getAction())) {
                Logger.get().verbose(TAG, "Rescheduling alarm that keeps track of force-stops.", new Throwable[0]);
                ForceStopRunnable.setAlarm(context);
            }
        }
    }
}

