/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import cn.bingoogolapple.androidcommon.adapter.BGAOnItemChildClickListener;
import cn.bingoogolapple.photopicker.R;
import cn.bingoogolapple.photopicker.activity.BGAPPToolbarActivity;
import cn.bingoogolapple.photopicker.activity.BGAPhotoPickerPreviewActivity;
import cn.bingoogolapple.photopicker.adapter.BGAPhotoPickerAdapter;
import cn.bingoogolapple.photopicker.model.BGAImageFolderModel;
import cn.bingoogolapple.photopicker.pw.BGAPhotoFolderPw;
import cn.bingoogolapple.photopicker.util.BGAImageCaptureManager;
import cn.bingoogolapple.photopicker.util.BGAPhotoPickerUtil;
import cn.bingoogolapple.photopicker.util.BGASpaceItemDecoration;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class BGAPhotoPickerActivity
extends BGAPPToolbarActivity
implements BGAOnItemChildClickListener {
    private static final String EXTRA_IMAGE_DIR = "EXTRA_IMAGE_DIR";
    private static final String EXTRA_SELECTED_IMAGES = "EXTRA_SELECTED_IMAGES";
    private static final String EXTRA_MAX_CHOOSE_COUNT = "EXTRA_MAX_CHOOSE_COUNT";
    private static final int REQUEST_CODE_TAKE_PHOTO = 1;
    private static final int REQUEST_CODE_PREVIEW = 2;
    private TextView mTitleTv;
    private ImageView mArrowIv;
    private TextView mSubmitTv;
    private RecyclerView mContentRv;
    private BGAImageFolderModel mCurrentImageFolderModel;
    private boolean mTakePhotoEnabled;
    private int mMaxChooseCount = 1;
    private String mTopRightBtnText;
    private ArrayList<BGAImageFolderModel> mImageFolderModels;
    private BGAPhotoPickerAdapter mPicAdapter;
    private BGAImageCaptureManager mImageCaptureManager;
    private BGAPhotoFolderPw mPhotoFolderPw;
    private long mLastShowPhotoFolderTime;

    public static Intent newIntent(Context context, File imageDir, int maxChooseCount, ArrayList<String> selectedImages) {
        Intent intent = new Intent(context, BGAPhotoPickerActivity.class);
        intent.putExtra(EXTRA_IMAGE_DIR, (Serializable)imageDir);
        intent.putExtra(EXTRA_MAX_CHOOSE_COUNT, maxChooseCount);
        intent.putStringArrayListExtra(EXTRA_SELECTED_IMAGES, selectedImages);
        return intent;
    }

    public static ArrayList<String> getSelectedImages(Intent intent) {
        return intent.getStringArrayListExtra(EXTRA_SELECTED_IMAGES);
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        this.setContentView(R.layout.bga_pp_activity_photo_picker);
        this.mContentRv = (RecyclerView)this.getViewById(R.id.rv_photo_picker_content);
    }

    @Override
    protected void setListener() {
        this.mPicAdapter = new BGAPhotoPickerAdapter(this.mContentRv);
        this.mPicAdapter.setOnItemChildClickListener(this);
    }

    @Override
    protected void processLogic(Bundle savedInstanceState) {
        File imageDir = (File)this.getIntent().getSerializableExtra(EXTRA_IMAGE_DIR);
        if (imageDir != null) {
            this.mTakePhotoEnabled = true;
            this.mImageCaptureManager = new BGAImageCaptureManager((Context)this, imageDir);
        }
        this.mMaxChooseCount = this.getIntent().getIntExtra(EXTRA_MAX_CHOOSE_COUNT, 1);
        if (this.mMaxChooseCount < 1) {
            this.mMaxChooseCount = 1;
        }
        this.mTopRightBtnText = this.getString(R.string.bga_pp_confirm);
        GridLayoutManager layoutManager = new GridLayoutManager((Context)this, 3, 1, false);
        this.mContentRv.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mContentRv.addItemDecoration((RecyclerView.ItemDecoration)new BGASpaceItemDecoration(this.getResources().getDimensionPixelSize(R.dimen.bga_pp_size_level1) / 4));
        this.mContentRv.setAdapter((RecyclerView.Adapter)this.mPicAdapter);
        this.mPicAdapter.setSelectedImages(this.getIntent().getStringArrayListExtra(EXTRA_SELECTED_IMAGES));
    }

    protected void onStart() {
        super.onStart();
        this.loadDatas();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.bga_pp_menu_photo_picker, menu2);
        MenuItem menuItem = menu2.findItem(R.id.item_photo_picker_title);
        View actionView = menuItem.getActionView();
        this.mTitleTv = (TextView)actionView.findViewById(R.id.tv_photo_picker_title);
        this.mArrowIv = (ImageView)actionView.findViewById(R.id.iv_photo_picker_arrow);
        this.mSubmitTv = (TextView)actionView.findViewById(R.id.tv_photo_picker_submit);
        this.mTitleTv.setOnClickListener((View.OnClickListener)this);
        this.mArrowIv.setOnClickListener((View.OnClickListener)this);
        this.mSubmitTv.setOnClickListener((View.OnClickListener)this);
        if (this.mCurrentImageFolderModel != null) {
            this.mTitleTv.setText((CharSequence)this.mCurrentImageFolderModel.name);
        }
        this.renderTopRightBtn();
        return true;
    }

    @Override
    public void onClick(View v) {
        if ((v.getId() == R.id.tv_photo_picker_title || v.getId() == R.id.iv_photo_picker_arrow) && System.currentTimeMillis() - this.mLastShowPhotoFolderTime > 300L) {
            this.showPhotoFolderPw();
            this.mLastShowPhotoFolderTime = System.currentTimeMillis();
        } else if (v.getId() == R.id.tv_photo_picker_submit) {
            this.returnSelectedImages(this.mPicAdapter.getSelectedImages());
        }
    }

    private void returnSelectedImages(ArrayList<String> selectedImages) {
        Intent intent = new Intent();
        intent.putStringArrayListExtra(EXTRA_SELECTED_IMAGES, selectedImages);
        this.setResult(-1, intent);
        this.finish();
    }

    private void showPhotoFolderPw() {
        if (this.mPhotoFolderPw == null) {
            this.mPhotoFolderPw = new BGAPhotoFolderPw((Activity)this, (View)this.mToolbar, new BGAPhotoFolderPw.Delegate(){

                @Override
                public void onSelectedFolder(int position) {
                    BGAPhotoPickerActivity.this.reloadPhotos(position);
                }

                @Override
                public void executeDismissAnim() {
                    ViewCompat.animate((View)BGAPhotoPickerActivity.this.mArrowIv).setDuration(300L).rotation(0.0f).start();
                }
            });
        }
        this.mPhotoFolderPw.setDatas(this.mImageFolderModels);
        this.mPhotoFolderPw.show();
        ViewCompat.animate((View)this.mArrowIv).setDuration(300L).rotation(-180.0f).start();
    }

    private void toastMaxCountTip() {
        BGAPhotoPickerUtil.show((Context)this, this.getString(R.string.bga_pp_toast_photo_picker_max, new Object[]{this.mMaxChooseCount}));
    }

    private void takePhoto() {
        try {
            this.startActivityForResult(this.mImageCaptureManager.getTakePictureIntent(), 1);
        }
        catch (Exception e) {
            BGAPhotoPickerUtil.show((Context)this, R.string.bga_pp_photo_not_support);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 1) {
                ArrayList<String> photos = new ArrayList<String>();
                photos.add(this.mImageCaptureManager.getCurrentPhotoPath());
                this.startActivityForResult(BGAPhotoPickerPreviewActivity.newIntent((Context)this, 1, photos, photos, 0, true), 2);
            } else if (requestCode == 2) {
                if (BGAPhotoPickerPreviewActivity.getIsFromTakePhoto(data)) {
                    this.mImageCaptureManager.refreshGallery();
                }
                this.returnSelectedImages(BGAPhotoPickerPreviewActivity.getSelectedImages(data));
            }
        } else if (resultCode == 0 && requestCode == 2) {
            if (BGAPhotoPickerPreviewActivity.getIsFromTakePhoto(data)) {
                this.mImageCaptureManager.deletePhotoFile();
            } else {
                this.mPicAdapter.setSelectedImages(BGAPhotoPickerPreviewActivity.getSelectedImages(data));
                this.renderTopRightBtn();
            }
        }
    }

    private void renderTopRightBtn() {
        if (this.mPicAdapter.getSelectedCount() == 0) {
            this.mSubmitTv.setEnabled(false);
            this.mSubmitTv.setText((CharSequence)this.mTopRightBtnText);
        } else {
            this.mSubmitTv.setEnabled(true);
            this.mSubmitTv.setText((CharSequence)(this.mTopRightBtnText + "(" + this.mPicAdapter.getSelectedCount() + "/" + this.mMaxChooseCount + ")"));
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        if (this.mTakePhotoEnabled) {
            this.mImageCaptureManager.onSaveInstanceState(outState);
        }
        super.onSaveInstanceState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        if (this.mTakePhotoEnabled) {
            this.mImageCaptureManager.onRestoreInstanceState(savedInstanceState);
        }
        super.onRestoreInstanceState(savedInstanceState);
    }

    private void loadDatas() {
        Cursor cursor = this.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_data"}, null, null, "date_added DESC");
        BGAImageFolderModel allImageFolderModel = new BGAImageFolderModel(this.mTakePhotoEnabled);
        HashMap<String, BGAImageFolderModel> imageFolderModelMap = new HashMap<String, BGAImageFolderModel>();
        BGAImageFolderModel otherImageFolderModel = null;
        if (cursor != null && cursor.getCount() > 0) {
            boolean firstInto = true;
            while (cursor.moveToNext()) {
                int end;
                String imagePath = cursor.getString(cursor.getColumnIndex("_data"));
                if (TextUtils.isEmpty((CharSequence)imagePath)) continue;
                if (firstInto) {
                    allImageFolderModel.name = this.getString(R.string.bga_pp_all_image);
                    allImageFolderModel.coverPath = imagePath;
                    firstInto = false;
                }
                allImageFolderModel.addLastImage(imagePath);
                String folderPath = null;
                File folder = new File(imagePath).getParentFile();
                if (folder != null) {
                    folderPath = folder.getAbsolutePath();
                }
                if (TextUtils.isEmpty(folderPath) && (end = imagePath.lastIndexOf(File.separator)) != -1) {
                    folderPath = imagePath.substring(0, end);
                }
                if (TextUtils.isEmpty((CharSequence)folderPath)) continue;
                if (imageFolderModelMap.containsKey(folderPath)) {
                    otherImageFolderModel = (BGAImageFolderModel)imageFolderModelMap.get(folderPath);
                } else {
                    String folderName = folderPath.substring(folderPath.lastIndexOf(File.separator) + 1);
                    if (TextUtils.isEmpty((CharSequence)folderName)) {
                        folderName = "/";
                    }
                    otherImageFolderModel = new BGAImageFolderModel(folderName, imagePath);
                    imageFolderModelMap.put(folderPath, otherImageFolderModel);
                }
                otherImageFolderModel.addLastImage(imagePath);
            }
            cursor.close();
        }
        this.mImageFolderModels = new ArrayList();
        this.mImageFolderModels.add(allImageFolderModel);
        Iterator iterator = imageFolderModelMap.entrySet().iterator();
        while (iterator.hasNext()) {
            this.mImageFolderModels.add((BGAImageFolderModel)iterator.next().getValue());
        }
        this.reloadPhotos(this.mPhotoFolderPw == null ? 0 : this.mPhotoFolderPw.getCurrentPosition());
    }

    private void reloadPhotos(int position) {
        this.mCurrentImageFolderModel = this.mImageFolderModels.get(position);
        if (this.mTitleTv != null) {
            this.mTitleTv.setText((CharSequence)this.mCurrentImageFolderModel.name);
        }
        this.mPicAdapter.setImageFolderModel(this.mCurrentImageFolderModel);
    }

    public void onItemChildClick(ViewGroup viewGroup, View view, int position) {
        if (view.getId() == R.id.iv_item_photo_picker_flag) {
            this.handleClickSelectFlagIv(position);
        } else if (view.getId() == R.id.iv_item_photo_picker_photo) {
            this.handleClickPreviewIv(position);
        }
    }

    private void handleClickSelectFlagIv(int position) {
        String currentImage = (String)this.mPicAdapter.getItem(position);
        if (this.mMaxChooseCount == 1) {
            if (this.mPicAdapter.getSelectedCount() > 0) {
                String selectedImage = this.mPicAdapter.getSelectedImages().remove(0);
                if (TextUtils.equals((CharSequence)selectedImage, (CharSequence)currentImage)) {
                    this.mPicAdapter.notifyItemChanged(position);
                } else {
                    int preSelectedImagePosition = this.mPicAdapter.getDatas().indexOf(selectedImage);
                    this.mPicAdapter.notifyItemChanged(preSelectedImagePosition);
                    this.mPicAdapter.getSelectedImages().add(currentImage);
                    this.mPicAdapter.notifyItemChanged(position);
                }
            } else {
                this.mPicAdapter.getSelectedImages().add(currentImage);
                this.mPicAdapter.notifyItemChanged(position);
            }
            this.renderTopRightBtn();
        } else if (!this.mPicAdapter.getSelectedImages().contains(currentImage) && this.mPicAdapter.getSelectedCount() == this.mMaxChooseCount) {
            this.toastMaxCountTip();
        } else {
            if (this.mPicAdapter.getSelectedImages().contains(currentImage)) {
                this.mPicAdapter.getSelectedImages().remove(currentImage);
            } else {
                this.mPicAdapter.getSelectedImages().add(currentImage);
            }
            this.mPicAdapter.notifyItemChanged(position);
            this.renderTopRightBtn();
        }
    }

    private void handleClickPreviewIv(int position) {
        if (this.mMaxChooseCount == 1) {
            if (this.mCurrentImageFolderModel.isTakePhotoEnabled() && position == 0) {
                this.takePhoto();
            } else {
                this.changeToPreview(position);
            }
        } else if (this.mCurrentImageFolderModel.isTakePhotoEnabled() && position == 0) {
            if (this.mPicAdapter.getSelectedCount() == this.mMaxChooseCount) {
                this.toastMaxCountTip();
            } else {
                this.takePhoto();
            }
        } else {
            this.changeToPreview(position);
        }
    }

    private void changeToPreview(int position) {
        int currentPosition = position;
        if (this.mCurrentImageFolderModel.isTakePhotoEnabled()) {
            --currentPosition;
        }
        this.startActivityForResult(BGAPhotoPickerPreviewActivity.newIntent((Context)this, this.mMaxChooseCount, this.mPicAdapter.getSelectedImages(), (ArrayList)this.mPicAdapter.getDatas(), currentPosition, false), 2);
    }
}

