/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.util;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import cn.bingoogolapple.photopicker.R;
import cn.bingoogolapple.photopicker.util.BGAAsyncTask;
import cn.bingoogolapple.photopicker.util.BGAPhotoPickerUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;

public class BGASavePhotoTask
extends BGAAsyncTask<Void, Void> {
    private Application mApplication;
    private SoftReference<Bitmap> mBitmap;
    private File mNewFile;

    public BGASavePhotoTask(BGAAsyncTask.Callback<Void> callback, Application application, File newFile) {
        super(callback);
        this.mApplication = application;
        this.mNewFile = newFile;
    }

    public void setBitmapAndPerform(Bitmap bitmap) {
        this.mBitmap = new SoftReference<Bitmap>(bitmap);
        if (Build.VERSION.SDK_INT >= 11) {
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        } else {
            this.execute(new Void[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground(Void ... params) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.mNewFile);
            this.mBitmap.get().compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            fos.flush();
            this.mApplication.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)this.mNewFile)));
            BGAPhotoPickerUtil.showSafe((Context)this.mApplication, this.mApplication.getString(R.string.bga_pp_save_img_success_folder, new Object[]{this.mNewFile.getParentFile().getAbsolutePath()}));
        }
        catch (Exception e) {
            BGAPhotoPickerUtil.showSafe((Context)this.mApplication, R.string.bga_pp_save_img_failure);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    BGAPhotoPickerUtil.showSafe((Context)this.mApplication, R.string.bga_pp_save_img_failure);
                }
            }
            this.recycleBitmap();
        }
        return null;
    }

    @Override
    protected void onCancelled() {
        super.onCancelled();
        this.recycleBitmap();
    }

    private void recycleBitmap() {
        if (this.mBitmap != null && this.mBitmap.get() != null && !this.mBitmap.get().isRecycled()) {
            this.mBitmap.get().recycle();
            this.mBitmap = null;
        }
    }
}

