/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import cn.bingoogolapple.androidcommon.adapter.BGAOnItemChildClickListener;
import cn.bingoogolapple.androidcommon.adapter.BGAOnRVItemClickListener;
import cn.bingoogolapple.androidcommon.adapter.BGARecyclerViewAdapter;
import cn.bingoogolapple.androidcommon.adapter.BGARecyclerViewHolder;
import cn.bingoogolapple.androidcommon.adapter.BGAViewHolderHelper;
import cn.bingoogolapple.photopicker.R;
import cn.bingoogolapple.photopicker.imageloader.BGAImage;
import cn.bingoogolapple.photopicker.util.BGAPhotoPickerUtil;
import cn.bingoogolapple.photopicker.util.BGASpaceItemDecoration;
import java.util.ArrayList;

public class BGASortableNinePhotoLayout
extends RecyclerView
implements BGAOnItemChildClickListener,
BGAOnRVItemClickListener {
    private static final int MAX_ITEM_COUNT = 9;
    private static final int MAX_SPAN_COUNT = 3;
    private PhotoAdapter mPhotoAdapter;
    private ItemTouchHelper mItemTouchHelper;
    private Delegate mDelegate;
    private GridLayoutManager mGridLayoutManager;
    private boolean mIsPlusSwitchOpened = true;
    private boolean mIsDragable = true;

    public BGASortableNinePhotoLayout(Context context) {
        this(context, null);
    }

    public BGASortableNinePhotoLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BGASortableNinePhotoLayout(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setOverScrollMode(2);
        this.initAttrs(context, attrs);
        this.mItemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)new ItemTouchHelperCallback());
        this.mItemTouchHelper.attachToRecyclerView((RecyclerView)this);
        this.mGridLayoutManager = new GridLayoutManager(context, 3);
        this.setLayoutManager((RecyclerView.LayoutManager)this.mGridLayoutManager);
        this.addItemDecoration(new BGASpaceItemDecoration(this.getResources().getDimensionPixelSize(R.dimen.bga_pp_size_photo_divider)));
        this.mPhotoAdapter = new PhotoAdapter(this);
        this.mPhotoAdapter.setOnItemChildClickListener(this);
        this.mPhotoAdapter.setOnRVItemClickListener(this);
        this.setAdapter((RecyclerView.Adapter)this.mPhotoAdapter);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BGASortableNinePhotoLayout);
        int N = typedArray.getIndexCount();
        for (int i = 0; i < N; ++i) {
            this.initAttr(typedArray.getIndex(i), typedArray);
        }
        typedArray.recycle();
    }

    private void initAttr(int attr2, TypedArray typedArray) {
        if (attr2 == R.styleable.BGASortableNinePhotoLayout_bga_snpl_isPlusSwitchOpened) {
            this.mIsPlusSwitchOpened = typedArray.getBoolean(attr2, this.mIsPlusSwitchOpened);
        } else if (attr2 == R.styleable.BGASortableNinePhotoLayout_bga_snpl_isDragable) {
            this.mIsDragable = typedArray.getBoolean(attr2, this.mIsDragable);
        }
    }

    public void setData(ArrayList<String> photos) {
        this.mPhotoAdapter.setDatas(photos);
        this.updateHeight();
    }

    private void updateHeight() {
        if (this.mPhotoAdapter.getItemCount() > 0 && this.mPhotoAdapter.getItemCount() < 3) {
            this.mGridLayoutManager.setSpanCount(this.mPhotoAdapter.getItemCount());
        } else {
            this.mGridLayoutManager.setSpanCount(3);
        }
        int itemWidth = BGAPhotoPickerUtil.getScreenWidth(this.getContext()) / 4;
        int width = itemWidth * this.mGridLayoutManager.getSpanCount();
        int height = 0;
        if (this.mPhotoAdapter.getItemCount() != 0) {
            int rowCount = (this.mPhotoAdapter.getItemCount() - 1) / this.mGridLayoutManager.getSpanCount() + 1;
            height = itemWidth * rowCount;
        }
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        layoutParams.width = width;
        layoutParams.height = height;
        this.setLayoutParams(layoutParams);
    }

    public ArrayList<String> getData() {
        return (ArrayList)this.mPhotoAdapter.getDatas();
    }

    public void removeItem(int position) {
        this.mPhotoAdapter.removeItem(position);
        this.updateHeight();
    }

    public int getItemCount() {
        return this.mPhotoAdapter.getDatas().size();
    }

    public void onItemChildClick(ViewGroup parent, View childView, int position) {
        if (this.mDelegate != null) {
            this.mDelegate.onClickDeleteNinePhotoItem(this, childView, position, this.mPhotoAdapter.getItem(position), (ArrayList)this.mPhotoAdapter.getDatas());
        }
    }

    public void onRVItemClick(ViewGroup parent, View itemView, int position) {
        if (this.mPhotoAdapter.isPlusItem(position)) {
            if (this.mDelegate != null) {
                this.mDelegate.onClickAddNinePhotoItem(this, itemView, position, (ArrayList)this.mPhotoAdapter.getDatas());
            }
        } else if (this.mDelegate != null && ViewCompat.getScaleX((View)itemView) <= 1.0f) {
            this.mDelegate.onClickNinePhotoItem(this, itemView, position, this.mPhotoAdapter.getItem(position), (ArrayList)this.mPhotoAdapter.getDatas());
        }
    }

    public void setIsPlusSwitchOpened(boolean isPlusSwitchOpened) {
        this.mIsPlusSwitchOpened = isPlusSwitchOpened;
        this.updateHeight();
    }

    public void setDelegate(Delegate delegate) {
        this.mDelegate = delegate;
    }

    public static interface Delegate {
        public void onClickAddNinePhotoItem(BGASortableNinePhotoLayout var1, View var2, int var3, ArrayList<String> var4);

        public void onClickDeleteNinePhotoItem(BGASortableNinePhotoLayout var1, View var2, int var3, String var4, ArrayList<String> var5);

        public void onClickNinePhotoItem(BGASortableNinePhotoLayout var1, View var2, int var3, String var4, ArrayList<String> var5);
    }

    private class ItemTouchHelperCallback
    extends ItemTouchHelper.Callback {
        private ItemTouchHelperCallback() {
        }

        public boolean isLongPressDragEnabled() {
            return BGASortableNinePhotoLayout.this.mIsDragable && BGASortableNinePhotoLayout.this.mPhotoAdapter.getDatas().size() > 1;
        }

        public boolean isItemViewSwipeEnabled() {
            return false;
        }

        public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            int dragFlags;
            if (BGASortableNinePhotoLayout.this.mPhotoAdapter.isPlusItem(viewHolder.getAdapterPosition())) {
                return 0;
            }
            int swipeFlags = dragFlags = 51;
            return ItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
        }

        public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder source, RecyclerView.ViewHolder target) {
            if (source.getItemViewType() != target.getItemViewType() || BGASortableNinePhotoLayout.this.mPhotoAdapter.isPlusItem(target.getAdapterPosition())) {
                return false;
            }
            BGASortableNinePhotoLayout.this.mPhotoAdapter.moveItem(source.getAdapterPosition(), target.getAdapterPosition());
            return true;
        }

        public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        }

        public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        }

        public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
            if (actionState != 0) {
                ViewCompat.setScaleX((View)viewHolder.itemView, (float)1.2f);
                ViewCompat.setScaleY((View)viewHolder.itemView, (float)1.2f);
                ((BGARecyclerViewHolder)viewHolder).getViewHolderHelper().getImageView(R.id.iv_item_nine_photo_photo).setColorFilter(BGASortableNinePhotoLayout.this.getResources().getColor(R.color.bga_pp_photo_selected_mask));
            }
            super.onSelectedChanged(viewHolder, actionState);
        }

        public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            ViewCompat.setScaleX((View)viewHolder.itemView, (float)1.0f);
            ViewCompat.setScaleY((View)viewHolder.itemView, (float)1.0f);
            ((BGARecyclerViewHolder)viewHolder).getViewHolderHelper().getImageView(R.id.iv_item_nine_photo_photo).setColorFilter(null);
            super.clearView(recyclerView, viewHolder);
        }
    }

    private class PhotoAdapter
    extends BGARecyclerViewAdapter<String> {
        private int mImageWidth;
        private int mImageHeight;

        public PhotoAdapter(RecyclerView recyclerView) {
            super(recyclerView, R.layout.bga_pp_item_nine_photo);
            this.mImageHeight = this.mImageWidth = BGAPhotoPickerUtil.getScreenWidth(recyclerView.getContext()) / 6;
        }

        protected void setItemChildListener(BGAViewHolderHelper helper) {
            helper.setItemChildClickListener(R.id.iv_item_nine_photo_flag);
        }

        public int getItemCount() {
            if (BGASortableNinePhotoLayout.this.mIsPlusSwitchOpened && super.getItemCount() < 9) {
                return super.getItemCount() + 1;
            }
            return super.getItemCount();
        }

        public String getItem(int position) {
            if (this.isPlusItem(position)) {
                return null;
            }
            return (String)super.getItem(position);
        }

        public boolean isPlusItem(int position) {
            return BGASortableNinePhotoLayout.this.mIsPlusSwitchOpened && super.getItemCount() < 9 && position == this.getItemCount() - 1;
        }

        protected void fillData(BGAViewHolderHelper helper, int position, String model) {
            if (this.isPlusItem(position)) {
                helper.setVisibility(R.id.iv_item_nine_photo_flag, 8);
                helper.setImageResource(R.id.iv_item_nine_photo_photo, R.mipmap.bga_pp_ic_plus);
            } else {
                helper.setVisibility(R.id.iv_item_nine_photo_flag, 0);
                BGAImage.displayImage(helper.getImageView(R.id.iv_item_nine_photo_photo), model, R.mipmap.bga_pp_ic_holder_light, R.mipmap.bga_pp_ic_holder_light, this.mImageWidth, this.mImageHeight, null);
            }
        }
    }
}

