/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.view.View;
import android.widget.ImageView;
import cn.bingoogolapple.photopicker.imageloader.BGAImageLoader;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;

public class BGAGlideImageloader
implements BGAImageLoader {
    @Override
    public void displayImage(final ImageView imageView, String path, @DrawableRes int loadingResId, @DrawableRes int failResId, int width, int height, final BGAImageLoader.DisplayDelegate delegate) {
        if (path == null) {
            path = "";
        }
        if (!path.startsWith("http") && !path.startsWith("file")) {
            path = "file://" + path;
        }
        final String finalPath = path;
        Glide.with((Context)imageView.getContext()).load(finalPath).asBitmap().placeholder(loadingResId).error(failResId).override(width, height).listener((RequestListener)new RequestListener<String, Bitmap>(){

            public boolean onException(Exception e, String model, Target<Bitmap> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(Bitmap resource, String model, Target<Bitmap> target, boolean isFromMemoryCache, boolean isFirstResource) {
                if (delegate != null) {
                    delegate.onSuccess((View)imageView, finalPath);
                }
                return false;
            }
        }).into(imageView);
    }

    @Override
    public void downloadImage(Context context, String path, final BGAImageLoader.DownloadDelegate delegate) {
        if (path == null) {
            path = "";
        }
        if (!path.startsWith("http") && !path.startsWith("file")) {
            path = "file://" + path;
        }
        final String finalPath = path;
        Glide.with((Context)context).load(finalPath).asBitmap().into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
                if (delegate != null) {
                    delegate.onSuccess(finalPath, resource);
                }
            }

            public void onLoadFailed(Exception e, Drawable errorDrawable) {
                if (delegate != null) {
                    delegate.onFailed(finalPath);
                }
            }
        });
    }
}

