/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.pw;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.view.KeyEvent;
import android.view.View;
import android.widget.PopupWindow;

public abstract class BGABasePopupWindow
extends PopupWindow
implements View.OnClickListener {
    protected Activity mActivity;
    protected View mWindowRootView;
    protected View mAnchorView;

    public BGABasePopupWindow(Activity activity, @LayoutRes int layoutId, View anchorView, int width, int height) {
        super(View.inflate((Context)activity, (int)layoutId, null), width, height, true);
        this.init(activity, anchorView);
        this.initView();
        this.setListener();
        this.processLogic();
    }

    private void init(Activity activity, View anchorView) {
        this.getContentView().setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    BGABasePopupWindow.this.dismiss();
                    return true;
                }
                return false;
            }
        });
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mAnchorView = anchorView;
        this.mActivity = activity;
        this.mWindowRootView = activity.getWindow().peekDecorView();
    }

    protected abstract void initView();

    protected abstract void setListener();

    protected abstract void processLogic();

    public abstract void show();

    public void onClick(View view) {
    }

    protected <VT extends View> VT getViewById(@IdRes int id2) {
        return (VT)this.getContentView().findViewById(id2);
    }
}

