/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.adapter;

import android.app.Activity;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import cn.bingoogolapple.photopicker.R;
import cn.bingoogolapple.photopicker.imageloader.BGAImage;
import cn.bingoogolapple.photopicker.util.BGAPhotoPickerUtil;
import cn.bingoogolapple.photopicker.widget.BGAImageView;
import java.util.ArrayList;
import uk.co.senab.photoview.PhotoViewAttacher;

public class BGAPhotoPageAdapter
extends PagerAdapter {
    private ArrayList<String> mPreviewImages;
    private PhotoViewAttacher.OnViewTapListener mOnViewTapListener;
    private Activity mActivity;

    public BGAPhotoPageAdapter(Activity activity, PhotoViewAttacher.OnViewTapListener onViewTapListener, ArrayList<String> previewImages) {
        this.mOnViewTapListener = onViewTapListener;
        this.mPreviewImages = previewImages;
        this.mActivity = activity;
    }

    public int getCount() {
        return this.mPreviewImages == null ? 0 : this.mPreviewImages.size();
    }

    public View instantiateItem(ViewGroup container, int position) {
        BGAImageView imageView = new BGAImageView(container.getContext());
        container.addView((View)imageView, -1, -1);
        final PhotoViewAttacher photoViewAttacher = new PhotoViewAttacher((ImageView)imageView);
        photoViewAttacher.setOnViewTapListener(this.mOnViewTapListener);
        imageView.setDelegate(new BGAImageView.Delegate(){

            @Override
            public void onDrawableChanged() {
                photoViewAttacher.update();
            }
        });
        BGAImage.displayImage(this.mActivity, (ImageView)imageView, this.mPreviewImages.get(position), R.mipmap.bga_pp_ic_holder_dark, R.mipmap.bga_pp_ic_holder_dark, BGAPhotoPickerUtil.getScreenWidth(imageView.getContext()), BGAPhotoPickerUtil.getScreenHeight(imageView.getContext()), null);
        return imageView;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public String getItem(int position) {
        return this.mPreviewImages == null ? "" : this.mPreviewImages.get(position);
    }
}

