/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.util;

import android.content.Context;
import android.database.Cursor;
import android.os.AsyncTask;
import android.os.Build;
import android.provider.MediaStore;
import android.text.TextUtils;
import cn.bingoogolapple.photopicker.R;
import cn.bingoogolapple.photopicker.model.BGAImageFolderModel;
import cn.bingoogolapple.photopicker.util.BGAAsyncTask;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class BGALoadPhotoTask
extends BGAAsyncTask<Void, ArrayList<BGAImageFolderModel>> {
    private Context mContext;
    private boolean mTakePhotoEnabled;

    public BGALoadPhotoTask(BGAAsyncTask.Callback<ArrayList<BGAImageFolderModel>> callback, Context context, boolean takePhotoEnabled) {
        super(callback);
        this.mContext = context.getApplicationContext();
        this.mTakePhotoEnabled = takePhotoEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<BGAImageFolderModel> doInBackground(Void ... voids) {
        ArrayList<BGAImageFolderModel> imageFolderModels = new ArrayList<BGAImageFolderModel>();
        BGAImageFolderModel allImageFolderModel = new BGAImageFolderModel(this.mTakePhotoEnabled);
        HashMap<String, BGAImageFolderModel> imageFolderModelMap = new HashMap<String, BGAImageFolderModel>();
        try (Cursor cursor = null;){
            cursor = this.mContext.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, new String[]{"_data"}, null, null, "date_added DESC");
            if (cursor != null && cursor.getCount() > 0) {
                boolean firstInto = true;
                while (cursor.moveToNext()) {
                    BGAImageFolderModel otherImageFolderModel;
                    int end;
                    String imagePath = cursor.getString(cursor.getColumnIndex("_data"));
                    if (TextUtils.isEmpty((CharSequence)imagePath)) continue;
                    if (firstInto) {
                        allImageFolderModel.name = this.mContext.getString(R.string.bga_pp_all_image);
                        allImageFolderModel.coverPath = imagePath;
                        firstInto = false;
                    }
                    allImageFolderModel.addLastImage(imagePath);
                    String folderPath = null;
                    File folder = new File(imagePath).getParentFile();
                    if (folder != null) {
                        folderPath = folder.getAbsolutePath();
                    }
                    if (TextUtils.isEmpty(folderPath) && (end = imagePath.lastIndexOf(File.separator)) != -1) {
                        folderPath = imagePath.substring(0, end);
                    }
                    if (TextUtils.isEmpty((CharSequence)folderPath)) continue;
                    if (imageFolderModelMap.containsKey(folderPath)) {
                        otherImageFolderModel = (BGAImageFolderModel)imageFolderModelMap.get(folderPath);
                    } else {
                        String folderName = folderPath.substring(folderPath.lastIndexOf(File.separator) + 1);
                        if (TextUtils.isEmpty((CharSequence)folderName)) {
                            folderName = "/";
                        }
                        otherImageFolderModel = new BGAImageFolderModel(folderName, imagePath);
                        imageFolderModelMap.put(folderPath, otherImageFolderModel);
                    }
                    otherImageFolderModel.addLastImage(imagePath);
                }
                imageFolderModels.add(allImageFolderModel);
                Iterator iterator = imageFolderModelMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    imageFolderModels.add((BGAImageFolderModel)iterator.next().getValue());
                }
            }
        }
        return imageFolderModels;
    }

    public BGALoadPhotoTask perform() {
        if (Build.VERSION.SDK_INT >= 11) {
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        } else {
            this.execute(new Void[0]);
        }
        return this;
    }
}

