/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import cn.bingoogolapple.photopicker.R;

public class BGAImageView
extends AppCompatImageView {
    private int mDefaultImageId;
    private int mCornerRadius = 0;
    private boolean mIsCircle = false;
    private boolean mIsSquare = false;
    private int mBorderWidth = 0;
    private int mBorderColor = -1;
    private Paint mBorderPaint;
    private Delegate mDelegate;

    public BGAImageView(Context context) {
        this(context, null);
    }

    public BGAImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BGAImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initCustomAttrs(context, attrs);
        this.initBorderPaint();
        this.setDefaultImage();
    }

    private void initBorderPaint() {
        this.mBorderPaint = new Paint();
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
    }

    private void initCustomAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BGAImageView);
        int N = typedArray.getIndexCount();
        for (int i = 0; i < N; ++i) {
            this.initCustomAttr(typedArray.getIndex(i), typedArray);
        }
        typedArray.recycle();
    }

    private void initCustomAttr(int attr2, TypedArray typedArray) {
        if (attr2 == R.styleable.BGAImageView_android_src) {
            this.mDefaultImageId = typedArray.getResourceId(attr2, 0);
        } else if (attr2 == R.styleable.BGAImageView_bga_iv_isCircle) {
            this.mIsCircle = typedArray.getBoolean(attr2, this.mIsCircle);
        } else if (attr2 == R.styleable.BGAImageView_bga_iv_cornerRadius) {
            this.mCornerRadius = typedArray.getDimensionPixelSize(attr2, this.mCornerRadius);
        } else if (attr2 == R.styleable.BGAImageView_bga_iv_isSquare) {
            this.mIsSquare = typedArray.getBoolean(attr2, this.mIsSquare);
        } else if (attr2 == R.styleable.BGAImageView_bga_iv_borderWidth) {
            this.mBorderWidth = typedArray.getDimensionPixelSize(attr2, this.mBorderWidth);
        } else if (attr2 == R.styleable.BGAImageView_bga_iv_borderColor) {
            this.mBorderColor = typedArray.getColor(attr2, this.mBorderColor);
        }
    }

    private void setDefaultImage() {
        if (this.mDefaultImageId != 0) {
            this.setImageResource(this.mDefaultImageId);
        }
    }

    public void setImageResource(@DrawableRes int resId) {
        this.setImageDrawable(this.getResources().getDrawable(resId));
    }

    public void setImageDrawable(@Nullable Drawable drawable) {
        if (drawable instanceof BitmapDrawable && this.mCornerRadius > 0) {
            Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
            if (bitmap != null) {
                super.setImageDrawable((Drawable)BGAImageView.getRoundedDrawable(this.getContext(), bitmap, this.mCornerRadius));
            } else {
                super.setImageDrawable(drawable);
            }
        } else if (drawable instanceof BitmapDrawable && this.mIsCircle) {
            Bitmap bitmap = ((BitmapDrawable)drawable).getBitmap();
            if (bitmap != null) {
                super.setImageDrawable((Drawable)BGAImageView.getCircleDrawable(this.getContext(), bitmap));
            } else {
                super.setImageDrawable(drawable);
            }
        } else {
            super.setImageDrawable(drawable);
        }
        this.notifyDrawableChanged();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mIsCircle || this.mIsSquare) {
            this.setMeasuredDimension(BGAImageView.getDefaultSize((int)0, (int)widthMeasureSpec), BGAImageView.getDefaultSize((int)0, (int)heightMeasureSpec));
            int childWidthSize = this.getMeasuredWidth();
            heightMeasureSpec = widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childWidthSize, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mIsCircle && this.mBorderWidth > 0) {
            canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)(this.getWidth() / 2) - 1.0f * (float)this.mBorderWidth / 2.0f, this.mBorderPaint);
        }
    }

    private void notifyDrawableChanged() {
        if (this.mDelegate != null) {
            this.mDelegate.onDrawableChanged();
        }
    }

    public void setDelegate(Delegate delegate) {
        this.mDelegate = delegate;
    }

    public static RoundedBitmapDrawable getCircleDrawable(Context context, Bitmap bitmap) {
        RoundedBitmapDrawable circleDrawable = RoundedBitmapDrawableFactory.create((Resources)context.getResources(), (Bitmap)bitmap);
        circleDrawable.setAntiAlias(true);
        circleDrawable.setCircular(true);
        return circleDrawable;
    }

    public static RoundedBitmapDrawable getRoundedDrawable(Context context, Bitmap bitmap, float cornerRadius) {
        RoundedBitmapDrawable roundedBitmapDrawable = RoundedBitmapDrawableFactory.create((Resources)context.getResources(), (Bitmap)bitmap);
        roundedBitmapDrawable.setAntiAlias(true);
        roundedBitmapDrawable.setCornerRadius(cornerRadius);
        return roundedBitmapDrawable;
    }

    public static interface Delegate {
        public void onDrawableChanged();
    }
}

