/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.widget;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import cn.bingoogolapple.androidcommon.adapter.BGAAdapterViewAdapter;
import cn.bingoogolapple.androidcommon.adapter.BGAViewHolderHelper;
import cn.bingoogolapple.photopicker.R;
import cn.bingoogolapple.photopicker.imageloader.BGAImage;
import cn.bingoogolapple.photopicker.util.BGAPhotoPickerUtil;
import cn.bingoogolapple.photopicker.widget.BGAHeightWrapGridView;
import java.util.ArrayList;
import java.util.List;

public class BGANinePhotoLayout
extends FrameLayout
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener,
View.OnClickListener,
View.OnLongClickListener {
    private PhotoAdapter mPhotoAdapter;
    private ImageView mPhotoIv;
    private BGAHeightWrapGridView mPhotoGv;
    private Delegate mDelegate;
    private int mCurrentClickItemPosition;
    private Activity mActivity;

    public BGANinePhotoLayout(Context context) {
        this(context, null);
    }

    public BGANinePhotoLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BGANinePhotoLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPhotoIv = new ImageView(context);
        this.mPhotoIv.setClickable(true);
        this.mPhotoIv.setOnClickListener((View.OnClickListener)this);
        this.mPhotoIv.setOnLongClickListener((View.OnLongClickListener)this);
        this.mPhotoGv = new BGAHeightWrapGridView(context);
        int spacing = context.getResources().getDimensionPixelSize(R.dimen.bga_pp_size_photo_divider);
        this.mPhotoGv.setHorizontalSpacing(spacing);
        this.mPhotoGv.setVerticalSpacing(spacing);
        this.mPhotoGv.setNumColumns(3);
        this.mPhotoGv.setOnItemClickListener(this);
        this.mPhotoGv.setOnItemLongClickListener(this);
        this.mPhotoAdapter = new PhotoAdapter(context);
        this.mPhotoGv.setAdapter((ListAdapter)this.mPhotoAdapter);
        this.addView((View)this.mPhotoIv, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.addView((View)this.mPhotoGv);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
        this.mCurrentClickItemPosition = position;
        if (this.mDelegate != null) {
            this.mDelegate.onClickNinePhotoItem(this, view, this.mCurrentClickItemPosition, (String)this.mPhotoAdapter.getItem(this.mCurrentClickItemPosition), this.mPhotoAdapter.getDatas());
        }
    }

    public boolean onItemLongClick(AdapterView<?> adapterView, View view, int position, long l) {
        this.mCurrentClickItemPosition = position;
        if (this.mDelegate != null) {
            return this.mDelegate.onLongClickNinePhotoItem(this, view, position, (String)this.mPhotoAdapter.getItem(position), this.mPhotoAdapter.getDatas());
        }
        return false;
    }

    public void onClick(View view) {
        this.mCurrentClickItemPosition = 0;
        if (this.mDelegate != null) {
            this.mDelegate.onClickNinePhotoItem(this, view, this.mCurrentClickItemPosition, (String)this.mPhotoAdapter.getItem(this.mCurrentClickItemPosition), this.mPhotoAdapter.getDatas());
        }
    }

    public boolean onLongClick(View view) {
        this.mCurrentClickItemPosition = 0;
        if (this.mDelegate != null) {
            return this.mDelegate.onLongClickNinePhotoItem(this, view, this.mCurrentClickItemPosition, (String)this.mPhotoAdapter.getItem(this.mCurrentClickItemPosition), this.mPhotoAdapter.getDatas());
        }
        return false;
    }

    public void init(Activity activity) {
        this.mActivity = activity;
    }

    public void setData(ArrayList<String> photos) {
        if (this.mActivity == null) {
            throw new RuntimeException("\u8bf7\u5148\u8c03\u7528init\u65b9\u6cd5\u8fdb\u884c\u521d\u59cb\u5316");
        }
        int itemWidth = BGAPhotoPickerUtil.getScreenWidth(this.getContext()) / 4;
        if (photos.size() == 0) {
            this.setVisibility(8);
        } else if (photos.size() == 1) {
            this.setVisibility(0);
            this.mPhotoGv.setVisibility(8);
            this.mPhotoAdapter.setDatas(photos);
            this.mPhotoIv.setVisibility(0);
            this.mPhotoIv.setMaxWidth(itemWidth * 2);
            this.mPhotoIv.setMaxHeight(itemWidth * 2);
            BGAImage.displayImage(this.mActivity, this.mPhotoIv, photos.get(0), R.mipmap.bga_pp_ic_holder_light, R.mipmap.bga_pp_ic_holder_light, itemWidth * 2, itemWidth * 2, null);
        } else {
            this.setVisibility(0);
            this.mPhotoIv.setVisibility(8);
            this.mPhotoGv.setVisibility(0);
            ViewGroup.LayoutParams layoutParams = this.mPhotoGv.getLayoutParams();
            if (photos.size() == 2) {
                this.mPhotoGv.setNumColumns(2);
                layoutParams.width = itemWidth * 2;
                layoutParams.height = itemWidth * 1;
            } else if (photos.size() == 4) {
                this.mPhotoGv.setNumColumns(2);
                layoutParams.width = itemWidth * 2;
                layoutParams.height = itemWidth * 2;
            } else {
                this.mPhotoGv.setNumColumns(3);
                layoutParams.width = itemWidth * 3;
                layoutParams.height = itemWidth * 3;
            }
            this.mPhotoGv.setLayoutParams(layoutParams);
            this.mPhotoAdapter.setDatas(photos);
        }
    }

    public void setDelegate(Delegate delegate) {
        this.mDelegate = delegate;
    }

    public ArrayList<String> getData() {
        return (ArrayList)this.mPhotoAdapter.getDatas();
    }

    public int getItemCount() {
        return this.mPhotoAdapter.getCount();
    }

    public String getCurrentClickItem() {
        return (String)this.mPhotoAdapter.getItem(this.mCurrentClickItemPosition);
    }

    public int getCurrentClickItemPosition() {
        return this.mCurrentClickItemPosition;
    }

    public static abstract class SimpleDelegate
    implements Delegate {
        @Override
        public boolean onLongClickNinePhotoItem(BGANinePhotoLayout ninePhotoLayout, View view, int position, String model, List<String> models) {
            return false;
        }
    }

    public static interface Delegate {
        public void onClickNinePhotoItem(BGANinePhotoLayout var1, View var2, int var3, String var4, List<String> var5);

        public boolean onLongClickNinePhotoItem(BGANinePhotoLayout var1, View var2, int var3, String var4, List<String> var5);
    }

    private class PhotoAdapter
    extends BGAAdapterViewAdapter<String> {
        private int mImageWidth;
        private int mImageHeight;

        public PhotoAdapter(Context context) {
            super(context, R.layout.bga_pp_item_nine_photo);
            this.mImageHeight = this.mImageWidth = BGAPhotoPickerUtil.getScreenWidth(context) / 6;
        }

        protected void fillData(BGAViewHolderHelper helper, int position, String model) {
            BGAImage.displayImage(BGANinePhotoLayout.this.mActivity, helper.getImageView(R.id.iv_item_nine_photo_photo), model, R.mipmap.bga_pp_ic_holder_light, R.mipmap.bga_pp_ic_holder_light, this.mImageWidth, this.mImageHeight, null);
        }
    }
}

