/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BGAImageCaptureManager {
    private static final String CAPTURED_PHOTO_PATH_KEY = "CAPTURED_PHOTO_PATH_KEY";
    private String mCurrentPhotoPath;
    private Context mContext;
    private File mImageDir;

    public BGAImageCaptureManager(Context context, File imageDir) {
        this.mContext = context;
        this.mImageDir = imageDir;
        if (!this.mImageDir.exists()) {
            this.mImageDir.mkdirs();
        }
    }

    private File createImageFile() throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        String imageFileName = "JPEG_" + timeStamp + "_";
        File image = File.createTempFile(imageFileName, ".jpg", this.mImageDir);
        this.mCurrentPhotoPath = image.getAbsolutePath();
        return image;
    }

    public Intent getTakePictureIntent() throws IOException {
        File photoFile;
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.mContext.getPackageManager()) != null && (photoFile = this.createImageFile()) != null) {
            takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)photoFile));
        }
        return takePictureIntent;
    }

    public void refreshGallery() {
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentPhotoPath)) {
            Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
            mediaScanIntent.setData(Uri.fromFile((File)new File(this.mCurrentPhotoPath)));
            this.mContext.sendBroadcast(mediaScanIntent);
            this.mCurrentPhotoPath = null;
        }
    }

    public void deletePhotoFile() {
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentPhotoPath)) {
            try {
                File photoFile = new File(this.mCurrentPhotoPath);
                photoFile.delete();
                this.mCurrentPhotoPath = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getCurrentPhotoPath() {
        return this.mCurrentPhotoPath;
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null && this.mCurrentPhotoPath != null) {
            savedInstanceState.putString(CAPTURED_PHOTO_PATH_KEY, this.mCurrentPhotoPath);
        }
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null && savedInstanceState.containsKey(CAPTURED_PHOTO_PATH_KEY)) {
            this.mCurrentPhotoPath = savedInstanceState.getString(CAPTURED_PHOTO_PATH_KEY);
        }
    }
}

