/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.TextView;
import cn.bingoogolapple.androidcommon.adapter.BGAOnNoDoubleClickListener;
import cn.bingoogolapple.photopicker.R;
import cn.bingoogolapple.photopicker.activity.BGAPPToolbarActivity;
import cn.bingoogolapple.photopicker.adapter.BGAPhotoPageAdapter;
import cn.bingoogolapple.photopicker.imageloader.BGAImage;
import cn.bingoogolapple.photopicker.imageloader.BGAImageLoader;
import cn.bingoogolapple.photopicker.util.BGAAsyncTask;
import cn.bingoogolapple.photopicker.util.BGAPhotoPickerUtil;
import cn.bingoogolapple.photopicker.util.BGASavePhotoTask;
import cn.bingoogolapple.photopicker.widget.BGAHackyViewPager;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import uk.co.senab.photoview.PhotoViewAttacher;

public class BGAPhotoPreviewActivity
extends BGAPPToolbarActivity
implements PhotoViewAttacher.OnViewTapListener,
BGAAsyncTask.Callback<Void> {
    private static final String EXTRA_SAVE_IMG_DIR = "EXTRA_SAVE_IMG_DIR";
    private static final String EXTRA_PREVIEW_IMAGES = "EXTRA_PREVIEW_IMAGES";
    private static final String EXTRA_CURRENT_POSITION = "EXTRA_CURRENT_POSITION";
    private static final String EXTRA_IS_SINGLE_PREVIEW = "EXTRA_IS_SINGLE_PREVIEW";
    private static final String EXTRA_PHOTO_PATH = "EXTRA_PHOTO_PATH";
    private TextView mTitleTv;
    private ImageView mDownloadIv;
    private BGAHackyViewPager mContentHvp;
    private BGAPhotoPageAdapter mPhotoPageAdapter;
    private boolean mIsSinglePreview;
    private File mSaveImgDir;
    private boolean mIsHidden = false;
    private BGASavePhotoTask mSavePhotoTask;
    private long mLastShowHiddenTime;

    public static Intent newIntent(Context context, File saveImgDir, ArrayList<String> previewImages, int currentPosition) {
        Intent intent = new Intent(context, BGAPhotoPreviewActivity.class);
        intent.putExtra(EXTRA_SAVE_IMG_DIR, (Serializable)saveImgDir);
        intent.putStringArrayListExtra(EXTRA_PREVIEW_IMAGES, previewImages);
        intent.putExtra(EXTRA_CURRENT_POSITION, currentPosition);
        intent.putExtra(EXTRA_IS_SINGLE_PREVIEW, false);
        return intent;
    }

    public static Intent newIntent(Context context, File saveImgDir, String photoPath) {
        Intent intent = new Intent(context, BGAPhotoPreviewActivity.class);
        intent.putExtra(EXTRA_SAVE_IMG_DIR, (Serializable)saveImgDir);
        intent.putExtra(EXTRA_PHOTO_PATH, photoPath);
        intent.putExtra(EXTRA_CURRENT_POSITION, 0);
        intent.putExtra(EXTRA_IS_SINGLE_PREVIEW, true);
        return intent;
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        this.setNoLinearContentView(R.layout.bga_pp_activity_photo_preview);
        this.mContentHvp = (BGAHackyViewPager)((Object)this.getViewById(R.id.hvp_photo_preview_content));
    }

    @Override
    protected void setListener() {
        this.mContentHvp.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                BGAPhotoPreviewActivity.this.renderTitleTv();
            }
        });
    }

    @Override
    protected void processLogic(Bundle savedInstanceState) {
        this.mSaveImgDir = (File)this.getIntent().getSerializableExtra(EXTRA_SAVE_IMG_DIR);
        if (this.mSaveImgDir != null && !this.mSaveImgDir.exists()) {
            this.mSaveImgDir.mkdirs();
        }
        ArrayList<String> previewImages = this.getIntent().getStringArrayListExtra(EXTRA_PREVIEW_IMAGES);
        this.mIsSinglePreview = this.getIntent().getBooleanExtra(EXTRA_IS_SINGLE_PREVIEW, false);
        if (this.mIsSinglePreview) {
            previewImages = new ArrayList<String>();
            previewImages.add(this.getIntent().getStringExtra(EXTRA_PHOTO_PATH));
        }
        int currentPosition = this.getIntent().getIntExtra(EXTRA_CURRENT_POSITION, 0);
        this.mPhotoPageAdapter = new BGAPhotoPageAdapter((Activity)this, this, previewImages);
        this.mContentHvp.setAdapter(this.mPhotoPageAdapter);
        this.mContentHvp.setCurrentItem(currentPosition);
        this.mToolbar.postDelayed(new Runnable(){

            @Override
            public void run() {
                BGAPhotoPreviewActivity.this.hiddenTitleBar();
            }
        }, 2000L);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.bga_pp_menu_photo_preview, menu2);
        MenuItem menuItem = menu2.findItem(R.id.item_photo_preview_title);
        View actionView = menuItem.getActionView();
        this.mTitleTv = (TextView)actionView.findViewById(R.id.tv_photo_preview_title);
        this.mDownloadIv = (ImageView)actionView.findViewById(R.id.iv_photo_preview_download);
        this.mDownloadIv.setOnClickListener((View.OnClickListener)new BGAOnNoDoubleClickListener(){

            public void onNoDoubleClick(View v) {
                if (BGAPhotoPreviewActivity.this.mSavePhotoTask == null) {
                    BGAPhotoPreviewActivity.this.savePic();
                }
            }
        });
        if (this.mSaveImgDir == null) {
            this.mDownloadIv.setVisibility(4);
        }
        this.renderTitleTv();
        return true;
    }

    private void renderTitleTv() {
        if (this.mTitleTv == null || this.mPhotoPageAdapter == null) {
            return;
        }
        if (this.mIsSinglePreview) {
            this.mTitleTv.setText(R.string.bga_pp_view_photo);
        } else {
            this.mTitleTv.setText((CharSequence)(this.mContentHvp.getCurrentItem() + 1 + "/" + this.mPhotoPageAdapter.getCount()));
        }
    }

    @Override
    public void onViewTap(View view, float x, float y) {
        if (System.currentTimeMillis() - this.mLastShowHiddenTime > 500L) {
            this.mLastShowHiddenTime = System.currentTimeMillis();
            if (this.mIsHidden) {
                this.showTitleBar();
            } else {
                this.hiddenTitleBar();
            }
        }
    }

    private void showTitleBar() {
        if (this.mToolbar != null) {
            ViewCompat.animate((View)this.mToolbar).translationY(0.0f).setInterpolator((Interpolator)new DecelerateInterpolator(2.0f)).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                public void onAnimationEnd(View view) {
                    BGAPhotoPreviewActivity.this.mIsHidden = false;
                }
            }).start();
        }
    }

    private void hiddenTitleBar() {
        if (this.mToolbar != null) {
            ViewCompat.animate((View)this.mToolbar).translationY((float)(-this.mToolbar.getHeight())).setInterpolator((Interpolator)new DecelerateInterpolator(2.0f)).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                public void onAnimationEnd(View view) {
                    BGAPhotoPreviewActivity.this.mIsHidden = true;
                }
            }).start();
        }
    }

    private synchronized void savePic() {
        File file;
        if (this.mSavePhotoTask != null) {
            return;
        }
        String url = this.mPhotoPageAdapter.getItem(this.mContentHvp.getCurrentItem());
        if (url.startsWith("file") && (file = new File(url.replace("file://", ""))).exists()) {
            BGAPhotoPickerUtil.showSafe((Context)this, this.getString(R.string.bga_pp_save_img_success_folder, new Object[]{file.getParentFile().getAbsolutePath()}));
            return;
        }
        file = new File(this.mSaveImgDir, BGAPhotoPickerUtil.md5(url) + ".png");
        if (file.exists()) {
            BGAPhotoPickerUtil.showSafe((Context)this, this.getString(R.string.bga_pp_save_img_success_folder, new Object[]{this.mSaveImgDir.getAbsolutePath()}));
            return;
        }
        this.mSavePhotoTask = new BGASavePhotoTask(this, (Context)this, file);
        BGAImage.downloadImage((Context)this, url, new BGAImageLoader.DownloadDelegate(){

            @Override
            public void onSuccess(String url, Bitmap bitmap) {
                BGAPhotoPreviewActivity.this.mSavePhotoTask.setBitmapAndPerform(bitmap);
            }

            @Override
            public void onFailed(String url) {
                BGAPhotoPreviewActivity.this.mSavePhotoTask = null;
                BGAPhotoPickerUtil.show((Context)BGAPhotoPreviewActivity.this, R.string.bga_pp_save_img_failure);
            }
        });
    }

    @Override
    public void onPostExecute(Void aVoid) {
        this.mSavePhotoTask = null;
    }

    @Override
    public void onTaskCancelled() {
        this.mSavePhotoTask = null;
    }

    @Override
    protected void onDestroy() {
        if (this.mSavePhotoTask != null) {
            this.mSavePhotoTask.cancelTask();
            this.mSavePhotoTask = null;
        }
        this.mTitleTv = null;
        this.mDownloadIv = null;
        this.mContentHvp = null;
        this.mPhotoPageAdapter = null;
        this.mSaveImgDir = null;
        super.onDestroy();
    }
}

