/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.pw;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import cn.bingoogolapple.androidcommon.adapter.BGAOnRVItemClickListener;
import cn.bingoogolapple.androidcommon.adapter.BGARecyclerViewAdapter;
import cn.bingoogolapple.androidcommon.adapter.BGAViewHolderHelper;
import cn.bingoogolapple.photopicker.R;
import cn.bingoogolapple.photopicker.imageloader.BGAImage;
import cn.bingoogolapple.photopicker.model.BGAImageFolderModel;
import cn.bingoogolapple.photopicker.pw.BGABasePopupWindow;
import cn.bingoogolapple.photopicker.util.BGAPhotoPickerUtil;
import java.util.ArrayList;

public class BGAPhotoFolderPw
extends BGABasePopupWindow
implements BGAOnRVItemClickListener {
    public static final int ANIM_DURATION = 300;
    private LinearLayout mRootLl;
    private RecyclerView mContentRv;
    private FolderAdapter mFolderAdapter;
    private Delegate mDelegate;
    private int mCurrentPosition;

    public BGAPhotoFolderPw(Activity activity, View anchorView, Delegate delegate) {
        super(activity, R.layout.bga_pp_pw_photo_folder, anchorView, -1, -1);
        this.mDelegate = delegate;
    }

    @Override
    protected void initView() {
        this.mRootLl = (LinearLayout)this.getViewById(R.id.ll_photo_folder_root);
        this.mContentRv = (RecyclerView)this.getViewById(R.id.rv_photo_folder_content);
    }

    @Override
    protected void setListener() {
        this.mRootLl.setOnClickListener((View.OnClickListener)this);
        this.mFolderAdapter = new FolderAdapter(this.mContentRv);
        this.mFolderAdapter.setOnRVItemClickListener(this);
    }

    @Override
    protected void processLogic() {
        this.setAnimationStyle(0x1030000);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(-1879048192));
        this.mContentRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.mActivity));
        this.mContentRv.setAdapter((RecyclerView.Adapter)this.mFolderAdapter);
    }

    public void setData(ArrayList<BGAImageFolderModel> datas) {
        this.mFolderAdapter.setData(datas);
    }

    @Override
    public void show() {
        this.showAsDropDown(this.mAnchorView);
        ViewCompat.animate((View)this.mContentRv).translationY((float)(-this.mWindowRootView.getHeight())).setDuration(0L).start();
        ViewCompat.animate((View)this.mContentRv).translationY(0.0f).setDuration(300L).start();
        ViewCompat.animate((View)this.mRootLl).alpha(0.0f).setDuration(0L).start();
        ViewCompat.animate((View)this.mRootLl).alpha(1.0f).setDuration(300L).start();
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.ll_photo_folder_root) {
            this.dismiss();
        }
    }

    public void dismiss() {
        ViewCompat.animate((View)this.mContentRv).translationY((float)(-this.mWindowRootView.getHeight())).setDuration(300L).start();
        ViewCompat.animate((View)this.mRootLl).alpha(1.0f).setDuration(0L).start();
        ViewCompat.animate((View)this.mRootLl).alpha(0.0f).setDuration(300L).start();
        if (this.mDelegate != null) {
            this.mDelegate.executeDismissAnim();
        }
        this.mContentRv.postDelayed(new Runnable(){

            @Override
            public void run() {
                BGAPhotoFolderPw.super.dismiss();
            }
        }, 300L);
    }

    public int getCurrentPosition() {
        return this.mCurrentPosition;
    }

    public void onRVItemClick(ViewGroup viewGroup, View view, int position) {
        if (this.mDelegate != null && this.mCurrentPosition != position) {
            this.mDelegate.onSelectedFolder(position);
        }
        this.mCurrentPosition = position;
        this.dismiss();
    }

    public static interface Delegate {
        public void onSelectedFolder(int var1);

        public void executeDismissAnim();
    }

    private class FolderAdapter
    extends BGARecyclerViewAdapter<BGAImageFolderModel> {
        private int mImageWidth;
        private int mImageHeight;

        public FolderAdapter(RecyclerView recyclerView) {
            super(recyclerView, R.layout.bga_pp_item_photo_folder);
            this.mData = new ArrayList();
            this.mImageHeight = this.mImageWidth = BGAPhotoPickerUtil.getScreenWidth((Context)BGAPhotoFolderPw.this.mActivity) / 10;
        }

        protected void fillData(BGAViewHolderHelper helper, int position, BGAImageFolderModel model) {
            helper.setText(R.id.tv_item_photo_folder_name, (CharSequence)model.name);
            helper.setText(R.id.tv_item_photo_folder_count, (CharSequence)String.valueOf(model.getCount()));
            BGAImage.displayImage(BGAPhotoFolderPw.this.mActivity, helper.getImageView(R.id.iv_item_photo_folder_photo), model.coverPath, R.mipmap.bga_pp_ic_holder_light, R.mipmap.bga_pp_ic_holder_light, this.mImageWidth, this.mImageHeight, null);
        }
    }
}

