/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import cn.bingoogolapple.androidcommon.adapter.BGAOnItemChildClickListener;
import cn.bingoogolapple.androidcommon.adapter.BGAOnRVItemClickListener;
import cn.bingoogolapple.androidcommon.adapter.BGARecyclerViewAdapter;
import cn.bingoogolapple.androidcommon.adapter.BGARecyclerViewHolder;
import cn.bingoogolapple.androidcommon.adapter.BGAViewHolderHelper;
import cn.bingoogolapple.photopicker.R;
import cn.bingoogolapple.photopicker.imageloader.BGAImage;
import cn.bingoogolapple.photopicker.util.BGAPhotoPickerUtil;
import cn.bingoogolapple.photopicker.util.BGASpaceItemDecoration;
import java.util.ArrayList;

public class BGASortableNinePhotoLayout
extends RecyclerView
implements BGAOnItemChildClickListener,
BGAOnRVItemClickListener {
    private PhotoAdapter mPhotoAdapter;
    private ItemTouchHelper mItemTouchHelper;
    private Delegate mDelegate;
    private GridLayoutManager mGridLayoutManager;
    private boolean mIsPlusSwitchOpened = true;
    private boolean mIsSortable = true;
    private int mDeleteDrawableResId = R.mipmap.bga_pp_ic_delete;
    private boolean mIsDeleteDrawableOverlapQuarter = false;
    private int mPhotoTopRightMargin;
    private int mMaxItemCount = 9;
    private int mItemSpanCount = 3;
    private int mPlusDrawableResId = R.mipmap.bga_pp_ic_plus;
    private Activity mActivity;

    public BGASortableNinePhotoLayout(Context context) {
        this(context, null);
    }

    public BGASortableNinePhotoLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BGASortableNinePhotoLayout(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setOverScrollMode(2);
        this.initAttrs(context, attrs);
        this.mItemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)new ItemTouchHelperCallback());
        this.mItemTouchHelper.attachToRecyclerView((RecyclerView)this);
        this.mGridLayoutManager = new GridLayoutManager(context, this.mItemSpanCount);
        this.setLayoutManager((RecyclerView.LayoutManager)this.mGridLayoutManager);
        this.addItemDecoration(new BGASpaceItemDecoration(this.getResources().getDimensionPixelSize(R.dimen.bga_pp_size_photo_divider)));
        this.calculatePhotoTopRightMargin();
        this.mPhotoAdapter = new PhotoAdapter(this);
        this.mPhotoAdapter.setOnItemChildClickListener(this);
        this.mPhotoAdapter.setOnRVItemClickListener(this);
        this.setAdapter((RecyclerView.Adapter)this.mPhotoAdapter);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BGASortableNinePhotoLayout);
        int N = typedArray.getIndexCount();
        for (int i = 0; i < N; ++i) {
            this.initAttr(typedArray.getIndex(i), typedArray);
        }
        typedArray.recycle();
    }

    private void initAttr(int attr2, TypedArray typedArray) {
        if (attr2 == R.styleable.BGASortableNinePhotoLayout_bga_snpl_isPlusSwitchOpened) {
            this.mIsPlusSwitchOpened = typedArray.getBoolean(attr2, this.mIsPlusSwitchOpened);
        } else if (attr2 == R.styleable.BGASortableNinePhotoLayout_bga_snpl_isSortable) {
            this.mIsSortable = typedArray.getBoolean(attr2, this.mIsSortable);
        } else if (attr2 == R.styleable.BGASortableNinePhotoLayout_bga_snpl_deleteDrawable) {
            this.mDeleteDrawableResId = typedArray.getResourceId(attr2, this.mDeleteDrawableResId);
        } else if (attr2 == R.styleable.BGASortableNinePhotoLayout_bga_snpl_isDeleteDrawableOverlapQuarter) {
            this.mIsDeleteDrawableOverlapQuarter = typedArray.getBoolean(attr2, this.mIsDeleteDrawableOverlapQuarter);
        } else if (attr2 == R.styleable.BGASortableNinePhotoLayout_bga_snpl_maxItemCount) {
            this.mMaxItemCount = typedArray.getInteger(attr2, this.mMaxItemCount);
        } else if (attr2 == R.styleable.BGASortableNinePhotoLayout_bga_snpl_itemSpanCount) {
            this.mItemSpanCount = typedArray.getInteger(attr2, this.mItemSpanCount);
        } else if (attr2 == R.styleable.BGASortableNinePhotoLayout_bga_snpl_plusDrawable) {
            this.mPlusDrawableResId = typedArray.getResourceId(attr2, this.mPlusDrawableResId);
        }
    }

    public void init(Activity activity) {
        this.mActivity = activity;
        this.updateHeight();
    }

    public void setIsSortable(boolean isSortable) {
        this.mIsSortable = isSortable;
    }

    public void setDeleteDrawableResId(@DrawableRes int deleteDrawableResId) {
        this.mDeleteDrawableResId = deleteDrawableResId;
        this.calculatePhotoTopRightMargin();
    }

    public void setIsDeleteDrawableOverlapQuarter(boolean isDeleteDrawableOverlapQuarter) {
        this.mIsDeleteDrawableOverlapQuarter = isDeleteDrawableOverlapQuarter;
        this.calculatePhotoTopRightMargin();
    }

    private void calculatePhotoTopRightMargin() {
        if (this.mIsDeleteDrawableOverlapQuarter) {
            int deleteDrawableWidth = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mDeleteDrawableResId).getWidth();
            int deleteDrawablePadding = this.getResources().getDimensionPixelOffset(R.dimen.bga_pp_size_delete_padding);
            this.mPhotoTopRightMargin = deleteDrawablePadding + deleteDrawableWidth / 2;
        } else {
            this.mPhotoTopRightMargin = 0;
        }
    }

    public void setMaxItemCount(int maxItemCount) {
        this.mMaxItemCount = maxItemCount;
    }

    public int getMaxItemCount() {
        return this.mMaxItemCount;
    }

    public void setItemSpanCount(int itemSpanCount) {
        this.mItemSpanCount = itemSpanCount;
        this.mGridLayoutManager.setSpanCount(this.mItemSpanCount);
    }

    public void setPlusDrawableResId(@DrawableRes int plusDrawableResId) {
        this.mPlusDrawableResId = plusDrawableResId;
    }

    public void setData(ArrayList<String> photos) {
        if (this.mActivity == null) {
            throw new RuntimeException("\u8bf7\u5148\u8c03\u7528init\u65b9\u6cd5\u8fdb\u884c\u521d\u59cb\u5316");
        }
        this.mPhotoAdapter.setData(photos);
        this.updateHeight();
    }

    public void addMoreData(ArrayList<String> photos) {
        if (this.mActivity == null) {
            throw new RuntimeException("\u8bf7\u5148\u8c03\u7528init\u65b9\u6cd5\u8fdb\u884c\u521d\u59cb\u5316");
        }
        if (photos != null) {
            this.mPhotoAdapter.getData().addAll(photos);
            this.mPhotoAdapter.notifyDataSetChanged();
        }
        this.updateHeight();
    }

    private void updateHeight() {
        if (this.mPhotoAdapter.getItemCount() > 0 && this.mPhotoAdapter.getItemCount() < this.mItemSpanCount) {
            this.mGridLayoutManager.setSpanCount(this.mPhotoAdapter.getItemCount());
        } else {
            this.mGridLayoutManager.setSpanCount(this.mItemSpanCount);
        }
        int itemWidth = BGAPhotoPickerUtil.getScreenWidth(this.getContext()) / (this.mItemSpanCount + 1);
        int width = itemWidth * this.mGridLayoutManager.getSpanCount();
        int height = 0;
        if (this.mPhotoAdapter.getItemCount() != 0) {
            int rowCount = (this.mPhotoAdapter.getItemCount() - 1) / this.mGridLayoutManager.getSpanCount() + 1;
            height = itemWidth * rowCount;
        }
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        layoutParams.width = width;
        layoutParams.height = height;
        this.setLayoutParams(layoutParams);
    }

    public ArrayList<String> getData() {
        return (ArrayList)this.mPhotoAdapter.getData();
    }

    public void removeItem(int position) {
        this.mPhotoAdapter.removeItem(position);
        this.updateHeight();
    }

    public int getItemCount() {
        return this.mPhotoAdapter.getData().size();
    }

    public void onItemChildClick(ViewGroup parent, View childView, int position) {
        if (this.mDelegate != null) {
            this.mDelegate.onClickDeleteNinePhotoItem(this, childView, position, this.mPhotoAdapter.getItem(position), (ArrayList)this.mPhotoAdapter.getData());
        }
    }

    public void onRVItemClick(ViewGroup parent, View itemView, int position) {
        if (this.mPhotoAdapter.isPlusItem(position)) {
            if (this.mDelegate != null) {
                this.mDelegate.onClickAddNinePhotoItem(this, itemView, position, (ArrayList)this.mPhotoAdapter.getData());
            }
        } else if (this.mDelegate != null && ViewCompat.getScaleX((View)itemView) <= 1.0f) {
            this.mDelegate.onClickNinePhotoItem(this, itemView, position, this.mPhotoAdapter.getItem(position), (ArrayList)this.mPhotoAdapter.getData());
        }
    }

    public void setIsPlusSwitchOpened(boolean isPlusSwitchOpened) {
        this.mIsPlusSwitchOpened = isPlusSwitchOpened;
        this.updateHeight();
    }

    public void setDelegate(Delegate delegate) {
        this.mDelegate = delegate;
    }

    public static interface Delegate {
        public void onClickAddNinePhotoItem(BGASortableNinePhotoLayout var1, View var2, int var3, ArrayList<String> var4);

        public void onClickDeleteNinePhotoItem(BGASortableNinePhotoLayout var1, View var2, int var3, String var4, ArrayList<String> var5);

        public void onClickNinePhotoItem(BGASortableNinePhotoLayout var1, View var2, int var3, String var4, ArrayList<String> var5);
    }

    private class ItemTouchHelperCallback
    extends ItemTouchHelper.Callback {
        private ItemTouchHelperCallback() {
        }

        public boolean isLongPressDragEnabled() {
            return BGASortableNinePhotoLayout.this.mIsSortable && BGASortableNinePhotoLayout.this.mPhotoAdapter.getData().size() > 1;
        }

        public boolean isItemViewSwipeEnabled() {
            return false;
        }

        public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            int dragFlags = 51;
            if (BGASortableNinePhotoLayout.this.mPhotoAdapter.isPlusItem(viewHolder.getAdapterPosition())) {
                dragFlags = 0;
            }
            int swipeFlags = 0;
            return ItemTouchHelperCallback.makeMovementFlags((int)dragFlags, (int)swipeFlags);
        }

        public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder source, RecyclerView.ViewHolder target) {
            if (source.getItemViewType() != target.getItemViewType() || BGASortableNinePhotoLayout.this.mPhotoAdapter.isPlusItem(target.getAdapterPosition())) {
                return false;
            }
            BGASortableNinePhotoLayout.this.mPhotoAdapter.moveItem(source.getAdapterPosition(), target.getAdapterPosition());
            return true;
        }

        public void onSwiped(RecyclerView.ViewHolder viewHolder, int direction) {
        }

        public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            super.onChildDraw(c, recyclerView, viewHolder, dX, dY, actionState, isCurrentlyActive);
        }

        public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
            if (actionState != 0) {
                ViewCompat.setScaleX((View)viewHolder.itemView, (float)1.2f);
                ViewCompat.setScaleY((View)viewHolder.itemView, (float)1.2f);
                ((BGARecyclerViewHolder)viewHolder).getViewHolderHelper().getImageView(R.id.iv_item_nine_photo_photo).setColorFilter(BGASortableNinePhotoLayout.this.getResources().getColor(R.color.bga_pp_photo_selected_mask));
            }
            super.onSelectedChanged(viewHolder, actionState);
        }

        public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            ViewCompat.setScaleX((View)viewHolder.itemView, (float)1.0f);
            ViewCompat.setScaleY((View)viewHolder.itemView, (float)1.0f);
            ((BGARecyclerViewHolder)viewHolder).getViewHolderHelper().getImageView(R.id.iv_item_nine_photo_photo).setColorFilter(null);
            super.clearView(recyclerView, viewHolder);
        }
    }

    private class PhotoAdapter
    extends BGARecyclerViewAdapter<String> {
        private int mImageWidth;
        private int mImageHeight;

        public PhotoAdapter(RecyclerView recyclerView) {
            super(recyclerView, R.layout.bga_pp_item_nine_photo);
            this.mImageHeight = this.mImageWidth = BGAPhotoPickerUtil.getScreenWidth(recyclerView.getContext()) / 6;
        }

        protected void setItemChildListener(BGAViewHolderHelper helper, int viewType) {
            helper.setItemChildClickListener(R.id.iv_item_nine_photo_flag);
        }

        public int getItemCount() {
            if (BGASortableNinePhotoLayout.this.mIsPlusSwitchOpened && super.getItemCount() < BGASortableNinePhotoLayout.this.mMaxItemCount) {
                return super.getItemCount() + 1;
            }
            return super.getItemCount();
        }

        public String getItem(int position) {
            if (this.isPlusItem(position)) {
                return null;
            }
            return (String)super.getItem(position);
        }

        public boolean isPlusItem(int position) {
            return BGASortableNinePhotoLayout.this.mIsPlusSwitchOpened && super.getItemCount() < BGASortableNinePhotoLayout.this.mMaxItemCount && position == this.getItemCount() - 1;
        }

        protected void fillData(BGAViewHolderHelper helper, int position, String model) {
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)helper.getView(R.id.iv_item_nine_photo_photo).getLayoutParams();
            params.setMargins(0, BGASortableNinePhotoLayout.this.mPhotoTopRightMargin, BGASortableNinePhotoLayout.this.mPhotoTopRightMargin, 0);
            if (this.isPlusItem(position)) {
                helper.setVisibility(R.id.iv_item_nine_photo_flag, 8);
                helper.setImageResource(R.id.iv_item_nine_photo_photo, BGASortableNinePhotoLayout.this.mPlusDrawableResId);
            } else {
                helper.setVisibility(R.id.iv_item_nine_photo_flag, 0);
                helper.setImageResource(R.id.iv_item_nine_photo_flag, BGASortableNinePhotoLayout.this.mDeleteDrawableResId);
                BGAImage.displayImage(BGASortableNinePhotoLayout.this.mActivity, helper.getImageView(R.id.iv_item_nine_photo_photo), model, R.mipmap.bga_pp_ic_holder_light, R.mipmap.bga_pp_ic_holder_light, this.mImageWidth, this.mImageHeight, null);
            }
        }
    }
}

