/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.imageloader;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.view.View;
import android.widget.ImageView;
import cn.bingoogolapple.photopicker.imageloader.BGAImageLoader;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Target;

public class BGAPicassoImageLoader
extends BGAImageLoader {
    @Override
    public void displayImage(Activity activity, final ImageView imageView, String path, @DrawableRes int loadingResId, @DrawableRes int failResId, int width, int height, final BGAImageLoader.DisplayDelegate delegate) {
        final String finalPath = this.getPath(path);
        Picasso.with((Context)activity).load(finalPath).tag((Object)activity).placeholder(loadingResId).error(failResId).resize(width, height).centerInside().into(imageView, (Callback)new Callback.EmptyCallback(){

            public void onSuccess() {
                if (delegate != null) {
                    delegate.onSuccess((View)imageView, finalPath);
                }
            }
        });
    }

    @Override
    public void downloadImage(Context context, String path, final BGAImageLoader.DownloadDelegate delegate) {
        final String finalPath = this.getPath(path);
        Picasso.with((Context)context.getApplicationContext()).load(finalPath).into(new Target(){

            public void onBitmapLoaded(Bitmap bitmap, Picasso.LoadedFrom from) {
                if (delegate != null) {
                    delegate.onSuccess(finalPath, bitmap);
                }
            }

            public void onBitmapFailed(Drawable errorDrawable) {
                if (delegate != null) {
                    delegate.onFailed(finalPath);
                }
            }

            public void onPrepareLoad(Drawable placeHolderDrawable) {
            }
        });
    }

    @Override
    public void pause(Activity activity) {
        Picasso.with((Context)activity).pauseTag((Object)activity);
    }

    @Override
    public void resume(Activity activity) {
        Picasso.with((Context)activity).resumeTag((Object)activity);
    }
}

