/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.imageloader;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.DrawableRes;
import android.view.View;
import android.widget.ImageView;
import cn.bingoogolapple.photopicker.imageloader.BGAImageLoader;
import com.nostra13.universalimageloader.core.DisplayImageOptions;
import com.nostra13.universalimageloader.core.ImageLoader;
import com.nostra13.universalimageloader.core.ImageLoaderConfiguration;
import com.nostra13.universalimageloader.core.assist.FailReason;
import com.nostra13.universalimageloader.core.assist.ImageSize;
import com.nostra13.universalimageloader.core.imageaware.ImageAware;
import com.nostra13.universalimageloader.core.imageaware.ImageViewAware;
import com.nostra13.universalimageloader.core.listener.ImageLoadingListener;
import com.nostra13.universalimageloader.core.listener.SimpleImageLoadingListener;

public class BGAUILImageLoader
extends BGAImageLoader {
    private void initImageLoader(Context context) {
        if (!ImageLoader.getInstance().isInited()) {
            DisplayImageOptions options = new DisplayImageOptions.Builder().cacheInMemory(true).cacheOnDisk(true).build();
            ImageLoaderConfiguration config = new ImageLoaderConfiguration.Builder(context.getApplicationContext()).threadPoolSize(3).defaultDisplayImageOptions(options).build();
            ImageLoader.getInstance().init(config);
        }
    }

    @Override
    public void displayImage(Activity activity, ImageView imageView, String path, @DrawableRes int loadingResId, @DrawableRes int failResId, int width, int height, final BGAImageLoader.DisplayDelegate delegate) {
        this.initImageLoader((Context)activity);
        DisplayImageOptions options = new DisplayImageOptions.Builder().showImageOnLoading(loadingResId).showImageOnFail(failResId).cacheInMemory(true).build();
        ImageSize imageSize = new ImageSize(width, height);
        ImageLoader.getInstance().displayImage(this.getPath(path), (ImageAware)new ImageViewAware(imageView), options, imageSize, (ImageLoadingListener)new SimpleImageLoadingListener(){

            public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                if (delegate != null) {
                    delegate.onSuccess(view, imageUri);
                }
            }
        }, null);
    }

    @Override
    public void downloadImage(Context context, String path, final BGAImageLoader.DownloadDelegate delegate) {
        this.initImageLoader(context);
        ImageLoader.getInstance().loadImage(this.getPath(path), (ImageLoadingListener)new SimpleImageLoadingListener(){

            public void onLoadingComplete(String imageUri, View view, Bitmap loadedImage) {
                if (delegate != null) {
                    delegate.onSuccess(imageUri, loadedImage);
                }
            }

            public void onLoadingFailed(String imageUri, View view, FailReason failReason) {
                if (delegate != null) {
                    delegate.onFailed(imageUri);
                }
            }
        });
    }

    @Override
    public void pause(Activity activity) {
        this.initImageLoader((Context)activity);
        ImageLoader.getInstance().pause();
    }

    @Override
    public void resume(Activity activity) {
        this.initImageLoader((Context)activity);
        ImageLoader.getInstance().resume();
    }
}

