/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.util;

import android.graphics.Matrix;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import uk.co.senab.photoview.PhotoViewAttacher;

public class BGABrowserPhotoViewAttacher
extends PhotoViewAttacher {
    private boolean isSetTopCrop = false;

    public BGABrowserPhotoViewAttacher(ImageView imageView) {
        super(imageView);
    }

    @Override
    protected void updateBaseMatrix(Drawable d) {
        if (this.isSetTopCrop) {
            this.setTopCrop(d);
        } else {
            super.updateBaseMatrix(d);
        }
    }

    public void setIsSetTopCrop(boolean isSetTopCrop) {
        this.isSetTopCrop = isSetTopCrop;
    }

    public void setUpdateBaseMatrix() {
        ImageView view = this.getImageView();
        if (view == null) {
            return;
        }
        this.updateBaseMatrix(view.getDrawable());
    }

    private void setTopCrop(Drawable d) {
        ImageView imageView = this.getImageView();
        if (null == imageView || null == d) {
            return;
        }
        float viewWidth = this.getImageViewWidth(imageView);
        float viewHeight = this.getImageViewHeight(imageView);
        int drawableWidth = d.getIntrinsicWidth();
        int drawableHeight = d.getIntrinsicHeight();
        Matrix matrix = new Matrix();
        float widthScale = viewWidth / (float)drawableWidth;
        float heightScale = viewHeight / (float)drawableHeight;
        float scale = Math.max(widthScale, heightScale);
        matrix.postScale(scale, scale);
        matrix.postTranslate(0.0f, 0.0f);
        this.updateBaseMatrix(matrix);
    }
}

