/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.util;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.text.TextUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class BGAImageCaptureManager {
    private static final String CAPTURED_PHOTO_PATH_KEY = "CAPTURED_PHOTO_PATH_KEY";
    private static final SimpleDateFormat PICTURE_NAME_POSTFIX_SDF = new SimpleDateFormat("yyyy-MM-dd_HH-mm_ss", Locale.CHINESE);
    private String mCurrentPhotoPath;
    private Context mContext;
    private File mImageDir;

    public BGAImageCaptureManager(Context context, File imageDir) {
        this.mContext = context;
        this.mImageDir = imageDir;
        if (!this.mImageDir.exists()) {
            this.mImageDir.mkdirs();
        }
    }

    private File createCaptureFile() throws IOException {
        File captureFile = File.createTempFile("Capture_" + PICTURE_NAME_POSTFIX_SDF.format(new Date()), ".jpg", this.mImageDir);
        this.mCurrentPhotoPath = captureFile.getAbsolutePath();
        return captureFile;
    }

    public Intent getTakePictureIntent() throws IOException {
        File photoFile;
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.mContext.getPackageManager()) != null && (photoFile = this.createCaptureFile()) != null) {
            if (Build.VERSION.SDK_INT < 24) {
                takePictureIntent.putExtra("output", (Parcelable)Uri.fromFile((File)photoFile));
            } else {
                ContentValues contentValues = new ContentValues(1);
                contentValues.put("_data", photoFile.getAbsolutePath());
                Uri uri = this.mContext.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, contentValues);
                takePictureIntent.putExtra("output", (Parcelable)uri);
            }
        }
        return takePictureIntent;
    }

    public void refreshGallery() {
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentPhotoPath)) {
            Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
            mediaScanIntent.setData(Uri.fromFile((File)new File(this.mCurrentPhotoPath)));
            this.mContext.sendBroadcast(mediaScanIntent);
            this.mCurrentPhotoPath = null;
        }
    }

    public void deletePhotoFile() {
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentPhotoPath)) {
            try {
                File photoFile = new File(this.mCurrentPhotoPath);
                photoFile.deleteOnExit();
                this.mCurrentPhotoPath = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getCurrentPhotoPath() {
        return this.mCurrentPhotoPath;
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null && this.mCurrentPhotoPath != null) {
            savedInstanceState.putString(CAPTURED_PHOTO_PATH_KEY, this.mCurrentPhotoPath);
        }
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null && savedInstanceState.containsKey(CAPTURED_PHOTO_PATH_KEY)) {
            this.mCurrentPhotoPath = savedInstanceState.getString(CAPTURED_PHOTO_PATH_KEY);
        }
    }

    private File createCropFile() throws IOException {
        File cropFile = File.createTempFile("Crop_" + PICTURE_NAME_POSTFIX_SDF.format(new Date()), ".png", this.mContext.getExternalCacheDir());
        this.mCurrentPhotoPath = cropFile.getAbsolutePath();
        return cropFile;
    }

    public Intent getCropIntent(String inputFilePath, int width, int height) throws IOException {
        Intent intent = new Intent("com.android.camera.action.CROP");
        intent.setDataAndType(Uri.fromFile((File)new File(inputFilePath)), "image/*");
        intent.putExtra("crop", "true");
        intent.putExtra("aspectX", 1);
        intent.putExtra("aspectY", 1);
        intent.putExtra("outputX", width);
        intent.putExtra("outputY", height);
        intent.putExtra("return-data", false);
        intent.putExtra("scale", true);
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)this.createCropFile()));
        intent.putExtra("outputFormat", Bitmap.CompressFormat.PNG.toString());
        intent.putExtra("noFaceDetection", true);
        return intent;
    }
}

