/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.widget;

import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import cn.bingoogolapple.androidcommon.adapter.BGAAdapterViewAdapter;
import cn.bingoogolapple.androidcommon.adapter.BGAViewHolderHelper;
import cn.bingoogolapple.photopicker.R;
import cn.bingoogolapple.photopicker.imageloader.BGAImage;
import cn.bingoogolapple.photopicker.util.BGAPhotoPickerUtil;
import cn.bingoogolapple.photopicker.widget.BGAHeightWrapGridView;
import cn.bingoogolapple.photopicker.widget.BGAImageView;
import java.util.ArrayList;
import java.util.List;

public class BGANinePhotoLayout
extends FrameLayout
implements AdapterView.OnItemClickListener,
View.OnClickListener {
    private static final int ITEM_NUM_COLUMNS = 3;
    private PhotoAdapter mPhotoAdapter;
    private BGAImageView mPhotoIv;
    private BGAHeightWrapGridView mPhotoGv;
    private Delegate mDelegate;
    private int mCurrentClickItemPosition;
    private Activity mActivity;
    private int mItemCornerRadius;
    private boolean mShowAsLargeWhenOnlyOne;
    private int mItemWhiteSpacing;
    private int mOtherWhiteSpacing;
    private int mPlaceholderDrawableResId;
    private int mItemSpanCount;
    private int mItemWidth;

    public BGANinePhotoLayout(Context context) {
        this(context, null);
    }

    public BGANinePhotoLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BGANinePhotoLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initDefaultAttrs();
        this.initCustomAttrs(context, attrs);
        this.afterInitDefaultAndCustomAttrs();
    }

    private void initDefaultAttrs() {
        this.mItemWidth = 0;
        this.mShowAsLargeWhenOnlyOne = true;
        this.mItemCornerRadius = 0;
        this.mItemWhiteSpacing = BGAPhotoPickerUtil.dp2px(this.getContext(), 4.0f);
        this.mPlaceholderDrawableResId = R.mipmap.bga_pp_ic_holder_light;
        this.mOtherWhiteSpacing = BGAPhotoPickerUtil.dp2px(this.getContext(), 100.0f);
        this.mItemSpanCount = 3;
    }

    private void initCustomAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BGANinePhotoLayout);
        int N = typedArray.getIndexCount();
        for (int i = 0; i < N; ++i) {
            this.initCustomAttr(typedArray.getIndex(i), typedArray);
        }
        typedArray.recycle();
    }

    private void initCustomAttr(int attr2, TypedArray typedArray) {
        if (attr2 == R.styleable.BGANinePhotoLayout_bga_npl_showAsLargeWhenOnlyOne) {
            this.mShowAsLargeWhenOnlyOne = typedArray.getBoolean(attr2, this.mShowAsLargeWhenOnlyOne);
        } else if (attr2 == R.styleable.BGANinePhotoLayout_bga_npl_itemCornerRadius) {
            this.mItemCornerRadius = typedArray.getDimensionPixelSize(attr2, this.mItemCornerRadius);
        } else if (attr2 == R.styleable.BGANinePhotoLayout_bga_npl_itemWhiteSpacing) {
            this.mItemWhiteSpacing = typedArray.getDimensionPixelSize(attr2, this.mItemWhiteSpacing);
        } else if (attr2 == R.styleable.BGANinePhotoLayout_bga_npl_otherWhiteSpacing) {
            this.mOtherWhiteSpacing = typedArray.getDimensionPixelOffset(attr2, this.mOtherWhiteSpacing);
        } else if (attr2 == R.styleable.BGANinePhotoLayout_bga_npl_placeholderDrawable) {
            this.mPlaceholderDrawableResId = typedArray.getResourceId(attr2, this.mPlaceholderDrawableResId);
        } else if (attr2 == R.styleable.BGANinePhotoLayout_bga_npl_itemWidth) {
            this.mItemWidth = typedArray.getDimensionPixelSize(attr2, this.mItemWidth);
        } else if (attr2 == R.styleable.BGANinePhotoLayout_bga_npl_itemSpanCount) {
            this.mItemSpanCount = typedArray.getInteger(attr2, this.mItemSpanCount);
        }
    }

    private void afterInitDefaultAndCustomAttrs() {
        if (this.mItemWidth == 0) {
            this.mItemWidth = (BGAPhotoPickerUtil.getScreenWidth(this.getContext()) - this.mOtherWhiteSpacing - (this.mItemSpanCount - 1) * this.mItemWhiteSpacing) / this.mItemSpanCount;
        }
        this.mPhotoIv = new BGAImageView(this.getContext());
        this.mPhotoIv.setClickable(true);
        this.mPhotoIv.setOnClickListener(this);
        this.mPhotoGv = new BGAHeightWrapGridView(this.getContext());
        this.mPhotoGv.setHorizontalSpacing(this.mItemWhiteSpacing);
        this.mPhotoGv.setVerticalSpacing(this.mItemWhiteSpacing);
        this.mPhotoGv.setNumColumns(3);
        this.mPhotoGv.setOnItemClickListener(this);
        this.mPhotoAdapter = new PhotoAdapter(this.getContext());
        this.mPhotoGv.setAdapter((ListAdapter)this.mPhotoAdapter);
        this.addView((View)this.mPhotoIv, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.addView((View)this.mPhotoGv);
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
        this.mCurrentClickItemPosition = position;
        if (this.mDelegate != null) {
            this.mDelegate.onClickNinePhotoItem(this, view, this.mCurrentClickItemPosition, (String)this.mPhotoAdapter.getItem(this.mCurrentClickItemPosition), this.mPhotoAdapter.getData());
        }
    }

    public void onClick(View view) {
        this.mCurrentClickItemPosition = 0;
        if (this.mDelegate != null) {
            this.mDelegate.onClickNinePhotoItem(this, view, this.mCurrentClickItemPosition, (String)this.mPhotoAdapter.getItem(this.mCurrentClickItemPosition), this.mPhotoAdapter.getData());
        }
    }

    public void init(Activity activity) {
        this.mActivity = activity;
    }

    private void initActivity() {
        if (this.mActivity == null) {
            if (this.getContext() instanceof Activity) {
                this.mActivity = (Activity)this.getContext();
            } else {
                throw new RuntimeException("\u8bf7\u5148\u8c03\u7528 " + BGANinePhotoLayout.class.getSimpleName() + " \u7684 init \u65b9\u6cd5\u8fdb\u884c\u521d\u59cb\u5316");
            }
        }
    }

    public void setData(ArrayList<String> photos) {
        this.initActivity();
        if (photos.size() == 0) {
            this.setVisibility(8);
        } else {
            this.setVisibility(0);
            if (photos.size() == 1 && this.mShowAsLargeWhenOnlyOne) {
                this.mPhotoGv.setVisibility(8);
                this.mPhotoAdapter.setData(photos);
                this.mPhotoIv.setVisibility(0);
                int size = this.mItemWidth * 2 + this.mItemWhiteSpacing + this.mItemWidth / 4;
                this.mPhotoIv.setMaxWidth(size);
                this.mPhotoIv.setMaxHeight(size);
                if (this.mItemCornerRadius > 0) {
                    this.mPhotoIv.setCornerRadius(this.mItemCornerRadius);
                }
                BGAImage.displayImage(this.mActivity, (ImageView)this.mPhotoIv, photos.get(0), this.mPlaceholderDrawableResId, this.mPlaceholderDrawableResId, size, size, null);
            } else {
                this.mPhotoIv.setVisibility(8);
                this.mPhotoGv.setVisibility(0);
                ViewGroup.LayoutParams layoutParams = this.mPhotoGv.getLayoutParams();
                if (this.mItemSpanCount > 3) {
                    int itemSpanCount = photos.size() < this.mItemSpanCount ? photos.size() : this.mItemSpanCount;
                    this.mPhotoGv.setNumColumns(itemSpanCount);
                    layoutParams.width = this.mItemWidth * itemSpanCount + (itemSpanCount - 1) * this.mItemWhiteSpacing;
                } else if (photos.size() == 1) {
                    this.mPhotoGv.setNumColumns(1);
                    layoutParams.width = this.mItemWidth * 1;
                } else if (photos.size() == 2) {
                    this.mPhotoGv.setNumColumns(2);
                    layoutParams.width = this.mItemWidth * 2 + this.mItemWhiteSpacing;
                } else if (photos.size() == 4) {
                    this.mPhotoGv.setNumColumns(2);
                    layoutParams.width = this.mItemWidth * 2 + this.mItemWhiteSpacing;
                } else {
                    this.mPhotoGv.setNumColumns(3);
                    layoutParams.width = this.mItemWidth * 3 + 2 * this.mItemWhiteSpacing;
                }
                this.mPhotoGv.setLayoutParams(layoutParams);
                this.mPhotoAdapter.setData(photos);
            }
        }
    }

    public void setDelegate(Delegate delegate) {
        this.mDelegate = delegate;
    }

    public ArrayList<String> getData() {
        return (ArrayList)this.mPhotoAdapter.getData();
    }

    public int getItemCount() {
        return this.mPhotoAdapter.getCount();
    }

    public String getCurrentClickItem() {
        return (String)this.mPhotoAdapter.getItem(this.mCurrentClickItemPosition);
    }

    public int getCurrentClickItemPosition() {
        return this.mCurrentClickItemPosition;
    }

    public static interface Delegate {
        public void onClickNinePhotoItem(BGANinePhotoLayout var1, View var2, int var3, String var4, List<String> var5);
    }

    private class PhotoAdapter
    extends BGAAdapterViewAdapter<String> {
        private int mImageWidth;
        private int mImageHeight;

        public PhotoAdapter(Context context) {
            super(context, R.layout.bga_pp_item_nine_photo);
            this.mImageHeight = this.mImageWidth = BGAPhotoPickerUtil.getScreenWidth(context) / (BGANinePhotoLayout.this.mItemSpanCount > 3 ? 10 : 6);
        }

        protected void fillData(BGAViewHolderHelper helper, int position, String model) {
            if (BGANinePhotoLayout.this.mItemCornerRadius > 0) {
                BGAImageView imageView = (BGAImageView)helper.getView(R.id.iv_item_nine_photo_photo);
                imageView.setCornerRadius(BGANinePhotoLayout.this.mItemCornerRadius);
            }
            BGAImage.displayImage(BGANinePhotoLayout.this.mActivity, helper.getImageView(R.id.iv_item_nine_photo_photo), model, BGANinePhotoLayout.this.mPlaceholderDrawableResId, BGANinePhotoLayout.this.mPlaceholderDrawableResId, this.mImageWidth, this.mImageHeight, null);
        }
    }
}

