/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.support.v4.view.ViewPropertyAnimatorListener;
import android.support.v4.view.ViewPropertyAnimatorListenerAdapter;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.RelativeLayout;
import android.widget.TextView;
import cn.bingoogolapple.androidcommon.adapter.BGAOnNoDoubleClickListener;
import cn.bingoogolapple.photopicker.R;
import cn.bingoogolapple.photopicker.activity.BGAPPToolbarActivity;
import cn.bingoogolapple.photopicker.adapter.BGAPhotoPageAdapter;
import cn.bingoogolapple.photopicker.util.BGAPhotoPickerUtil;
import cn.bingoogolapple.photopicker.widget.BGAHackyViewPager;
import java.util.ArrayList;
import uk.co.senab.photoview.PhotoViewAttacher;

public class BGAPhotoPickerPreviewActivity
extends BGAPPToolbarActivity
implements PhotoViewAttacher.OnViewTapListener {
    private static final String EXTRA_PREVIEW_IMAGES = "EXTRA_PREVIEW_IMAGES";
    private static final String EXTRA_SELECTED_IMAGES = "EXTRA_SELECTED_IMAGES";
    private static final String EXTRA_MAX_CHOOSE_COUNT = "EXTRA_MAX_CHOOSE_COUNT";
    private static final String EXTRA_CURRENT_POSITION = "EXTRA_CURRENT_POSITION";
    private static final String EXTRA_IS_FROM_TAKE_PHOTO = "EXTRA_IS_FROM_TAKE_PHOTO";
    private TextView mTitleTv;
    private TextView mSubmitTv;
    private BGAHackyViewPager mContentHvp;
    private RelativeLayout mChooseRl;
    private TextView mChooseTv;
    private ArrayList<String> mSelectedImages;
    private BGAPhotoPageAdapter mPhotoPageAdapter;
    private int mMaxChooseCount = 1;
    private String mTopRightBtnText;
    private boolean mIsHidden = false;
    private long mLastShowHiddenTime;
    private boolean mIsFromTakePhoto;

    public static Intent newIntent(Context context, int maxChooseCount, ArrayList<String> selectedImages, ArrayList<String> previewImages, int currentPosition, boolean isFromTakePhoto) {
        Intent intent = new Intent(context, BGAPhotoPickerPreviewActivity.class);
        intent.putStringArrayListExtra(EXTRA_SELECTED_IMAGES, selectedImages);
        intent.putStringArrayListExtra(EXTRA_PREVIEW_IMAGES, previewImages);
        intent.putExtra(EXTRA_MAX_CHOOSE_COUNT, maxChooseCount);
        intent.putExtra(EXTRA_CURRENT_POSITION, currentPosition);
        intent.putExtra(EXTRA_IS_FROM_TAKE_PHOTO, isFromTakePhoto);
        return intent;
    }

    public static ArrayList<String> getSelectedImages(Intent intent) {
        return intent.getStringArrayListExtra(EXTRA_SELECTED_IMAGES);
    }

    public static boolean getIsFromTakePhoto(Intent intent) {
        return intent.getBooleanExtra(EXTRA_IS_FROM_TAKE_PHOTO, false);
    }

    @Override
    protected void initView(Bundle savedInstanceState) {
        this.setNoLinearContentView(R.layout.bga_pp_activity_photo_picker_preview);
        this.mContentHvp = (BGAHackyViewPager)((Object)this.getViewById(R.id.hvp_photo_picker_preview_content));
        this.mChooseRl = (RelativeLayout)this.getViewById(R.id.rl_photo_picker_preview_choose);
        this.mChooseTv = (TextView)this.getViewById(R.id.tv_photo_picker_preview_choose);
    }

    @Override
    protected void setListener() {
        this.mChooseTv.setOnClickListener((View.OnClickListener)new BGAOnNoDoubleClickListener(){

            public void onNoDoubleClick(View v) {
                String currentImage = BGAPhotoPickerPreviewActivity.this.mPhotoPageAdapter.getItem(BGAPhotoPickerPreviewActivity.this.mContentHvp.getCurrentItem());
                if (BGAPhotoPickerPreviewActivity.this.mSelectedImages.contains(currentImage)) {
                    BGAPhotoPickerPreviewActivity.this.mSelectedImages.remove(currentImage);
                    BGAPhotoPickerPreviewActivity.this.mChooseTv.setCompoundDrawablesWithIntrinsicBounds(R.mipmap.bga_pp_ic_cb_normal, 0, 0, 0);
                    BGAPhotoPickerPreviewActivity.this.renderTopRightBtn();
                } else if (BGAPhotoPickerPreviewActivity.this.mMaxChooseCount == 1) {
                    BGAPhotoPickerPreviewActivity.this.mSelectedImages.clear();
                    BGAPhotoPickerPreviewActivity.this.mSelectedImages.add(currentImage);
                    BGAPhotoPickerPreviewActivity.this.mChooseTv.setCompoundDrawablesWithIntrinsicBounds(R.mipmap.bga_pp_ic_cb_checked, 0, 0, 0);
                    BGAPhotoPickerPreviewActivity.this.renderTopRightBtn();
                } else if (BGAPhotoPickerPreviewActivity.this.mMaxChooseCount == BGAPhotoPickerPreviewActivity.this.mSelectedImages.size()) {
                    BGAPhotoPickerUtil.show(BGAPhotoPickerPreviewActivity.this.getString(R.string.bga_pp_toast_photo_picker_max, new Object[]{BGAPhotoPickerPreviewActivity.this.mMaxChooseCount}));
                } else {
                    BGAPhotoPickerPreviewActivity.this.mSelectedImages.add(currentImage);
                    BGAPhotoPickerPreviewActivity.this.mChooseTv.setCompoundDrawablesWithIntrinsicBounds(R.mipmap.bga_pp_ic_cb_checked, 0, 0, 0);
                    BGAPhotoPickerPreviewActivity.this.renderTopRightBtn();
                }
            }
        });
        this.mContentHvp.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                BGAPhotoPickerPreviewActivity.this.handlePageSelectedStatus();
            }
        });
    }

    @Override
    protected void processLogic(Bundle savedInstanceState) {
        this.mMaxChooseCount = this.getIntent().getIntExtra(EXTRA_MAX_CHOOSE_COUNT, 1);
        if (this.mMaxChooseCount < 1) {
            this.mMaxChooseCount = 1;
        }
        this.mSelectedImages = this.getIntent().getStringArrayListExtra(EXTRA_SELECTED_IMAGES);
        ArrayList previewImages = this.getIntent().getStringArrayListExtra(EXTRA_PREVIEW_IMAGES);
        if (TextUtils.isEmpty((CharSequence)((CharSequence)previewImages.get(0)))) {
            previewImages.remove(0);
        }
        this.mIsFromTakePhoto = this.getIntent().getBooleanExtra(EXTRA_IS_FROM_TAKE_PHOTO, false);
        if (this.mIsFromTakePhoto) {
            this.mChooseRl.setVisibility(4);
        }
        int currentPosition = this.getIntent().getIntExtra(EXTRA_CURRENT_POSITION, 0);
        this.mTopRightBtnText = this.getString(R.string.bga_pp_confirm);
        this.mPhotoPageAdapter = new BGAPhotoPageAdapter((Activity)this, this, previewImages);
        this.mContentHvp.setAdapter(this.mPhotoPageAdapter);
        this.mContentHvp.setCurrentItem(currentPosition);
        this.mToolbar.postDelayed(new Runnable(){

            @Override
            public void run() {
                BGAPhotoPickerPreviewActivity.this.hiddenToolBarAndChooseBar();
            }
        }, 2000L);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.bga_pp_menu_photo_picker_preview, menu2);
        MenuItem menuItem = menu2.findItem(R.id.item_photo_picker_preview_title);
        View actionView = menuItem.getActionView();
        this.mTitleTv = (TextView)actionView.findViewById(R.id.tv_photo_picker_preview_title);
        this.mSubmitTv = (TextView)actionView.findViewById(R.id.tv_photo_picker_preview_submit);
        this.mSubmitTv.setOnClickListener((View.OnClickListener)new BGAOnNoDoubleClickListener(){

            public void onNoDoubleClick(View v) {
                Intent intent = new Intent();
                intent.putStringArrayListExtra(BGAPhotoPickerPreviewActivity.EXTRA_SELECTED_IMAGES, BGAPhotoPickerPreviewActivity.this.mSelectedImages);
                intent.putExtra(BGAPhotoPickerPreviewActivity.EXTRA_IS_FROM_TAKE_PHOTO, BGAPhotoPickerPreviewActivity.this.mIsFromTakePhoto);
                BGAPhotoPickerPreviewActivity.this.setResult(-1, intent);
                BGAPhotoPickerPreviewActivity.this.finish();
            }
        });
        this.renderTopRightBtn();
        this.handlePageSelectedStatus();
        return true;
    }

    public void onBackPressed() {
        Intent intent = new Intent();
        intent.putStringArrayListExtra(EXTRA_SELECTED_IMAGES, this.mSelectedImages);
        intent.putExtra(EXTRA_IS_FROM_TAKE_PHOTO, this.mIsFromTakePhoto);
        this.setResult(0, intent);
        this.finish();
    }

    private void handlePageSelectedStatus() {
        if (this.mTitleTv == null || this.mPhotoPageAdapter == null) {
            return;
        }
        this.mTitleTv.setText((CharSequence)(this.mContentHvp.getCurrentItem() + 1 + "/" + this.mPhotoPageAdapter.getCount()));
        if (this.mSelectedImages.contains(this.mPhotoPageAdapter.getItem(this.mContentHvp.getCurrentItem()))) {
            this.mChooseTv.setCompoundDrawablesWithIntrinsicBounds(R.mipmap.bga_pp_ic_cb_checked, 0, 0, 0);
        } else {
            this.mChooseTv.setCompoundDrawablesWithIntrinsicBounds(R.mipmap.bga_pp_ic_cb_normal, 0, 0, 0);
        }
    }

    private void renderTopRightBtn() {
        if (this.mIsFromTakePhoto) {
            this.mSubmitTv.setEnabled(true);
            this.mSubmitTv.setText((CharSequence)this.mTopRightBtnText);
        } else if (this.mSelectedImages.size() == 0) {
            this.mSubmitTv.setEnabled(false);
            this.mSubmitTv.setText((CharSequence)this.mTopRightBtnText);
        } else {
            this.mSubmitTv.setEnabled(true);
            this.mSubmitTv.setText((CharSequence)(this.mTopRightBtnText + "(" + this.mSelectedImages.size() + "/" + this.mMaxChooseCount + ")"));
        }
    }

    @Override
    public void onViewTap(View view, float x, float y) {
        if (System.currentTimeMillis() - this.mLastShowHiddenTime > 500L) {
            this.mLastShowHiddenTime = System.currentTimeMillis();
            if (this.mIsHidden) {
                this.showTitleBarAndChooseBar();
            } else {
                this.hiddenToolBarAndChooseBar();
            }
        }
    }

    @Override
    protected void onDestroy() {
        this.mTitleTv = null;
        this.mSubmitTv = null;
        this.mContentHvp = null;
        this.mChooseRl = null;
        this.mChooseTv = null;
        this.mSelectedImages = null;
        this.mPhotoPageAdapter = null;
        super.onDestroy();
    }

    private void showTitleBarAndChooseBar() {
        if (this.mToolbar != null) {
            ViewCompat.animate((View)this.mToolbar).translationY(0.0f).setInterpolator((Interpolator)new DecelerateInterpolator(2.0f)).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                public void onAnimationEnd(View view) {
                    BGAPhotoPickerPreviewActivity.this.mIsHidden = false;
                }
            }).start();
        }
        if (!this.mIsFromTakePhoto && this.mChooseRl != null) {
            this.mChooseRl.setVisibility(0);
            ViewCompat.setAlpha((View)this.mChooseRl, (float)0.0f);
            ViewCompat.animate((View)this.mChooseRl).alpha(1.0f).setInterpolator((Interpolator)new DecelerateInterpolator(2.0f)).start();
        }
    }

    private void hiddenToolBarAndChooseBar() {
        if (this.mToolbar != null) {
            ViewCompat.animate((View)this.mToolbar).translationY((float)(-this.mToolbar.getHeight())).setInterpolator((Interpolator)new DecelerateInterpolator(2.0f)).setListener((ViewPropertyAnimatorListener)new ViewPropertyAnimatorListenerAdapter(){

                public void onAnimationEnd(View view) {
                    BGAPhotoPickerPreviewActivity.this.mIsHidden = true;
                    if (BGAPhotoPickerPreviewActivity.this.mChooseRl != null) {
                        BGAPhotoPickerPreviewActivity.this.mChooseRl.setVisibility(4);
                    }
                }
            }).start();
        }
        if (!this.mIsFromTakePhoto && this.mChooseRl != null) {
            ViewCompat.animate((View)this.mChooseRl).alpha(0.0f).setInterpolator((Interpolator)new DecelerateInterpolator(2.0f)).start();
        }
    }
}

