/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.adapter;

import android.app.Activity;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import cn.bingoogolapple.photopicker.R;
import cn.bingoogolapple.photopicker.imageloader.BGAImage;
import cn.bingoogolapple.photopicker.util.BGABrowserPhotoViewAttacher;
import cn.bingoogolapple.photopicker.util.BGAPhotoPickerUtil;
import cn.bingoogolapple.photopicker.widget.BGAImageView;
import java.util.ArrayList;
import uk.co.senab.photoview.PhotoViewAttacher;

public class BGAPhotoPageAdapter
extends PagerAdapter {
    private ArrayList<String> mPreviewImages;
    private PhotoViewAttacher.OnViewTapListener mOnViewTapListener;
    private Activity mActivity;

    public BGAPhotoPageAdapter(Activity activity, PhotoViewAttacher.OnViewTapListener onViewTapListener, ArrayList<String> previewImages) {
        this.mOnViewTapListener = onViewTapListener;
        this.mPreviewImages = previewImages;
        this.mActivity = activity;
    }

    public int getCount() {
        return this.mPreviewImages == null ? 0 : this.mPreviewImages.size();
    }

    public View instantiateItem(ViewGroup container, int position) {
        BGAImageView imageView = new BGAImageView(container.getContext());
        container.addView((View)imageView, -1, -1);
        final BGABrowserPhotoViewAttacher photoViewAttacher = new BGABrowserPhotoViewAttacher((ImageView)imageView);
        photoViewAttacher.setOnViewTapListener(this.mOnViewTapListener);
        imageView.setDelegate(new BGAImageView.Delegate(){

            @Override
            public void onDrawableChanged(Drawable drawable) {
                if (drawable != null && drawable.getIntrinsicHeight() > drawable.getIntrinsicWidth() && drawable.getIntrinsicHeight() > BGAPhotoPickerUtil.getScreenHeight()) {
                    photoViewAttacher.setIsSetTopCrop(true);
                    photoViewAttacher.setUpdateBaseMatrix();
                } else {
                    photoViewAttacher.update();
                }
            }
        });
        BGAImage.display((ImageView)imageView, R.mipmap.bga_pp_ic_holder_dark, this.mPreviewImages.get(position), BGAPhotoPickerUtil.getScreenWidth(), BGAPhotoPickerUtil.getScreenHeight());
        return imageView;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public String getItem(int position) {
        return this.mPreviewImages == null ? "" : this.mPreviewImages.get(position);
    }
}

