/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.adapter;

import android.support.v7.widget.RecyclerView;
import cn.bingoogolapple.androidcommon.adapter.BGARecyclerViewAdapter;
import cn.bingoogolapple.androidcommon.adapter.BGAViewHolderHelper;
import cn.bingoogolapple.photopicker.R;
import cn.bingoogolapple.photopicker.imageloader.BGAImage;
import cn.bingoogolapple.photopicker.model.BGAImageFolderModel;
import cn.bingoogolapple.photopicker.util.BGAPhotoPickerUtil;
import java.util.ArrayList;

public class BGAPhotoPickerAdapter
extends BGARecyclerViewAdapter<String> {
    private ArrayList<String> mSelectedImages = new ArrayList();
    private int mImageSize = BGAPhotoPickerUtil.getScreenWidth() / 6;
    private boolean mTakePhotoEnabled;

    public BGAPhotoPickerAdapter(RecyclerView recyclerView) {
        super(recyclerView, R.layout.bga_pp_item_photo_picker);
    }

    public int getItemViewType(int position) {
        if (this.mTakePhotoEnabled && position == 0) {
            return R.layout.bga_pp_item_photo_camera;
        }
        return R.layout.bga_pp_item_photo_picker;
    }

    public void setItemChildListener(BGAViewHolderHelper helper, int viewType) {
        if (viewType == R.layout.bga_pp_item_photo_camera) {
            helper.setItemChildClickListener(R.id.iv_item_photo_camera_camera);
        } else {
            helper.setItemChildClickListener(R.id.iv_item_photo_picker_flag);
            helper.setItemChildClickListener(R.id.iv_item_photo_picker_photo);
        }
    }

    protected void fillData(BGAViewHolderHelper helper, int position, String model) {
        if (this.getItemViewType(position) == R.layout.bga_pp_item_photo_picker) {
            BGAImage.display(helper.getImageView(R.id.iv_item_photo_picker_photo), R.mipmap.bga_pp_ic_holder_dark, model, this.mImageSize);
            if (this.mSelectedImages.contains(model)) {
                helper.setImageResource(R.id.iv_item_photo_picker_flag, R.mipmap.bga_pp_ic_cb_checked);
                helper.getImageView(R.id.iv_item_photo_picker_photo).setColorFilter(helper.getConvertView().getResources().getColor(R.color.bga_pp_photo_selected_mask));
            } else {
                helper.setImageResource(R.id.iv_item_photo_picker_flag, R.mipmap.bga_pp_ic_cb_normal);
                helper.getImageView(R.id.iv_item_photo_picker_photo).setColorFilter(null);
            }
        }
    }

    public void setSelectedImages(ArrayList<String> selectedImages) {
        if (selectedImages != null) {
            this.mSelectedImages = selectedImages;
        }
        this.notifyDataSetChanged();
    }

    public ArrayList<String> getSelectedImages() {
        return this.mSelectedImages;
    }

    public int getSelectedCount() {
        return this.mSelectedImages.size();
    }

    public void setImageFolderModel(BGAImageFolderModel imageFolderModel) {
        this.mTakePhotoEnabled = imageFolderModel.isTakePhotoEnabled();
        this.setData(imageFolderModel.getImages());
    }
}

