/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.imageloader;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.view.View;
import android.widget.ImageView;
import cn.bingoogolapple.photopicker.imageloader.BGAImageLoader;
import cn.bingoogolapple.photopicker.util.BGAPhotoPickerUtil;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.resource.drawable.GlideDrawable;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;

public class BGAGlideImageLoader
extends BGAImageLoader {
    @Override
    public void display(final ImageView imageView, String path, @DrawableRes int loadingResId, @DrawableRes int failResId, int width, int height, final BGAImageLoader.DisplayDelegate delegate) {
        final String finalPath = this.getPath(path);
        Activity activity = (Activity)imageView.getContext();
        Glide.with((Activity)activity).load(finalPath).placeholder(loadingResId).error(failResId).override(width, height).dontAnimate().listener((RequestListener)new RequestListener<String, GlideDrawable>(){

            public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                return false;
            }

            public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                if (delegate != null) {
                    delegate.onSuccess((View)imageView, finalPath);
                }
                return false;
            }
        }).into(imageView);
    }

    @Override
    public void download(String path, final BGAImageLoader.DownloadDelegate delegate) {
        final String finalPath = this.getPath(path);
        Glide.with((Context)BGAPhotoPickerUtil.sApp).load(finalPath).asBitmap().into((Target)new SimpleTarget<Bitmap>(){

            public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
                if (delegate != null) {
                    delegate.onSuccess(finalPath, resource);
                }
            }

            public void onLoadFailed(Exception e, Drawable errorDrawable) {
                if (delegate != null) {
                    delegate.onFailed(finalPath);
                }
            }
        });
    }

    @Override
    public void pause(Activity activity) {
        Glide.with((Activity)activity).pauseRequests();
    }

    @Override
    public void resume(Activity activity) {
        Glide.with((Activity)activity).resumeRequestsRecursive();
    }
}

