/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.photopicker.util;

import android.app.Application;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.WindowManager;
import android.widget.Toast;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class BGAPhotoPickerUtil {
    public static final Application sApp;
    private static Handler sHandler;

    private BGAPhotoPickerUtil() {
    }

    public static void runInThread(Runnable task) {
        new Thread(task).start();
    }

    public static void runInUIThread(Runnable task) {
        sHandler.post(task);
    }

    public static void runInUIThread(Runnable task, long delayMillis) {
        sHandler.postDelayed(task, delayMillis);
    }

    public static int getScreenWidth() {
        WindowManager windowManager = (WindowManager)sApp.getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(dm);
        return dm.widthPixels;
    }

    public static int getScreenHeight() {
        WindowManager windowManager = (WindowManager)sApp.getSystemService("window");
        DisplayMetrics dm = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(dm);
        return dm.heightPixels;
    }

    public static int dp2px(float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)sApp.getResources().getDisplayMetrics());
    }

    public static String md5(String ... strs) {
        if (strs == null || strs.length == 0) {
            throw new RuntimeException("\u8bf7\u8f93\u5165\u9700\u8981\u52a0\u5bc6\u7684\u5b57\u7b26\u4e32!");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            boolean isNeedThrowNotNullException = true;
            for (String str : strs) {
                if (TextUtils.isEmpty((CharSequence)str)) continue;
                isNeedThrowNotNullException = false;
                md.update(str.getBytes());
            }
            if (isNeedThrowNotNullException) {
                throw new RuntimeException("\u8bf7\u8f93\u5165\u9700\u8981\u52a0\u5bc6\u7684\u5b57\u7b26\u4e32!");
            }
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void show(CharSequence text) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            if (text.length() < 10) {
                Toast.makeText((Context)sApp, (CharSequence)text, (int)0).show();
            } else {
                Toast.makeText((Context)sApp, (CharSequence)text, (int)1).show();
            }
        }
    }

    public static void show(@StringRes int resId) {
        BGAPhotoPickerUtil.show(sApp.getString(resId));
    }

    public static void showSafe(final CharSequence text) {
        BGAPhotoPickerUtil.runInUIThread(new Runnable(){

            @Override
            public void run() {
                BGAPhotoPickerUtil.show(text);
            }
        });
    }

    public static void showSafe(@StringRes int resId) {
        BGAPhotoPickerUtil.showSafe(sApp.getString(resId));
    }

    static {
        sHandler = new Handler(Looper.getMainLooper());
        Application app = null;
        try {
            app = (Application)Class.forName("android.app.AppGlobals").getMethod("getInitialApplication", new Class[0]).invoke(null, new Object[0]);
            if (app == null) {
                throw new IllegalStateException("Static initialization of Applications must be on main thread.");
            }
        }
        catch (Exception e) {
            Log.e((String)BGAPhotoPickerUtil.class.getSimpleName(), (String)("Failed to get current application from AppGlobals." + e.getMessage()));
            try {
                app = (Application)Class.forName("android.app.ActivityThread").getMethod("currentApplication", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                Log.e((String)BGAPhotoPickerUtil.class.getSimpleName(), (String)("Failed to get current application from ActivityThread." + e.getMessage()));
            }
        }
        finally {
            sApp = app;
        }
    }
}

