/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.qrcode.core;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import cn.bingoogolapple.qrcode.core.CameraPreview;
import cn.bingoogolapple.qrcode.core.ScanBoxView;

public abstract class QRCodeView
extends FrameLayout
implements Camera.PreviewCallback {
    protected Camera mCamera;
    protected CameraPreview mPreview;
    protected ScanBoxView mScanBoxView;
    protected Delegate mDelegate;
    protected Handler mHandler;
    private Runnable mOneShotPreviewCallbackTask = new Runnable(){

        @Override
        public void run() {
            if (QRCodeView.this.mCamera != null) {
                QRCodeView.this.mCamera.setOneShotPreviewCallback((Camera.PreviewCallback)QRCodeView.this);
            }
        }
    };

    public QRCodeView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public QRCodeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mHandler = new Handler();
        this.initView(context, attrs);
    }

    public void setResultHandler(Delegate delegate) {
        this.mDelegate = delegate;
    }

    private void initView(Context context, AttributeSet attrs) {
        this.mPreview = new CameraPreview(this.getContext());
        this.mScanBoxView = new ScanBoxView(this.getContext());
        this.mScanBoxView.initCustomAttrs(context, attrs);
        this.addView((View)this.mPreview);
        this.addView(this.mScanBoxView);
    }

    public void showScanRect() {
        if (this.mScanBoxView != null) {
            this.mScanBoxView.setVisibility(0);
        }
    }

    public void hiddenScanRect() {
        if (this.mScanBoxView != null) {
            this.mScanBoxView.setVisibility(8);
        }
    }

    public void startCamera() {
        block4: {
            if (this.mCamera != null) {
                return;
            }
            try {
                this.mCamera = Camera.open();
            }
            catch (Exception e) {
                if (this.mDelegate == null) break block4;
                this.mDelegate.onScanQRCodeOpenCameraError();
            }
        }
        if (this.mCamera != null) {
            this.mPreview.setCamera(this.mCamera);
            this.mPreview.initCameraPreview();
        }
    }

    public void stopCamera() {
        this.stopSpotAndHiddenRect();
        if (this.mCamera != null) {
            this.mPreview.stopCameraPreview();
            this.mPreview.setCamera(null);
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    public void startSpot() {
        this.startSpotDelay(1500);
    }

    public void startSpotDelay(int delay) {
        this.startCamera();
        this.mHandler.removeCallbacks(this.mOneShotPreviewCallbackTask);
        this.mHandler.postDelayed(this.mOneShotPreviewCallbackTask, (long)delay);
    }

    public void stopSpot() {
        if (this.mCamera != null) {
            this.mCamera.setOneShotPreviewCallback(null);
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mOneShotPreviewCallbackTask);
        }
    }

    public void stopSpotAndHiddenRect() {
        this.stopSpot();
        this.hiddenScanRect();
    }

    public void startSpotAndShowRect() {
        this.startSpot();
        this.showScanRect();
    }

    public void openFlashlight() {
        this.mPreview.openFlashlight();
    }

    public void closeFlashlight() {
        this.mPreview.closeFlashlight();
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        Camera.Size size = parameters.getPreviewSize();
        int width = size.width;
        int height = size.height;
        byte[] rotatedData = new byte[data.length];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                rotatedData[x * height + height - y - 1] = data[x + y * width];
            }
        }
        int tmp = width;
        width = height;
        height = tmp;
        data = rotatedData;
        this.handleData(data, width, height, camera);
    }

    protected abstract void handleData(byte[] var1, int var2, int var3, Camera var4);

    public static interface Delegate {
        public void onScanQRCodeSuccess(String var1);

        public void onScanQRCodeOpenCameraError();
    }
}

