/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.qrcode.core;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import cn.bingoogolapple.qrcode.core.DisplayUtils;
import cn.bingoogolapple.qrcode.core.R;

public class ScanBoxView
extends View {
    private static int mMoveStepDistance;
    private int mAnimDelayTime;
    private Rect mFramingRect;
    private float mScanLineTop;
    private Paint mPaint = new Paint();
    private int mMaskColor;
    private int mCornerColor;
    private int mCornerLength;
    private int mCornerSize;
    private int mRectWidth;
    private int mTopOffset;
    private int mScanLineSize;
    private int mScanLineColor;
    private int mScanLineHorizontalMargin;
    private boolean mIsShowDefaultScanLineDrawable;
    private Drawable mCustomScanLineDrawable;
    private Bitmap mScanLineBitmap;
    private int mBorderSize;
    private int mBorderColor;
    private int mAnimTime;
    private float mHalfCornerSize;

    public ScanBoxView(Context context) {
        super(context);
        this.mPaint.setAntiAlias(true);
        this.mMaskColor = Color.parseColor((String)"#33FFFFFF");
        this.mCornerColor = -1;
        this.mCornerLength = DisplayUtils.dp2px(context, 20.0f);
        this.mCornerSize = DisplayUtils.dp2px(context, 3.0f);
        this.mScanLineSize = DisplayUtils.dp2px(context, 1.0f);
        this.mScanLineColor = -1;
        this.mTopOffset = DisplayUtils.dp2px(context, 90.0f);
        this.mRectWidth = DisplayUtils.dp2px(context, 200.0f);
        this.mScanLineHorizontalMargin = 0;
        this.mIsShowDefaultScanLineDrawable = false;
        this.mCustomScanLineDrawable = null;
        this.mScanLineBitmap = null;
        this.mBorderSize = DisplayUtils.dp2px(context, 1.0f);
        this.mBorderColor = -1;
        this.mAnimTime = 1000;
        mMoveStepDistance = DisplayUtils.dp2px(context, 2.0f);
    }

    public void initCustomAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.QRCodeView);
        int count = typedArray.getIndexCount();
        for (int i = 0; i < count; ++i) {
            this.initCustomAttr(typedArray.getIndex(i), typedArray);
        }
        typedArray.recycle();
        this.afterInitCustomAttrs();
    }

    private void initCustomAttr(int attr, TypedArray typedArray) {
        if (attr == R.styleable.QRCodeView_qrcv_topOffset) {
            this.mTopOffset = typedArray.getDimensionPixelSize(attr, this.mTopOffset);
        } else if (attr == R.styleable.QRCodeView_qrcv_cornerSize) {
            this.mCornerSize = typedArray.getDimensionPixelSize(attr, this.mCornerSize);
        } else if (attr == R.styleable.QRCodeView_qrcv_cornerLength) {
            this.mCornerLength = typedArray.getDimensionPixelSize(attr, this.mCornerLength);
        } else if (attr == R.styleable.QRCodeView_qrcv_scanLineSize) {
            this.mScanLineSize = typedArray.getDimensionPixelSize(attr, this.mScanLineSize);
        } else if (attr == R.styleable.QRCodeView_qrcv_rectWidth) {
            this.mRectWidth = typedArray.getDimensionPixelSize(attr, this.mRectWidth);
        } else if (attr == R.styleable.QRCodeView_qrcv_maskColor) {
            this.mMaskColor = typedArray.getColor(attr, this.mMaskColor);
        } else if (attr == R.styleable.QRCodeView_qrcv_cornerColor) {
            this.mCornerColor = typedArray.getColor(attr, this.mCornerColor);
        } else if (attr == R.styleable.QRCodeView_qrcv_scanLineColor) {
            this.mScanLineColor = typedArray.getColor(attr, this.mScanLineColor);
        } else if (attr == R.styleable.QRCodeView_qrcv_scanLineHorizontalMargin) {
            this.mScanLineHorizontalMargin = typedArray.getDimensionPixelSize(attr, this.mScanLineHorizontalMargin);
        } else if (attr == R.styleable.QRCodeView_qrcv_isShowDefaultScanLineDrawable) {
            this.mIsShowDefaultScanLineDrawable = typedArray.getBoolean(attr, this.mIsShowDefaultScanLineDrawable);
        } else if (attr == R.styleable.QRCodeView_qrcv_customScanLineDrawable) {
            this.mCustomScanLineDrawable = typedArray.getDrawable(attr);
        } else if (attr == R.styleable.QRCodeView_qrcv_borderSize) {
            this.mBorderSize = typedArray.getDimensionPixelSize(attr, this.mBorderSize);
        } else if (attr == R.styleable.QRCodeView_qrcv_borderColor) {
            this.mBorderColor = typedArray.getColor(attr, this.mBorderColor);
        } else if (attr == R.styleable.QRCodeView_qrcv_animTime) {
            this.mAnimTime = typedArray.getInteger(attr, this.mAnimTime);
        }
    }

    private void afterInitCustomAttrs() {
        if (this.mIsShowDefaultScanLineDrawable) {
            Bitmap defaultScanLineBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.mipmap.qrcode_default_scan_line);
            this.mScanLineBitmap = ScanBoxView.makeTintBitmap(defaultScanLineBitmap, this.mScanLineColor);
        }
        if (this.mCustomScanLineDrawable != null) {
            this.mScanLineBitmap = ((BitmapDrawable)this.mCustomScanLineDrawable).getBitmap();
        }
        this.mAnimDelayTime = (int)(1.0f * (float)this.mAnimTime * (float)mMoveStepDistance / (float)this.mRectWidth);
        this.mHalfCornerSize = 1.0f * (float)this.mCornerSize / 2.0f;
    }

    public static Bitmap makeTintBitmap(Bitmap src, int tintColor) {
        Bitmap result = Bitmap.createBitmap((int)src.getWidth(), (int)src.getHeight(), (Bitmap.Config)src.getConfig());
        Canvas canvas = new Canvas(result);
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new PorterDuffColorFilter(tintColor, PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(src, 0.0f, 0.0f, paint);
        return result;
    }

    public void onDraw(Canvas canvas) {
        if (this.mFramingRect == null) {
            return;
        }
        this.drawMask(canvas);
        this.drawBorderLine(canvas);
        this.drawCornerLine(canvas);
        this.drawScanLine(canvas);
        this.moveScanLine();
    }

    private void drawMask(Canvas canvas) {
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        if (this.mMaskColor != 0) {
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(this.mMaskColor);
            canvas.drawRect(0.0f, 0.0f, (float)width, (float)this.mFramingRect.top, this.mPaint);
            canvas.drawRect(0.0f, (float)this.mFramingRect.top, (float)this.mFramingRect.left, (float)(this.mFramingRect.bottom + 1), this.mPaint);
            canvas.drawRect((float)(this.mFramingRect.right + 1), (float)this.mFramingRect.top, (float)width, (float)(this.mFramingRect.bottom + 1), this.mPaint);
            canvas.drawRect(0.0f, (float)(this.mFramingRect.bottom + 1), (float)width, (float)height, this.mPaint);
        }
    }

    private void drawBorderLine(Canvas canvas) {
        if (this.mBorderSize > 0) {
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setColor(this.mBorderColor);
            this.mPaint.setStrokeWidth((float)this.mBorderSize);
            canvas.drawRect(this.mFramingRect, this.mPaint);
        }
    }

    private void drawCornerLine(Canvas canvas) {
        if (this.mHalfCornerSize > 0.0f) {
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setColor(this.mCornerColor);
            this.mPaint.setStrokeWidth((float)this.mCornerSize);
            canvas.drawLine((float)this.mFramingRect.left - this.mHalfCornerSize, (float)this.mFramingRect.top, (float)this.mFramingRect.left - this.mHalfCornerSize + (float)this.mCornerLength, (float)this.mFramingRect.top, this.mPaint);
            canvas.drawLine((float)this.mFramingRect.left, (float)this.mFramingRect.top - this.mHalfCornerSize, (float)this.mFramingRect.left, (float)this.mFramingRect.top - this.mHalfCornerSize + (float)this.mCornerLength, this.mPaint);
            canvas.drawLine((float)this.mFramingRect.right + this.mHalfCornerSize, (float)this.mFramingRect.top, (float)this.mFramingRect.right + this.mHalfCornerSize - (float)this.mCornerLength, (float)this.mFramingRect.top, this.mPaint);
            canvas.drawLine((float)this.mFramingRect.right, (float)this.mFramingRect.top - this.mHalfCornerSize, (float)this.mFramingRect.right, (float)this.mFramingRect.top - this.mHalfCornerSize + (float)this.mCornerLength, this.mPaint);
            canvas.drawLine((float)this.mFramingRect.left - this.mHalfCornerSize, (float)this.mFramingRect.bottom, (float)this.mFramingRect.left - this.mHalfCornerSize + (float)this.mCornerLength, (float)this.mFramingRect.bottom, this.mPaint);
            canvas.drawLine((float)this.mFramingRect.left, (float)this.mFramingRect.bottom + this.mHalfCornerSize, (float)this.mFramingRect.left, (float)this.mFramingRect.bottom + this.mHalfCornerSize - (float)this.mCornerLength, this.mPaint);
            canvas.drawLine((float)this.mFramingRect.right + this.mHalfCornerSize, (float)this.mFramingRect.bottom, (float)this.mFramingRect.right + this.mHalfCornerSize - (float)this.mCornerLength, (float)this.mFramingRect.bottom, this.mPaint);
            canvas.drawLine((float)this.mFramingRect.right, (float)this.mFramingRect.bottom + this.mHalfCornerSize, (float)this.mFramingRect.right, (float)this.mFramingRect.bottom + this.mHalfCornerSize - (float)this.mCornerLength, this.mPaint);
        }
    }

    private void drawScanLine(Canvas canvas) {
        if (this.mScanLineBitmap == null) {
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(this.mScanLineColor);
            canvas.drawRect((float)this.mFramingRect.left + this.mHalfCornerSize + (float)this.mScanLineHorizontalMargin, this.mScanLineTop, (float)this.mFramingRect.right - this.mHalfCornerSize - (float)this.mScanLineHorizontalMargin, this.mScanLineTop + (float)this.mScanLineSize, this.mPaint);
        } else {
            RectF lineRect = new RectF((float)this.mFramingRect.left + this.mHalfCornerSize + (float)this.mScanLineHorizontalMargin, this.mScanLineTop, (float)this.mFramingRect.right - this.mHalfCornerSize - (float)this.mScanLineHorizontalMargin, this.mScanLineTop + (float)this.mScanLineBitmap.getHeight());
            canvas.drawBitmap(this.mScanLineBitmap, null, lineRect, this.mPaint);
        }
    }

    private void moveScanLine() {
        this.mScanLineTop += (float)mMoveStepDistance;
        int scanLineHeight = this.mScanLineSize;
        if (this.mScanLineBitmap != null) {
            scanLineHeight = this.mScanLineBitmap.getHeight();
        }
        if (this.mScanLineTop < (float)this.mFramingRect.top + this.mHalfCornerSize || this.mScanLineTop + (float)scanLineHeight > (float)this.mFramingRect.bottom - this.mHalfCornerSize) {
            mMoveStepDistance = -mMoveStepDistance;
        }
        this.postInvalidateDelayed(this.mAnimDelayTime, this.mFramingRect.left, this.mFramingRect.top, this.mFramingRect.right, this.mFramingRect.bottom);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        Point screenResolution = DisplayUtils.getScreenResolution(this.getContext());
        int leftOffset = (screenResolution.x - this.mRectWidth) / 2;
        this.mFramingRect = new Rect(leftOffset, this.mTopOffset, leftOffset + this.mRectWidth, this.mTopOffset + this.mRectWidth);
        this.mScanLineTop = (float)this.mTopOffset + this.mHalfCornerSize + 0.5f;
    }
}

