/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.qrcode.core;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.view.Display;
import android.view.WindowManager;
import java.util.Collection;
import java.util.regex.Pattern;

final class CameraConfigurationManager {
    private static final int TEN_DESIRED_ZOOM = 27;
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private final Context mContext;
    private Point mScreenResolution;
    private Point cameraResolution;

    public CameraConfigurationManager(Context context) {
        this.mContext = context;
    }

    public void initFromCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        WindowManager manager = (WindowManager)this.mContext.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        this.mScreenResolution = new Point(display.getWidth(), display.getHeight());
        Point screenResolutionForCamera = new Point();
        screenResolutionForCamera.x = this.mScreenResolution.x;
        screenResolutionForCamera.y = this.mScreenResolution.y;
        if (this.mScreenResolution.x < this.mScreenResolution.y) {
            screenResolutionForCamera.x = this.mScreenResolution.y;
            screenResolutionForCamera.y = this.mScreenResolution.x;
        }
        this.cameraResolution = CameraConfigurationManager.getCameraResolution(parameters, screenResolutionForCamera);
    }

    public void setDesiredCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        parameters.setPreviewSize(this.cameraResolution.x, this.cameraResolution.y);
        this.setZoom(parameters);
        camera.setDisplayOrientation(this.getDisplayOrientation());
        camera.setParameters(parameters);
    }

    public void openFlashlight(Camera camera) {
        this.doSetTorch(camera, true);
    }

    public void closeFlashlight(Camera camera) {
        this.doSetTorch(camera, false);
    }

    private void doSetTorch(Camera camera, boolean newSetting) {
        Camera.Parameters parameters = camera.getParameters();
        String flashMode = newSetting ? CameraConfigurationManager.findSettableValue(parameters.getSupportedFlashModes(), "torch", "on") : CameraConfigurationManager.findSettableValue(parameters.getSupportedFlashModes(), "off");
        if (flashMode != null) {
            parameters.setFlashMode(flashMode);
        }
        camera.setParameters(parameters);
    }

    private static String findSettableValue(Collection<String> supportedValues, String ... desiredValues) {
        String result = null;
        if (supportedValues != null) {
            for (String desiredValue : desiredValues) {
                if (!supportedValues.contains(desiredValue)) continue;
                result = desiredValue;
                break;
            }
        }
        return result;
    }

    public int getDisplayOrientation() {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)info);
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        int rotation = display.getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        return result;
    }

    private static Point getCameraResolution(Camera.Parameters parameters, Point screenResolution) {
        String previewSizeValueString = parameters.get("preview-size-values");
        if (previewSizeValueString == null) {
            previewSizeValueString = parameters.get("preview-size-value");
        }
        Point cameraResolution = null;
        if (previewSizeValueString != null) {
            cameraResolution = CameraConfigurationManager.findBestPreviewSizeValue(previewSizeValueString, screenResolution);
        }
        if (cameraResolution == null) {
            cameraResolution = new Point(screenResolution.x >> 3 << 3, screenResolution.y >> 3 << 3);
        }
        return cameraResolution;
    }

    private static Point findBestPreviewSizeValue(CharSequence previewSizeValueString, Point screenResolution) {
        int bestX = 0;
        int bestY = 0;
        int diff = Integer.MAX_VALUE;
        for (String previewSize : COMMA_PATTERN.split(previewSizeValueString)) {
            int newY;
            int newX;
            int dimPosition = (previewSize = previewSize.trim()).indexOf(120);
            if (dimPosition < 0) continue;
            try {
                newX = Integer.parseInt(previewSize.substring(0, dimPosition));
                newY = Integer.parseInt(previewSize.substring(dimPosition + 1));
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            int newDiff = Math.abs(newX - screenResolution.x) + Math.abs(newY - screenResolution.y);
            if (newDiff == 0) {
                bestX = newX;
                bestY = newY;
                break;
            }
            if (newDiff >= diff) continue;
            bestX = newX;
            bestY = newY;
            diff = newDiff;
        }
        if (bestX > 0 && bestY > 0) {
            return new Point(bestX, bestY);
        }
        return null;
    }

    private static int findBestMotZoomValue(CharSequence stringValues, int tenDesiredZoom) {
        int tenBestValue = 0;
        for (String stringValue : COMMA_PATTERN.split(stringValues)) {
            double value;
            stringValue = stringValue.trim();
            try {
                value = Double.parseDouble(stringValue);
            }
            catch (NumberFormatException nfe) {
                return tenDesiredZoom;
            }
            int tenValue = (int)(10.0 * value);
            if (!(Math.abs((double)tenDesiredZoom - value) < (double)Math.abs(tenDesiredZoom - tenBestValue))) continue;
            tenBestValue = tenValue;
        }
        return tenBestValue;
    }

    private void setZoom(Camera.Parameters parameters) {
        String motZoomStepString;
        String motZoomValuesString;
        String takingPictureZoomMaxString;
        String zoomSupportedString = parameters.get("zoom-supported");
        if (zoomSupportedString != null && !Boolean.parseBoolean(zoomSupportedString)) {
            return;
        }
        int tenDesiredZoom = 27;
        String maxZoomString = parameters.get("max-zoom");
        if (maxZoomString != null) {
            try {
                int tenMaxZoom = (int)(10.0 * Double.parseDouble(maxZoomString));
                if (tenDesiredZoom > tenMaxZoom) {
                    tenDesiredZoom = tenMaxZoom;
                }
            }
            catch (NumberFormatException tenMaxZoom) {
                // empty catch block
            }
        }
        if ((takingPictureZoomMaxString = parameters.get("taking-picture-zoom-max")) != null) {
            try {
                int tenMaxZoom = Integer.parseInt(takingPictureZoomMaxString);
                if (tenDesiredZoom > tenMaxZoom) {
                    tenDesiredZoom = tenMaxZoom;
                }
            }
            catch (NumberFormatException tenMaxZoom) {
                // empty catch block
            }
        }
        if ((motZoomValuesString = parameters.get("mot-zoom-values")) != null) {
            tenDesiredZoom = CameraConfigurationManager.findBestMotZoomValue(motZoomValuesString, tenDesiredZoom);
        }
        if ((motZoomStepString = parameters.get("mot-zoom-step")) != null) {
            try {
                double motZoomStep = Double.parseDouble(motZoomStepString.trim());
                int tenZoomStep = (int)(10.0 * motZoomStep);
                if (tenZoomStep > 1) {
                    tenDesiredZoom -= tenDesiredZoom % tenZoomStep;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (maxZoomString != null || motZoomValuesString != null) {
            parameters.set("zoom", String.valueOf((double)tenDesiredZoom / 10.0));
        }
        if (takingPictureZoomMaxString != null) {
            parameters.set("taking-picture-zoom", tenDesiredZoom);
        }
    }
}

