/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.qrcode.core;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import cn.bingoogolapple.qrcode.core.CameraConfigurationManager;

public class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final String TAG = CameraPreview.class.getSimpleName();
    private Camera mCamera;
    private Handler mAutoFocusHandler;
    private boolean mPreviewing = true;
    private boolean mAutoFocus = true;
    private boolean mSurfaceCreated = false;
    private CameraConfigurationManager mCameraConfigurationManager;
    private Runnable doAutoFocus = new Runnable(){

        @Override
        public void run() {
            if (CameraPreview.this.mCamera != null && CameraPreview.this.mPreviewing && CameraPreview.this.mAutoFocus && CameraPreview.this.mSurfaceCreated) {
                CameraPreview.this.mCamera.autoFocus(CameraPreview.this.autoFocusCB);
            }
        }
    };
    Camera.AutoFocusCallback autoFocusCB = new Camera.AutoFocusCallback(){

        public void onAutoFocus(boolean success, Camera camera) {
            CameraPreview.this.mAutoFocusHandler.postDelayed(CameraPreview.this.doAutoFocus, 1000L);
        }
    };

    public CameraPreview(Context context) {
        super(context);
    }

    public void setCamera(Camera camera) {
        this.mCamera = camera;
        if (this.mCamera != null) {
            this.mAutoFocusHandler = new Handler();
            this.mCameraConfigurationManager = new CameraConfigurationManager(this.getContext());
            this.mCameraConfigurationManager.initFromCameraParameters(this.mCamera);
        }
    }

    public void initCameraPreview() {
        if (this.mCamera != null) {
            this.getHolder().addCallback((SurfaceHolder.Callback)this);
            if (this.mPreviewing) {
                this.requestLayout();
            } else {
                this.showCameraPreview();
            }
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = true;
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i2, int i3) {
        if (surfaceHolder.getSurface() == null) {
            return;
        }
        this.stopCameraPreview();
        this.showCameraPreview();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = false;
        this.stopCameraPreview();
    }

    public void showCameraPreview() {
        if (this.mCamera != null) {
            try {
                this.mPreviewing = true;
                this.mCamera.setPreviewDisplay(this.getHolder());
                this.mCameraConfigurationManager.setDesiredCameraParameters(this.mCamera);
                this.mCamera.startPreview();
                if (this.mAutoFocus) {
                    this.mCamera.autoFocus(this.autoFocusCB);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString(), (Throwable)e);
            }
        }
    }

    public void stopCameraPreview() {
        if (this.mCamera != null) {
            try {
                this.mPreviewing = false;
                this.mCamera.cancelAutoFocus();
                this.mCamera.setOneShotPreviewCallback(null);
                this.mCamera.stopPreview();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString(), (Throwable)e);
            }
        }
    }

    public void openFlashlight() {
        if (this.flashLightAvaliable()) {
            this.mCameraConfigurationManager.openFlashlight(this.mCamera);
        }
    }

    public void closeFlashlight() {
        if (this.flashLightAvaliable()) {
            this.mCameraConfigurationManager.closeFlashlight(this.mCamera);
        }
    }

    private boolean flashLightAvaliable() {
        return this.mCamera != null && this.mPreviewing && this.mSurfaceCreated && this.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }
}

