/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.qrcode.core;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import cn.bingoogolapple.qrcode.core.CameraPreview;
import cn.bingoogolapple.qrcode.core.ProcessDataTask;
import cn.bingoogolapple.qrcode.core.ScanBoxView;

public abstract class QRCodeView
extends FrameLayout
implements Camera.PreviewCallback,
ProcessDataTask.Delegate {
    protected Camera mCamera;
    protected CameraPreview mPreview;
    protected ScanBoxView mScanBoxView;
    protected Delegate mDelegate;
    protected Handler mHandler;
    protected boolean mSpotAble = false;
    private Runnable mOneShotPreviewCallbackTask = new Runnable(){

        @Override
        public void run() {
            if (QRCodeView.this.mCamera != null && QRCodeView.this.mSpotAble) {
                QRCodeView.this.mCamera.setOneShotPreviewCallback((Camera.PreviewCallback)QRCodeView.this);
            }
        }
    };

    public QRCodeView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public QRCodeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mHandler = new Handler();
        this.initView(context, attrs);
    }

    public void setResultHandler(Delegate delegate) {
        this.mDelegate = delegate;
    }

    private void initView(Context context, AttributeSet attrs) {
        this.mPreview = new CameraPreview(this.getContext());
        this.mScanBoxView = new ScanBoxView(this.getContext());
        this.mScanBoxView.initCustomAttrs(context, attrs);
        this.addView((View)this.mPreview);
        this.addView(this.mScanBoxView);
    }

    public void showScanRect() {
        if (this.mScanBoxView != null) {
            this.mScanBoxView.setVisibility(0);
        }
    }

    public void hiddenScanRect() {
        if (this.mScanBoxView != null) {
            this.mScanBoxView.setVisibility(8);
        }
    }

    public void startCamera() {
        block4: {
            if (this.mCamera != null) {
                return;
            }
            try {
                this.mCamera = Camera.open();
            }
            catch (Exception e) {
                if (this.mDelegate == null) break block4;
                this.mDelegate.onScanQRCodeOpenCameraError();
            }
        }
        if (this.mCamera != null) {
            this.mPreview.setCamera(this.mCamera);
            this.mPreview.initCameraPreview();
        }
    }

    public void stopCamera() {
        this.stopSpotAndHiddenRect();
        if (this.mCamera != null) {
            this.mPreview.stopCameraPreview();
            this.mPreview.setCamera(null);
            this.mCamera.release();
            this.mCamera = null;
        }
    }

    public void startSpot() {
        this.startSpotDelay(1500);
    }

    public void startSpotDelay(int delay) {
        this.mSpotAble = true;
        this.startCamera();
        this.mHandler.removeCallbacks(this.mOneShotPreviewCallbackTask);
        this.mHandler.postDelayed(this.mOneShotPreviewCallbackTask, (long)delay);
    }

    public void stopSpot() {
        this.mSpotAble = false;
        if (this.mCamera != null) {
            this.mCamera.setOneShotPreviewCallback(null);
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mOneShotPreviewCallbackTask);
        }
    }

    public void stopSpotAndHiddenRect() {
        this.stopSpot();
        this.hiddenScanRect();
    }

    public void startSpotAndShowRect() {
        this.startSpot();
        this.showScanRect();
    }

    public void openFlashlight() {
        this.mPreview.openFlashlight();
    }

    public void closeFlashlight() {
        this.mPreview.closeFlashlight();
    }

    public void onPreviewFrame(byte[] data, final Camera camera) {
        if (this.mSpotAble) {
            new ProcessDataTask(camera, data, this){

                protected void onPostExecute(String result) {
                    if (QRCodeView.this.mSpotAble) {
                        if (QRCodeView.this.mDelegate != null && !TextUtils.isEmpty((CharSequence)result)) {
                            QRCodeView.this.mDelegate.onScanQRCodeSuccess(result);
                        } else {
                            try {
                                camera.setOneShotPreviewCallback((Camera.PreviewCallback)QRCodeView.this);
                            }
                            catch (RuntimeException runtimeException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }.execute(new Void[0]);
        }
    }

    public static interface Delegate {
        public void onScanQRCodeSuccess(String var1);

        public void onScanQRCodeOpenCameraError();
    }
}

