/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.qrcode.core;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import cn.bingoogolapple.qrcode.core.CameraConfigurationManager;

public class CameraPreview
extends SurfaceView
implements SurfaceHolder.Callback {
    private static final String TAG = CameraPreview.class.getSimpleName();
    private Camera mCamera;
    private boolean mPreviewing = true;
    private boolean mAutoFocus = true;
    private boolean mSurfaceCreated = false;
    private CameraConfigurationManager mCameraConfigurationManager;
    private Runnable doAutoFocus = new Runnable(){

        @Override
        public void run() {
            if (CameraPreview.this.mCamera != null && CameraPreview.this.mPreviewing && CameraPreview.this.mAutoFocus && CameraPreview.this.mSurfaceCreated) {
                try {
                    CameraPreview.this.mCamera.autoFocus(CameraPreview.this.autoFocusCB);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    };
    Camera.AutoFocusCallback autoFocusCB = new Camera.AutoFocusCallback(){

        public void onAutoFocus(boolean success, Camera camera) {
            CameraPreview.this.postDelayed(CameraPreview.this.doAutoFocus, 1000L);
        }
    };

    public CameraPreview(Context context) {
        super(context);
    }

    public void setCamera(Camera camera) {
        this.mCamera = camera;
        if (this.mCamera != null) {
            this.mCameraConfigurationManager = new CameraConfigurationManager(this.getContext());
            this.mCameraConfigurationManager.initFromCameraParameters(this.mCamera);
            this.getHolder().addCallback((SurfaceHolder.Callback)this);
            if (this.mPreviewing) {
                this.requestLayout();
            } else {
                this.showCameraPreview();
            }
        }
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = true;
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i2, int i3) {
        if (surfaceHolder.getSurface() == null) {
            return;
        }
        this.stopCameraPreview();
        this.post(new Runnable(){

            @Override
            public void run() {
                CameraPreview.this.showCameraPreview();
            }
        });
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        this.mSurfaceCreated = false;
        this.stopCameraPreview();
    }

    public void showCameraPreview() {
        if (this.mCamera != null) {
            try {
                this.mPreviewing = true;
                this.mCamera.setPreviewDisplay(this.getHolder());
                this.mCameraConfigurationManager.setDesiredCameraParameters(this.mCamera);
                this.mCamera.startPreview();
                if (this.mAutoFocus) {
                    this.mCamera.autoFocus(this.autoFocusCB);
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString(), (Throwable)e);
            }
        }
    }

    public void stopCameraPreview() {
        if (this.mCamera != null) {
            try {
                this.removeCallbacks(this.doAutoFocus);
                this.mPreviewing = false;
                this.mCamera.cancelAutoFocus();
                this.mCamera.setOneShotPreviewCallback(null);
                this.mCamera.stopPreview();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.toString(), (Throwable)e);
            }
        }
    }

    public void openFlashlight() {
        if (this.flashLightAvailable()) {
            this.mCameraConfigurationManager.openFlashlight(this.mCamera);
        }
    }

    public void closeFlashlight() {
        if (this.flashLightAvailable()) {
            this.mCameraConfigurationManager.closeFlashlight(this.mCamera);
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = CameraPreview.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int height = CameraPreview.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        if (this.mCameraConfigurationManager != null && this.mCameraConfigurationManager.getCameraResolution() != null) {
            Point cameraResolution = this.mCameraConfigurationManager.getCameraResolution();
            int cameraPreviewWidth = cameraResolution.y;
            int cameraPreviewHeight = cameraResolution.x;
            if ((float)width * 1.0f / (float)height < (float)cameraPreviewWidth * 1.0f / (float)cameraPreviewHeight) {
                float ratio = (float)cameraPreviewHeight * 1.0f / (float)cameraPreviewWidth;
                width = (int)((float)height / ratio + 0.5f);
            } else {
                float ratio = (float)cameraPreviewWidth * 1.0f / (float)cameraPreviewHeight;
                height = (int)((float)width / ratio + 0.5f);
            }
        }
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    private boolean flashLightAvailable() {
        return this.mCamera != null && this.mPreviewing && this.mSurfaceCreated && this.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }
}

