/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.refreshlayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.util.AttributeSet;
import android.view.View;
import cn.bingoogolapple.refreshlayout.R;

public class BGAMoocStyleRefreshView
extends View {
    private PorterDuffXfermode mXfermode;
    private Paint mPaint;
    private Canvas mCanvas;
    private Bitmap mOriginalBitmap;
    private int mOriginalBitmapWidth;
    private int mOriginalBitmapHeight;
    private Bitmap mUltimateBitmap;
    private Path mBezierPath;
    private float mBezierControlX;
    private float mBezierControlY;
    private float mBezierControlOriginalY;
    private float mWaveY;
    private float mWaveOriginalY;
    private boolean mIsBezierControlXIncrease;
    private boolean mIsRefreshing = false;
    private int mUltimateColor;

    public BGAMoocStyleRefreshView(Context context) {
        this(context, null);
    }

    public BGAMoocStyleRefreshView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BGAMoocStyleRefreshView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttrs(context, attrs);
        this.initPaint();
        this.initCanvas();
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BGAMoocStyleRefreshView);
        BitmapDrawable originalBitmap = (BitmapDrawable)typedArray.getDrawable(R.styleable.BGAMoocStyleRefreshView_mv_originalImg);
        if (originalBitmap == null) {
            throw new RuntimeException(BGAMoocStyleRefreshView.class.getSimpleName() + "\u5fc5\u987b\u8bbe\u7f6e\u539f\u59cb\u56fe\u7247");
        }
        this.mOriginalBitmap = originalBitmap.getBitmap();
        this.mUltimateColor = typedArray.getColor(R.styleable.BGAMoocStyleRefreshView_mv_ultimateColor, Color.rgb((int)27, (int)128, (int)255));
        typedArray.recycle();
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mUltimateColor);
    }

    public void setUltimateColor(int ultimateColor) {
        this.mUltimateColor = ultimateColor;
        if (this.mPaint == null) {
            this.initPaint();
        }
        this.mPaint.setColor(this.mUltimateColor);
    }

    private void initCanvas() {
        this.mOriginalBitmapWidth = this.mOriginalBitmap.getWidth();
        this.mOriginalBitmapHeight = this.mOriginalBitmap.getHeight();
        this.mWaveOriginalY = this.mOriginalBitmapHeight;
        this.mWaveY = 1.2f * this.mWaveOriginalY;
        this.mBezierControlY = this.mBezierControlOriginalY = 1.25f * this.mWaveOriginalY;
        this.mXfermode = new PorterDuffXfermode(PorterDuff.Mode.SRC_IN);
        this.mBezierPath = new Path();
        this.mCanvas = new Canvas();
        this.mUltimateBitmap = Bitmap.createBitmap((int)this.mOriginalBitmapWidth, (int)this.mOriginalBitmapHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mCanvas.setBitmap(this.mUltimateBitmap);
    }

    public void setOriginalBitmap(Bitmap originalBitmap) {
        this.mOriginalBitmap = originalBitmap;
        this.initCanvas();
    }

    protected void onDraw(Canvas canvas) {
        this.drawUltimateBitmap();
        canvas.drawBitmap(this.mUltimateBitmap, (float)this.getPaddingLeft(), (float)this.getPaddingTop(), null);
        if (this.mIsRefreshing) {
            this.invalidate();
        }
    }

    private void drawUltimateBitmap() {
        this.mBezierPath.reset();
        this.mUltimateBitmap.eraseColor(Color.parseColor((String)"#00ffffff"));
        if (this.mBezierControlX >= (float)(this.mOriginalBitmapWidth + 0 * this.mOriginalBitmapWidth)) {
            this.mIsBezierControlXIncrease = false;
        } else if (this.mBezierControlX <= (float)(0 * this.mOriginalBitmapWidth)) {
            this.mIsBezierControlXIncrease = true;
        }
        float f = this.mBezierControlX = this.mIsBezierControlXIncrease ? this.mBezierControlX + 10.0f : this.mBezierControlX - 10.0f;
        if (this.mBezierControlY >= 0.0f) {
            this.mBezierControlY -= 2.0f;
            this.mWaveY -= 2.0f;
        } else {
            this.mWaveY = this.mWaveOriginalY;
            this.mBezierControlY = this.mBezierControlOriginalY;
        }
        this.mBezierPath.moveTo(0.0f, this.mWaveY);
        this.mBezierPath.cubicTo(this.mBezierControlX / 2.0f, this.mWaveY - (this.mBezierControlY - this.mWaveY), (this.mBezierControlX + (float)this.mOriginalBitmapWidth) / 2.0f, this.mBezierControlY, (float)this.mOriginalBitmapWidth, this.mWaveY);
        this.mBezierPath.lineTo((float)this.mOriginalBitmapWidth, (float)this.mOriginalBitmapHeight);
        this.mBezierPath.lineTo(0.0f, (float)this.mOriginalBitmapHeight);
        this.mBezierPath.close();
        this.mCanvas.drawBitmap(this.mOriginalBitmap, 0.0f, 0.0f, this.mPaint);
        this.mPaint.setXfermode((Xfermode)this.mXfermode);
        this.mCanvas.drawPath(this.mBezierPath, this.mPaint);
        this.mPaint.setXfermode(null);
    }

    public void startRefreshing() {
        this.mIsRefreshing = true;
        this.reset();
    }

    public void stopRefreshing() {
        this.mIsRefreshing = false;
        this.reset();
    }

    private void reset() {
        this.mWaveY = this.mWaveOriginalY;
        this.mBezierControlY = this.mBezierControlOriginalY;
        this.mBezierControlX = 0.0f;
        this.postInvalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthMode == 0x40000000) {
            width = widthSize + this.getPaddingLeft() + this.getPaddingRight();
        } else {
            width = this.mOriginalBitmapWidth + this.getPaddingLeft() + this.getPaddingRight();
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(width, widthSize);
            }
        }
        if (heightMode == 0x40000000) {
            height = heightSize + this.getPaddingTop() + this.getPaddingBottom();
        } else {
            height = this.mOriginalBitmapHeight + this.getPaddingTop() + this.getPaddingBottom();
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(height, heightSize);
            }
        }
        this.setMeasuredDimension(width, height);
    }
}

