/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.refreshlayout;

import android.content.Context;
import android.graphics.Bitmap;
import android.support.v4.view.ViewCompat;
import android.view.View;
import cn.bingoogolapple.refreshlayout.BGAMoocStyleRefreshView;
import cn.bingoogolapple.refreshlayout.BGARefreshViewHolder;
import cn.bingoogolapple.refreshlayout.R;

public class BGAMoocStyleRefreshViewHolder
extends BGARefreshViewHolder {
    private BGAMoocStyleRefreshView mMoocRefreshView;
    private Bitmap mOriginalBitmap;
    private int mUltimateColor = -1;

    public BGAMoocStyleRefreshViewHolder(Context context, boolean isLoadingMoreEnabled) {
        super(context, isLoadingMoreEnabled);
    }

    @Override
    public View getRefreshHeaderView() {
        if (this.mRefreshHeaderView == null) {
            this.mRefreshHeaderView = View.inflate((Context)this.mContext, (int)R.layout.view_refresh_header_mooc_style, null);
            if (this.mRefreshViewBackgroundColorRes != -1) {
                this.mRefreshHeaderView.setBackgroundResource(this.mRefreshViewBackgroundColorRes);
            }
            if (this.mRefreshViewBackgroundDrawableRes != -1) {
                this.mRefreshHeaderView.setBackgroundResource(this.mRefreshViewBackgroundDrawableRes);
            }
            this.mMoocRefreshView = (BGAMoocStyleRefreshView)this.mRefreshHeaderView.findViewById(R.id.moocView);
            if (this.mOriginalBitmap != null) {
                this.mMoocRefreshView.setOriginalBitmap(this.mOriginalBitmap);
            }
            if (this.mUltimateColor != -1) {
                this.mMoocRefreshView.setUltimateColor(this.mUltimateColor);
            }
        }
        return this.mRefreshHeaderView;
    }

    public void setOriginalBitmap(Bitmap originalBitmap) {
        this.mOriginalBitmap = originalBitmap;
    }

    public void setUltimateColor(int ultimateColor) {
        this.mUltimateColor = ultimateColor;
    }

    @Override
    public void handleScale(float scale, int moveYDistance) {
        scale = 0.6f + 0.4f * scale;
        ViewCompat.setScaleX((View)this.mMoocRefreshView, (float)scale);
        ViewCompat.setScaleY((View)this.mMoocRefreshView, (float)scale);
    }

    @Override
    public void changeToIdle() {
    }

    @Override
    public void changeToPullDown() {
    }

    @Override
    public void changeToReleaseRefresh() {
    }

    @Override
    public void changeToRefreshing() {
        this.mMoocRefreshView.startRefreshing();
    }

    @Override
    public void onEndRefreshing() {
        this.mMoocRefreshView.stopRefreshing();
    }
}

