/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.refreshlayout;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.TextView;
import cn.bingoogolapple.refreshlayout.BGARefreshViewHolder;
import cn.bingoogolapple.refreshlayout.R;

public class BGANormalRefreshViewHolder
extends BGARefreshViewHolder {
    private TextView mHeaderStatusTv;
    private ImageView mHeaderArrowIv;
    private ImageView mHeaderChrysanthemumIv;
    private AnimationDrawable mHeaderChrysanthemumAd;
    private RotateAnimation mUpAnim;
    private RotateAnimation mDownAnim;
    private String mPullDownRefreshText = "\u4e0b\u62c9\u5237\u65b0";
    private String mReleaseRefreshText = "\u91ca\u653e\u66f4\u65b0";
    private String mRefreshingText = "\u52a0\u8f7d\u4e2d...";

    public BGANormalRefreshViewHolder(Context context, boolean isLoadingMoreEnabled) {
        super(context, isLoadingMoreEnabled);
        this.initAnimation();
    }

    private void initAnimation() {
        this.mUpAnim = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mUpAnim.setDuration(150L);
        this.mUpAnim.setFillAfter(true);
        this.mDownAnim = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mDownAnim.setFillAfter(true);
    }

    public void setPullDownRefreshText(String pullDownRefreshText) {
        this.mPullDownRefreshText = pullDownRefreshText;
    }

    public void setReleaseRefreshText(String releaseRefreshText) {
        this.mReleaseRefreshText = releaseRefreshText;
    }

    public void setRefreshingText(String refreshingText) {
        this.mRefreshingText = refreshingText;
    }

    @Override
    public View getRefreshHeaderView() {
        if (this.mRefreshHeaderView == null) {
            this.mRefreshHeaderView = View.inflate((Context)this.mContext, (int)R.layout.view_refresh_header_normal, null);
            if (this.mRefreshViewBackgroundColorRes != -1) {
                this.mRefreshHeaderView.setBackgroundResource(this.mRefreshViewBackgroundColorRes);
            }
            if (this.mRefreshViewBackgroundDrawableRes != -1) {
                this.mRefreshHeaderView.setBackgroundResource(this.mRefreshViewBackgroundDrawableRes);
            }
            this.mHeaderStatusTv = (TextView)this.mRefreshHeaderView.findViewById(R.id.tv_normal_refresh_header_status);
            this.mHeaderArrowIv = (ImageView)this.mRefreshHeaderView.findViewById(R.id.iv_normal_refresh_header_arrow);
            this.mHeaderChrysanthemumIv = (ImageView)this.mRefreshHeaderView.findViewById(R.id.iv_normal_refresh_header_chrysanthemum);
            this.mHeaderChrysanthemumAd = (AnimationDrawable)this.mHeaderChrysanthemumIv.getDrawable();
            this.mHeaderStatusTv.setText((CharSequence)this.mPullDownRefreshText);
        }
        return this.mRefreshHeaderView;
    }

    @Override
    public void handleScale(float scale, int moveYDistance) {
    }

    @Override
    public void changeToIdle() {
    }

    @Override
    public void changeToPullDown() {
        this.mHeaderStatusTv.setText((CharSequence)this.mPullDownRefreshText);
        this.mHeaderChrysanthemumIv.setVisibility(4);
        this.mHeaderChrysanthemumAd.stop();
        this.mHeaderArrowIv.setVisibility(0);
        this.mDownAnim.setDuration(150L);
        this.mHeaderArrowIv.startAnimation((Animation)this.mDownAnim);
    }

    @Override
    public void changeToReleaseRefresh() {
        this.mHeaderStatusTv.setText((CharSequence)this.mReleaseRefreshText);
        this.mHeaderChrysanthemumIv.setVisibility(4);
        this.mHeaderChrysanthemumAd.stop();
        this.mHeaderArrowIv.setVisibility(0);
        this.mHeaderArrowIv.startAnimation((Animation)this.mUpAnim);
    }

    @Override
    public void changeToRefreshing() {
        this.mHeaderStatusTv.setText((CharSequence)this.mRefreshingText);
        this.mHeaderArrowIv.clearAnimation();
        this.mHeaderArrowIv.setVisibility(4);
        this.mHeaderChrysanthemumIv.setVisibility(0);
        this.mHeaderChrysanthemumAd.start();
    }

    @Override
    public void onEndRefreshing() {
        this.mHeaderStatusTv.setText((CharSequence)this.mPullDownRefreshText);
        this.mHeaderChrysanthemumIv.setVisibility(4);
        this.mHeaderChrysanthemumAd.stop();
        this.mHeaderArrowIv.setVisibility(0);
        this.mDownAnim.setDuration(0L);
        this.mHeaderArrowIv.startAnimation((Animation)this.mDownAnim);
    }
}

