/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.refreshlayout;

import android.content.Context;
import android.os.Handler;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ScrollView;
import cn.bingoogolapple.refreshlayout.BGARefreshViewHolder;
import com.nineoldandroids.animation.ValueAnimator;
import java.lang.reflect.Field;

public class BGARefreshLayout
extends LinearLayout {
    private static final String TAG = BGARefreshLayout.class.getSimpleName();
    private BGARefreshViewHolder mRefreshViewHolder;
    private LinearLayout mWholeHeaderView;
    private View mRefreshHeaderView;
    private View mCustomHeaderView;
    private boolean mIsCustomHeaderViewScrollable = false;
    private int mRefreshHeaderViewHeight;
    private RefreshStatus mCurrentRefreshStatus = RefreshStatus.IDLE;
    private View mLoadMoreFooterView;
    private int mLoadMoreFooterViewHeight;
    private BGARefreshLayoutDelegate mDelegate;
    private int mWholeHeaderDownY = -1;
    private int mMinWholeHeaderViewPaddingTop;
    private int mMaxWholeHeaderViewPaddingTop;
    private boolean mIsLoadingMore = false;
    private AbsListView mAbsListView;
    private ScrollView mScrollView;
    private RecyclerView mRecyclerView;
    private View mNormalView;
    private View mContentView;
    private float mInterceptTouchDownX = -1.0f;
    private float mInterceptTouchDownY = -1.0f;
    private int mWholeHeaderViewDownPaddingTop = 0;
    private int mRefreshDownY = -1;
    private boolean mIsInitedContentViewScrollListener = false;

    public BGARefreshLayout(Context context) {
        this(context, null);
    }

    public BGARefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(1);
        this.initWholeHeaderView();
    }

    private void initWholeHeaderView() {
        this.mWholeHeaderView = new LinearLayout(this.getContext());
        this.mWholeHeaderView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mWholeHeaderView.setOrientation(1);
        this.addView((View)this.mWholeHeaderView);
    }

    public void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() != 2) {
            throw new RuntimeException(BGARefreshLayout.class.getSimpleName() + "\u5fc5\u987b\u6709\u4e14\u53ea\u6709\u4e00\u4e2a\u5b50\u63a7\u4ef6");
        }
        this.mContentView = this.getChildAt(1);
        if (this.mContentView instanceof AbsListView) {
            this.mAbsListView = (AbsListView)this.mContentView;
        } else if (this.mContentView instanceof RecyclerView) {
            this.mRecyclerView = (RecyclerView)this.mContentView;
        } else if (this.mContentView instanceof ScrollView) {
            this.mScrollView = (ScrollView)this.mContentView;
        } else {
            this.mNormalView = this.mContentView;
            this.mNormalView.setClickable(true);
        }
    }

    public void setRefreshViewHolder(BGARefreshViewHolder refreshViewHolder) {
        this.mRefreshViewHolder = refreshViewHolder;
        this.mRefreshViewHolder.setRefreshLayout(this);
        this.initRefreshHeaderView();
        this.initLoadMoreFooterView();
    }

    public void startChangeWholeHeaderViewPaddingTop(int distance) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.mWholeHeaderView.getPaddingTop(), this.mWholeHeaderView.getPaddingTop() - distance});
        animator.setDuration((long)this.mRefreshViewHolder.getTopAnimDuration());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int paddingTop = (Integer)animation.getAnimatedValue();
                BGARefreshLayout.this.mWholeHeaderView.setPadding(0, paddingTop, 0, 0);
            }
        });
        animator.start();
    }

    private void initRefreshHeaderView() {
        this.mRefreshHeaderView = this.mRefreshViewHolder.getRefreshHeaderView();
        if (this.mRefreshHeaderView != null) {
            this.mRefreshHeaderView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.mRefreshHeaderViewHeight = this.mRefreshViewHolder.getRefreshHeaderViewHeight();
            this.mMinWholeHeaderViewPaddingTop = -this.mRefreshHeaderViewHeight;
            this.mMaxWholeHeaderViewPaddingTop = (int)((float)this.mRefreshHeaderViewHeight * this.mRefreshViewHolder.getSpringDistanceScale());
            this.mWholeHeaderView.setPadding(0, this.mMinWholeHeaderViewPaddingTop, 0, 0);
            this.mWholeHeaderView.addView(this.mRefreshHeaderView, 0);
        }
    }

    public void setCustomHeaderView(View customHeaderView, boolean scrollable) {
        if (this.mCustomHeaderView != null && this.mCustomHeaderView.getParent() != null) {
            ViewGroup parent = (ViewGroup)this.mCustomHeaderView.getParent();
            parent.removeView(this.mCustomHeaderView);
        }
        this.mCustomHeaderView = customHeaderView;
        if (this.mCustomHeaderView != null) {
            this.mCustomHeaderView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
            this.mWholeHeaderView.addView(this.mCustomHeaderView);
            this.mIsCustomHeaderViewScrollable = scrollable;
        }
    }

    private void initLoadMoreFooterView() {
        this.mLoadMoreFooterView = this.mRefreshViewHolder.getLoadMoreFooterView();
        if (this.mLoadMoreFooterView != null) {
            this.mLoadMoreFooterView.measure(0, 0);
            this.mLoadMoreFooterViewHeight = this.mLoadMoreFooterView.getMeasuredHeight();
            this.mLoadMoreFooterView.setPadding(0, 0, 0, -this.mLoadMoreFooterViewHeight);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mIsInitedContentViewScrollListener && this.mLoadMoreFooterView != null) {
            this.setRecyclerViewOnScrollListener();
            this.setAbsListViewOnScrollListener();
            this.addView(this.mLoadMoreFooterView, this.getChildCount());
            this.mIsInitedContentViewScrollListener = true;
        }
    }

    private void setRecyclerViewOnScrollListener() {
        if (this.mRecyclerView != null) {
            this.mRecyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                    if ((newState == 0 || newState == 2) && BGARefreshLayout.this.shouldHandleRecyclerViewLoadingMore()) {
                        BGARefreshLayout.this.beginLoadingMore();
                    }
                }
            });
        }
    }

    private void setAbsListViewOnScrollListener() {
        if (this.mAbsListView != null) {
            try {
                Field field = AbsListView.class.getDeclaredField("mOnScrollListener");
                field.setAccessible(true);
                final AbsListView.OnScrollListener onScrollListener = (AbsListView.OnScrollListener)field.get(this.mAbsListView);
                this.mAbsListView.setOnScrollListener(new AbsListView.OnScrollListener(){

                    public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                        if ((scrollState == 0 || scrollState == 2) && BGARefreshLayout.this.shouldHandleAbsListViewLoadingMore()) {
                            BGARefreshLayout.this.beginLoadingMore();
                        }
                        if (onScrollListener != null) {
                            onScrollListener.onScrollStateChanged(absListView, scrollState);
                        }
                    }

                    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                        if (onScrollListener != null) {
                            onScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
                        }
                    }
                });
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean shouldHandleAbsListViewLoadingMore() {
        if (this.mIsLoadingMore || this.mLoadMoreFooterView == null || this.mDelegate == null || this.mAbsListView.getAdapter() == null || ((ListAdapter)this.mAbsListView.getAdapter()).getCount() == 0) {
            return false;
        }
        int lastChildBottom = 0;
        if (this.mAbsListView.getChildCount() > 0) {
            lastChildBottom = this.mAbsListView.getChildAt(this.mAbsListView.getChildCount() - 1).getBottom();
        }
        return this.mAbsListView.getLastVisiblePosition() == ((ListAdapter)this.mAbsListView.getAdapter()).getCount() - 1 && lastChildBottom <= this.mAbsListView.getHeight();
    }

    private boolean shouldHandleRecyclerViewLoadingMore() {
        if (this.mIsLoadingMore || this.mLoadMoreFooterView == null || this.mDelegate == null || this.mRecyclerView.getAdapter() == null || this.mRecyclerView.getAdapter().getItemCount() == 0) {
            return false;
        }
        RecyclerView.LayoutManager manager = this.mRecyclerView.getLayoutManager();
        if (manager == null || manager.getItemCount() == 0) {
            return false;
        }
        if (manager instanceof LinearLayoutManager) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)manager;
            if (layoutManager.findLastCompletelyVisibleItemPosition() == this.mRecyclerView.getAdapter().getItemCount() - 1) {
                return true;
            }
        } else if (manager instanceof StaggeredGridLayoutManager) {
            StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)manager;
        }
        return false;
    }

    private boolean shouldHandleLoadingMore() {
        int scrollViewMeasuredHeight;
        int height;
        int scrollY;
        if (this.mIsLoadingMore || this.mLoadMoreFooterView == null || this.mDelegate == null) {
            return false;
        }
        if (this.mNormalView != null) {
            return true;
        }
        if (this.mScrollView != null && (scrollY = this.mScrollView.getScrollY()) + (height = this.mScrollView.getHeight()) == (scrollViewMeasuredHeight = this.mScrollView.getChildAt(0).getMeasuredHeight())) {
            return true;
        }
        if (this.mAbsListView != null) {
            return this.shouldHandleAbsListViewLoadingMore();
        }
        if (this.mRecyclerView != null) {
            return this.shouldHandleRecyclerViewLoadingMore();
        }
        return false;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.mInterceptTouchDownX = event.getRawX();
                this.mInterceptTouchDownY = event.getRawY();
                break;
            }
            case 2: {
                if (this.mIsLoadingMore || this.mCurrentRefreshStatus == RefreshStatus.REFRESHING) {
                    event.setAction(3);
                    super.onInterceptTouchEvent(event);
                    return true;
                }
                if (this.mInterceptTouchDownX == -1.0f) {
                    this.mInterceptTouchDownX = (int)event.getRawX();
                }
                if (this.mInterceptTouchDownY == -1.0f) {
                    this.mInterceptTouchDownY = (int)event.getRawY();
                }
                int interceptTouchMoveDistanceY = (int)(event.getRawY() - this.mInterceptTouchDownY);
                if (!(Math.abs(event.getRawX() - this.mInterceptTouchDownX) < (float)Math.abs(interceptTouchMoveDistanceY)) || this.mRefreshHeaderView == null || !(interceptTouchMoveDistanceY > 0 && this.shouldHandleRefresh() || interceptTouchMoveDistanceY < 0 && this.shouldHandleLoadingMore()) && (interceptTouchMoveDistanceY >= 0 || this.isWholeHeaderViewCompleteInvisible())) break;
                event.setAction(3);
                super.onInterceptTouchEvent(event);
                return true;
            }
            case 1: 
            case 3: {
                this.mInterceptTouchDownX = -1.0f;
                this.mInterceptTouchDownY = -1.0f;
            }
        }
        return super.onInterceptTouchEvent(event);
    }

    private boolean shouldHandleRefresh() {
        int firstChildTop;
        if (this.mRefreshHeaderView == null) {
            return false;
        }
        if (this.mNormalView != null) {
            return true;
        }
        if (this.mScrollView != null && this.mScrollView.getScrollY() == 0) {
            return true;
        }
        if (this.mAbsListView != null) {
            firstChildTop = 0;
            if (this.mAbsListView.getChildCount() > 0) {
                firstChildTop = this.mAbsListView.getChildAt(0).getTop();
            }
            if (this.mAbsListView.getFirstVisiblePosition() == 0 && firstChildTop == 0) {
                return true;
            }
        }
        if (this.mRecyclerView != null) {
            RecyclerView.LayoutManager manager;
            firstChildTop = 0;
            if (this.mRecyclerView.getChildCount() > 0) {
                firstChildTop = this.mRecyclerView.getChildAt(0).getTop();
            }
            if ((manager = this.mRecyclerView.getLayoutManager()) == null) {
                return true;
            }
            if (manager.getItemCount() == 0) {
                return true;
            }
            if (manager instanceof LinearLayoutManager) {
                LinearLayoutManager layoutManager = (LinearLayoutManager)manager;
                if (layoutManager.findFirstCompletelyVisibleItemPosition() == 0 && firstChildTop == 0) {
                    return true;
                }
            } else if (manager instanceof StaggeredGridLayoutManager) {
                StaggeredGridLayoutManager staggeredGridLayoutManager = (StaggeredGridLayoutManager)manager;
            }
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (null != this.mRefreshHeaderView) {
            switch (event.getAction()) {
                case 0: {
                    this.mWholeHeaderDownY = (int)event.getY();
                    if (this.mCustomHeaderView != null) {
                        this.mWholeHeaderViewDownPaddingTop = this.mWholeHeaderView.getPaddingTop();
                    }
                    if (this.mCustomHeaderView == null || !this.mIsCustomHeaderViewScrollable) {
                        this.mRefreshDownY = (int)event.getY();
                    }
                    if (!this.isWholeHeaderViewCompleteInvisible()) break;
                    this.mRefreshDownY = (int)event.getY();
                    break;
                }
                case 2: {
                    if (!this.handleActionMove(event)) break;
                    return true;
                }
                case 1: 
                case 3: {
                    if (!this.handleActionUpOrCancel(event)) break;
                    return true;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    private boolean isCustomHeaderViewCompleteVisible() {
        if (this.mCustomHeaderView != null) {
            int[] location = new int[2];
            this.getLocationOnScreen(location);
            int mOnScreenY = location[1];
            this.mCustomHeaderView.getLocationOnScreen(location);
            int customHeaderViewOnScreenY = location[1];
            return mOnScreenY <= customHeaderViewOnScreenY;
        }
        return true;
    }

    private boolean isWholeHeaderViewCompleteInvisible() {
        if (this.mCustomHeaderView != null && this.mIsCustomHeaderViewScrollable) {
            int[] location = new int[2];
            this.getLocationOnScreen(location);
            int mOnScreenY = location[1];
            this.mWholeHeaderView.getLocationOnScreen(location);
            int wholeHeaderViewOnScreenY = location[1];
            return wholeHeaderViewOnScreenY + this.mWholeHeaderView.getMeasuredHeight() <= mOnScreenY;
        }
        return true;
    }

    private boolean handleActionMove(MotionEvent event) {
        if (this.mCurrentRefreshStatus == RefreshStatus.REFRESHING || this.mIsLoadingMore) {
            return true;
        }
        if (!(this.mCustomHeaderView != null && this.mIsCustomHeaderViewScrollable || this.mRefreshDownY != -1)) {
            this.mRefreshDownY = (int)event.getY();
        }
        if (this.mCustomHeaderView != null && this.mIsCustomHeaderViewScrollable && this.isCustomHeaderViewCompleteVisible() && this.mRefreshDownY == -1) {
            this.mRefreshDownY = (int)event.getY();
        }
        int refreshDiffY = (int)event.getY() - this.mRefreshDownY;
        if ((refreshDiffY = (int)((float)refreshDiffY / this.mRefreshViewHolder.getPaddingTopScale())) > 0 && this.shouldHandleRefresh() && this.isCustomHeaderViewCompleteVisible()) {
            int paddingTop = this.mMinWholeHeaderViewPaddingTop + refreshDiffY;
            if (paddingTop > 0 && this.mCurrentRefreshStatus != RefreshStatus.RELEASE_REFRESH) {
                this.mCurrentRefreshStatus = RefreshStatus.RELEASE_REFRESH;
                this.handleRefreshStatusChanged();
                this.mRefreshViewHolder.handleScale(1.0f, refreshDiffY);
            } else if (paddingTop < 0) {
                if (this.mCurrentRefreshStatus != RefreshStatus.PULL_DOWN) {
                    boolean isPreRefreshStatusNotIdle = this.mCurrentRefreshStatus != RefreshStatus.IDLE;
                    this.mCurrentRefreshStatus = RefreshStatus.PULL_DOWN;
                    if (isPreRefreshStatusNotIdle) {
                        this.handleRefreshStatusChanged();
                    }
                }
                float scale = 1.0f - (float)paddingTop * 1.0f / (float)this.mMinWholeHeaderViewPaddingTop;
                this.mRefreshViewHolder.handleScale(scale, refreshDiffY);
            }
            paddingTop = Math.min(paddingTop, this.mMaxWholeHeaderViewPaddingTop);
            this.mWholeHeaderView.setPadding(0, paddingTop, 0, 0);
            if (this.mRefreshViewHolder.canChangeToRefreshingStatus()) {
                this.mWholeHeaderDownY = -1;
                this.mRefreshDownY = -1;
                this.changeToRefreshing();
            }
            return true;
        }
        if (this.mCustomHeaderView != null && this.mIsCustomHeaderViewScrollable) {
            if (this.mWholeHeaderDownY == -1) {
                this.mWholeHeaderDownY = (int)event.getY();
                if (this.mCustomHeaderView != null) {
                    this.mWholeHeaderViewDownPaddingTop = this.mWholeHeaderView.getPaddingTop();
                }
            }
            int wholeHeaderDiffY = (int)event.getY() - this.mWholeHeaderDownY;
            if (!this.isWholeHeaderViewCompleteInvisible() || wholeHeaderDiffY > 0 && this.shouldHandleRefresh() && !this.isCustomHeaderViewCompleteVisible()) {
                int paddingTop = this.mWholeHeaderViewDownPaddingTop + wholeHeaderDiffY;
                if (paddingTop < this.mMinWholeHeaderViewPaddingTop - this.mCustomHeaderView.getMeasuredHeight()) {
                    paddingTop = this.mMinWholeHeaderViewPaddingTop - this.mCustomHeaderView.getMeasuredHeight();
                }
                this.mWholeHeaderView.setPadding(0, paddingTop, 0, 0);
                return true;
            }
        }
        return false;
    }

    private boolean handleActionUpOrCancel(MotionEvent event) {
        boolean isReturnTrue = false;
        if ((this.mCustomHeaderView == null || this.mCustomHeaderView != null && !this.mIsCustomHeaderViewScrollable) && this.mWholeHeaderView.getPaddingTop() != this.mMinWholeHeaderViewPaddingTop) {
            isReturnTrue = true;
        }
        if (this.mCurrentRefreshStatus == RefreshStatus.PULL_DOWN || this.mCurrentRefreshStatus == RefreshStatus.IDLE) {
            if (this.mCustomHeaderView == null || this.mCustomHeaderView != null && this.mWholeHeaderView.getPaddingTop() < 0 && this.mWholeHeaderView.getPaddingTop() > this.mMinWholeHeaderViewPaddingTop) {
                this.hiddenRefreshHeaderView();
            }
            this.mCurrentRefreshStatus = RefreshStatus.IDLE;
            this.handleRefreshStatusChanged();
        } else if (this.mCurrentRefreshStatus == RefreshStatus.RELEASE_REFRESH) {
            this.changeToRefreshing();
        }
        if (this.mRefreshDownY == -1) {
            this.mRefreshDownY = (int)event.getY();
        }
        int diffY = (int)event.getY() - this.mRefreshDownY;
        if (this.shouldHandleLoadingMore() && (diffY < 0 || this.mScrollView != null && diffY == 0) && !this.mIsLoadingMore) {
            isReturnTrue = true;
            this.beginLoadingMore();
        }
        this.mWholeHeaderDownY = -1;
        this.mRefreshDownY = -1;
        return isReturnTrue;
    }

    private void changeToRefreshing() {
        this.changeRefreshHeaderViewToZero();
        this.mCurrentRefreshStatus = RefreshStatus.REFRESHING;
        this.handleRefreshStatusChanged();
        if (this.mDelegate != null) {
            this.mDelegate.onBGARefreshLayoutBeginRefreshing();
        }
    }

    private void handleRefreshStatusChanged() {
        switch (this.mCurrentRefreshStatus) {
            case IDLE: {
                this.mRefreshViewHolder.changeToIdle();
                break;
            }
            case PULL_DOWN: {
                this.mRefreshViewHolder.changeToPullDown();
                break;
            }
            case RELEASE_REFRESH: {
                this.mRefreshViewHolder.changeToReleaseRefresh();
                break;
            }
            case REFRESHING: {
                this.mRefreshViewHolder.changeToRefreshing();
                break;
            }
        }
    }

    public void endRefreshing() {
        if (this.mIsLoadingMore) {
            this.mIsLoadingMore = false;
            this.hiddenLoadMoreFooterView();
            this.mRefreshViewHolder.onEndLoadingMore();
        } else {
            this.mCurrentRefreshStatus = RefreshStatus.IDLE;
            this.hiddenRefreshHeaderView();
            this.handleRefreshStatusChanged();
            this.mRefreshViewHolder.onEndRefreshing();
        }
    }

    private void hiddenRefreshHeaderView() {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.mWholeHeaderView.getPaddingTop(), this.mMinWholeHeaderViewPaddingTop});
        animator.setDuration((long)this.mRefreshViewHolder.getTopAnimDuration());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int paddingTop = (Integer)animation.getAnimatedValue();
                BGARefreshLayout.this.mWholeHeaderView.setPadding(0, paddingTop, 0, 0);
            }
        });
        animator.start();
    }

    private void changeRefreshHeaderViewToZero() {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.mWholeHeaderView.getPaddingTop(), 0});
        animator.setDuration((long)this.mRefreshViewHolder.getTopAnimDuration());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int paddingTop = (Integer)animation.getAnimatedValue();
                BGARefreshLayout.this.mWholeHeaderView.setPadding(0, paddingTop, 0, 0);
            }
        });
        animator.start();
    }

    private void hiddenLoadMoreFooterView() {
        this.startHiddenLoadingMoreViewAnim();
    }

    private void beginLoadingMore() {
        if (!this.mIsLoadingMore && this.mLoadMoreFooterView != null && this.mDelegate != null) {
            this.mIsLoadingMore = true;
            this.startShowLoadingMoreViewAnim();
            this.mRefreshViewHolder.changeToLoadingMore();
            this.mDelegate.onBGARefreshLayoutBeginLoadingMore();
        }
    }

    private void startHiddenLoadingMoreViewAnim() {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{0, -this.mLoadMoreFooterViewHeight});
        animator.setDuration((long)this.mRefreshViewHolder.getBottomAnimDuration());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int paddingBottom = (Integer)animation.getAnimatedValue();
                BGARefreshLayout.this.mLoadMoreFooterView.setPadding(0, 0, 0, paddingBottom);
            }
        });
        animator.start();
    }

    private void startShowLoadingMoreViewAnim() {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{-this.mLoadMoreFooterViewHeight, 0});
        animator.setDuration((long)this.mRefreshViewHolder.getBottomAnimDuration());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int paddingBottom = (Integer)animation.getAnimatedValue();
                BGARefreshLayout.this.mLoadMoreFooterView.setPadding(0, 0, 0, paddingBottom);
                if (BGARefreshLayout.this.mScrollView != null) {
                    new Handler().post(new Runnable(){

                        @Override
                        public void run() {
                            BGARefreshLayout.this.mScrollView.fullScroll(130);
                        }
                    });
                }
                if (BGARefreshLayout.this.mRecyclerView != null) {
                    RecyclerView.LayoutManager layoutManager = BGARefreshLayout.this.mRecyclerView.getLayoutManager();
                    if (BGARefreshLayout.this.mRecyclerView.getAdapter() != null && BGARefreshLayout.this.mRecyclerView.getAdapter().getItemCount() > 0) {
                        layoutManager.scrollToPosition(BGARefreshLayout.this.mRecyclerView.getAdapter().getItemCount() - 1);
                    }
                }
                if (BGARefreshLayout.this.mAbsListView != null && BGARefreshLayout.this.mAbsListView.getAdapter() != null && ((ListAdapter)BGARefreshLayout.this.mAbsListView.getAdapter()).getCount() > 0) {
                    BGARefreshLayout.this.mAbsListView.smoothScrollToPosition(((ListAdapter)BGARefreshLayout.this.mAbsListView.getAdapter()).getCount() - 1);
                }
            }
        });
        animator.start();
    }

    public void setDelegate(BGARefreshLayoutDelegate delegate) {
        this.mDelegate = delegate;
    }

    public static enum RefreshStatus {
        IDLE,
        PULL_DOWN,
        RELEASE_REFRESH,
        REFRESHING;

    }

    public static interface BGARefreshLayoutDelegate {
        public void onBGARefreshLayoutBeginRefreshing();

        public void onBGARefreshLayoutBeginLoadingMore();
    }
}

