/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.refreshlayout;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import cn.bingoogolapple.refreshlayout.BGARefreshLayout;
import cn.bingoogolapple.refreshlayout.R;

public abstract class BGARefreshViewHolder {
    private static final float PULL_DISTANCE_SCALE = 1.8f;
    private float mPullDistanceScale = 1.8f;
    private static final float SPRING_DISTANCE_SCALE = 0.4f;
    private float mSpringDistanceScale = 0.4f;
    protected Context mContext;
    protected BGARefreshLayout mRefreshLayout;
    protected View mRefreshHeaderView;
    protected View mLoadMoreFooterView;
    protected TextView mFooterStatusTv;
    protected ImageView mFooterChrysanthemumIv;
    protected AnimationDrawable mFooterChrysanthemumAd;
    protected String mLodingMoreText = "\u52a0\u8f7d\u4e2d...";
    private boolean mIsLoadingMoreEnabled = true;
    private int mLoadMoreBackgroundColorRes = -1;
    private int mLoadMoreBackgroundDrawableRes = -1;
    protected int mRefreshViewBackgroundColorRes = -1;
    protected int mRefreshViewBackgroundDrawableRes = -1;
    private int mTopAnimDuration = 500;
    private int mBottomAnimDuration = 300;

    public BGARefreshViewHolder(Context context, boolean isLoadingMoreEnabled) {
        this.mContext = context;
        this.mIsLoadingMoreEnabled = isLoadingMoreEnabled;
    }

    public void setLoadingMoreText(String loadingMoreText) {
        this.mLodingMoreText = loadingMoreText;
    }

    public void setLoadMoreBackgroundColorRes(int loadMoreBackgroundColorRes) {
        this.mLoadMoreBackgroundColorRes = loadMoreBackgroundColorRes;
    }

    public void setLoadMoreBackgroundDrawableRes(int loadMoreBackgroundDrawableRes) {
        this.mLoadMoreBackgroundDrawableRes = loadMoreBackgroundDrawableRes;
    }

    public void setRefreshViewBackgroundColorRes(int refreshViewBackgroundColorRes) {
        this.mRefreshViewBackgroundColorRes = refreshViewBackgroundColorRes;
    }

    public void setRefreshViewBackgroundDrawableRes(int refreshViewBackgroundDrawableRes) {
        this.mRefreshViewBackgroundDrawableRes = refreshViewBackgroundDrawableRes;
    }

    public int getTopAnimDuration() {
        return this.mTopAnimDuration;
    }

    public void setTopAnimDuration(int topAnimDuration) {
        this.mTopAnimDuration = topAnimDuration;
    }

    public int getBottomAnimDuration() {
        return this.mBottomAnimDuration;
    }

    public void setBottomAnimDuration(int bottomAnimDuration) {
        this.mBottomAnimDuration = bottomAnimDuration;
    }

    public View getLoadMoreFooterView() {
        if (!this.mIsLoadingMoreEnabled) {
            return null;
        }
        if (this.mLoadMoreFooterView == null) {
            this.mLoadMoreFooterView = View.inflate((Context)this.mContext, (int)R.layout.view_normal_refresh_footer, null);
            if (this.mLoadMoreBackgroundColorRes != -1) {
                this.mLoadMoreFooterView.setBackgroundResource(this.mLoadMoreBackgroundColorRes);
            }
            if (this.mLoadMoreBackgroundDrawableRes != -1) {
                this.mLoadMoreFooterView.setBackgroundResource(this.mLoadMoreBackgroundDrawableRes);
            }
            this.mFooterStatusTv = (TextView)this.mLoadMoreFooterView.findViewById(R.id.tv_normal_refresh_footer_status);
            this.mFooterChrysanthemumIv = (ImageView)this.mLoadMoreFooterView.findViewById(R.id.iv_normal_refresh_footer_chrysanthemum);
            this.mFooterChrysanthemumAd = (AnimationDrawable)this.mFooterChrysanthemumIv.getDrawable();
            this.mFooterStatusTv.setText((CharSequence)this.mLodingMoreText);
        }
        return this.mLoadMoreFooterView;
    }

    public abstract View getRefreshHeaderView();

    public abstract void handleScale(float var1, int var2);

    public abstract void changeToIdle();

    public abstract void changeToPullDown();

    public abstract void changeToReleaseRefresh();

    public abstract void changeToRefreshing();

    public abstract void onEndRefreshing();

    public float getPaddingTopScale() {
        return this.mPullDistanceScale;
    }

    public void setPullDistanceScale(float pullDistanceScale) {
        this.mPullDistanceScale = pullDistanceScale;
    }

    public float getSpringDistanceScale() {
        return this.mSpringDistanceScale;
    }

    public void setSpringDistanceScale(float springDistanceScale) {
        if (springDistanceScale < 0.0f) {
            throw new RuntimeException("\u4e0b\u62c9\u5237\u65b0\u63a7\u4ef6paddingTop\u7684\u5f39\u7c27\u8ddd\u79bb\u4e0e\u4e0b\u62c9\u5237\u65b0\u63a7\u4ef6\u9ad8\u5ea6\u7684\u6bd4\u503cspringDistanceScale\u4e0d\u80fd\u5c0f\u4e8e0");
        }
        this.mSpringDistanceScale = springDistanceScale;
    }

    public boolean canChangeToRefreshingStatus() {
        return false;
    }

    public void changeToLoadingMore() {
        if (this.mIsLoadingMoreEnabled && this.mFooterChrysanthemumAd != null) {
            this.mFooterChrysanthemumAd.start();
        }
    }

    public void onEndLoadingMore() {
        if (this.mIsLoadingMoreEnabled && this.mFooterChrysanthemumAd != null) {
            this.mFooterChrysanthemumAd.stop();
        }
    }

    public int getRefreshHeaderViewHeight() {
        if (this.mRefreshHeaderView != null) {
            this.mRefreshHeaderView.measure(0, 0);
            return this.mRefreshHeaderView.getMeasuredHeight();
        }
        return 0;
    }

    public void startChangeWholeHeaderViewPaddingTop(int distance) {
        this.mRefreshLayout.startChangeWholeHeaderViewPaddingTop(distance);
    }

    public void setRefreshLayout(BGARefreshLayout refreshLayout) {
        this.mRefreshLayout = refreshLayout;
    }
}

