/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.refreshlayout;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import cn.bingoogolapple.refreshlayout.BGAStickinessRefreshViewHolder;
import cn.bingoogolapple.refreshlayout.R;
import cn.bingoogolapple.refreshlayout.UIUtil;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ValueAnimator;

public class BGAStickinessRefreshView
extends View {
    private static final String TAG = BGAStickinessRefreshView.class.getSimpleName();
    private BGAStickinessRefreshViewHolder mStickinessRefreshViewHolder;
    private RectF mTopBound;
    private RectF mBottomBound;
    private Rect mRotateDrawableBound;
    private Point mCenterPoint;
    private Paint mPaint;
    private Path mPath;
    private Drawable mRotateDrawable;
    private int mRotateDrawableSize;
    private int mMaxBottomHeight;
    private int mCurrentBottomHeight = 0;
    private boolean mIsRotating = false;
    private boolean mIsRefreshing = false;
    private int mCurrentDegree = 0;
    private int mEdge = 0;
    private int mTopSize = 0;
    private int mStickinessColor = -6710887;

    public BGAStickinessRefreshView(Context context) {
        this(context, null);
    }

    public BGAStickinessRefreshView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BGAStickinessRefreshView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initBounds();
        this.initPaint();
        this.initRotateDrawable();
        this.initSize();
    }

    private void initBounds() {
        this.mTopBound = new RectF();
        this.mBottomBound = new RectF();
        this.mRotateDrawableBound = new Rect();
        this.mCenterPoint = new Point();
    }

    private void initPaint() {
        this.mPaint = new Paint(1);
        this.mPaint.setColor(this.mStickinessColor);
        this.mPath = new Path();
    }

    public void setStickinessColor(int stickinessColor) {
        this.mStickinessColor = stickinessColor;
        if (this.mPaint == null) {
            this.initPaint();
        } else {
            this.mPaint.setColor(this.mStickinessColor);
        }
    }

    private void initRotateDrawable() {
        this.mRotateDrawable = this.getContext().getResources().getDrawable(R.mipmap.bga_refresh_stickiness);
    }

    public void setRotateDrawable(Drawable rotateDrawable) {
        this.mRotateDrawable = rotateDrawable;
    }

    private void initSize() {
        this.mEdge = UIUtil.dp2px(this.getContext(), 5);
        this.mRotateDrawableSize = UIUtil.dp2px(this.getContext(), 30);
        this.mTopSize = this.mRotateDrawableSize + 2 * this.mEdge;
        this.mMaxBottomHeight = (int)(2.5f * (float)this.mRotateDrawableSize);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.mTopSize + this.getPaddingLeft() + this.getPaddingRight();
        int height = this.mTopSize + this.getPaddingTop() + this.getPaddingBottom() + this.mMaxBottomHeight;
        this.setMeasuredDimension(width, height);
        this.measureDraw();
    }

    private void measureDraw() {
        this.mCenterPoint.x = this.getMeasuredWidth() / 2;
        this.mCenterPoint.y = this.getMeasuredHeight() / 2;
        this.mTopBound.left = this.mCenterPoint.x - this.mTopSize / 2;
        this.mTopBound.right = this.mTopBound.left + (float)this.mTopSize;
        this.mTopBound.bottom = this.getMeasuredHeight() - this.getPaddingBottom() - this.mCurrentBottomHeight;
        this.mTopBound.top = this.mTopBound.bottom - (float)this.mTopSize;
        float scale = 1.0f - (float)this.mCurrentBottomHeight * 1.0f / (float)this.mMaxBottomHeight;
        scale = Math.min(Math.max(scale, 0.2f), 1.0f);
        int mBottomSize = (int)((float)this.mTopSize * scale);
        this.mBottomBound.left = this.mCenterPoint.x - mBottomSize / 2;
        this.mBottomBound.right = this.mBottomBound.left + (float)mBottomSize;
        this.mBottomBound.bottom = this.mTopBound.bottom + (float)this.mCurrentBottomHeight;
        this.mBottomBound.top = this.mBottomBound.bottom - (float)mBottomSize;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPath.reset();
        this.mTopBound.round(this.mRotateDrawableBound);
        this.mRotateDrawable.setBounds(this.mRotateDrawableBound);
        if (this.mIsRotating) {
            this.mPath.addOval(this.mTopBound, Path.Direction.CW);
            canvas.drawPath(this.mPath, this.mPaint);
            canvas.save();
            canvas.rotate((float)this.mCurrentDegree, (float)this.mRotateDrawable.getBounds().centerX(), (float)this.mRotateDrawable.getBounds().centerY());
            this.mRotateDrawable.draw(canvas);
            canvas.restore();
        } else {
            this.mPath.moveTo(this.mTopBound.left, this.mTopBound.top + (float)(this.mTopSize / 2));
            this.mPath.arcTo(this.mTopBound, 180.0f, 180.0f);
            float scale = Math.max((float)this.mCurrentBottomHeight * 1.0f / (float)this.mMaxBottomHeight, 0.2f);
            float bottomControlXOffset = (float)this.mTopSize * ((4.0f + (float)Math.pow(scale, 7.0) * 15.0f) / 32.0f);
            float bottomControlY = this.mTopBound.bottom / 2.0f + (float)(this.mCenterPoint.y / 2);
            this.mPath.cubicTo(this.mTopBound.right - (float)(this.mTopSize / 8), this.mTopBound.bottom, this.mTopBound.right - bottomControlXOffset, bottomControlY, this.mBottomBound.right, this.mBottomBound.bottom - this.mBottomBound.height() / 2.0f);
            this.mPath.arcTo(this.mBottomBound, 0.0f, 180.0f);
            this.mPath.cubicTo(this.mTopBound.left + bottomControlXOffset, bottomControlY, this.mTopBound.left + (float)(this.mTopSize / 8), this.mTopBound.bottom, this.mTopBound.left, this.mTopBound.bottom - (float)(this.mTopSize / 2));
            canvas.drawPath(this.mPath, this.mPaint);
            this.mRotateDrawable.draw(canvas);
        }
    }

    public void setMoveYDistance(int moveYDistance) {
        int bottomHeight = moveYDistance - this.mTopSize - this.getPaddingBottom() - this.getPaddingTop();
        this.mCurrentBottomHeight = bottomHeight > 0 ? bottomHeight : 0;
        this.postInvalidate();
    }

    public boolean canChangeToRefreshing() {
        return (float)this.mCurrentBottomHeight >= (float)this.mMaxBottomHeight * 0.98f;
    }

    public void startRefreshing() {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.mCurrentBottomHeight, 0});
        animator.setDuration((long)this.mStickinessRefreshViewHolder.getTopAnimDuration());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BGAStickinessRefreshView.this.mCurrentBottomHeight = (Integer)animation.getAnimatedValue();
                BGAStickinessRefreshView.this.postInvalidate();
            }
        });
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                BGAStickinessRefreshView.this.mIsRefreshing = true;
                BGAStickinessRefreshView.this.mStickinessRefreshViewHolder.startChangeWholeHeaderViewPaddingTop(BGAStickinessRefreshView.this.mCurrentBottomHeight);
            }

            public void onAnimationEnd(Animator animation) {
                BGAStickinessRefreshView.this.mIsRotating = true;
                BGAStickinessRefreshView.this.startRotating();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animator.start();
    }

    private void startRotating() {
        ViewCompat.postOnAnimation((View)this, (Runnable)new Runnable(){

            @Override
            public void run() {
                BGAStickinessRefreshView.this.mCurrentDegree += 10;
                if (BGAStickinessRefreshView.this.mCurrentDegree > 360) {
                    BGAStickinessRefreshView.this.mCurrentDegree = 0;
                }
                if (BGAStickinessRefreshView.this.mIsRefreshing) {
                    BGAStickinessRefreshView.this.startRotating();
                }
                BGAStickinessRefreshView.this.postInvalidate();
            }
        });
    }

    public void stopRefresh() {
        this.mIsRotating = true;
        this.mIsRefreshing = false;
        this.postInvalidate();
    }

    public void smoothToIdle() {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.mCurrentBottomHeight, 0});
        animator.setDuration((long)this.mStickinessRefreshViewHolder.getTopAnimDuration());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BGAStickinessRefreshView.this.mCurrentBottomHeight = (Integer)animation.getAnimatedValue();
                BGAStickinessRefreshView.this.postInvalidate();
            }
        });
        animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                BGAStickinessRefreshView.this.mIsRotating = false;
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        animator.start();
    }

    public void setStickinessRefreshViewHolder(BGAStickinessRefreshViewHolder stickinessRefreshViewHolder) {
        this.mStickinessRefreshViewHolder = stickinessRefreshViewHolder;
    }
}

