/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.qrcode.zxing;

import android.content.Context;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.AttributeSet;
import cn.bingoogolapple.qrcode.core.QRCodeView;
import cn.bingoogolapple.qrcode.zxing.QRCodeDecoder;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;

public class ZXingView
extends QRCodeView {
    private MultiFormatReader mMultiFormatReader;

    public ZXingView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ZXingView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initMultiFormatReader();
    }

    private void initMultiFormatReader() {
        this.mMultiFormatReader = new MultiFormatReader();
        this.mMultiFormatReader.setHints(QRCodeDecoder.HINTS);
    }

    protected void handleData(final byte[] data, final int width, final int height, final Camera camera) {
        new AsyncTask<Void, Void, String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected String doInBackground(Void ... params) {
                String result = null;
                Result rawResult = null;
                try {
                    PlanarYUVLuminanceSource source = new PlanarYUVLuminanceSource(data, width, height, 0, 0, width, height, false);
                    rawResult = ZXingView.this.mMultiFormatReader.decodeWithState(new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source)));
                }
                catch (Exception exception) {
                }
                finally {
                    ZXingView.this.mMultiFormatReader.reset();
                }
                if (rawResult != null) {
                    result = rawResult.getText();
                }
                return result;
            }

            protected void onPostExecute(String result) {
                if (ZXingView.this.mDelegate != null && !TextUtils.isEmpty((CharSequence)result)) {
                    ZXingView.this.mDelegate.onScanQRCodeSuccess(result);
                } else {
                    try {
                        camera.setOneShotPreviewCallback((Camera.PreviewCallback)ZXingView.this);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            }
        }.execute((Object[])new Void[0]);
    }
}

