/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.qrcode.zxing;

import android.graphics.Bitmap;
import android.os.AsyncTask;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import java.util.EnumMap;
import java.util.Map;

public class QRCodeEncoder {
    public static final Map<EncodeHintType, Object> HINTS = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);

    private QRCodeEncoder() {
    }

    public static void encodeQRCode(String content, int size, Delegate delegate) {
        QRCodeEncoder.encodeQRCode(content, size, -16777216, delegate);
    }

    public static void encodeQRCode(final String content, final int size, final int color, final Delegate delegate) {
        new AsyncTask<Void, Void, Bitmap>(){

            protected Bitmap doInBackground(Void ... params) {
                try {
                    BitMatrix matrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, size, size, HINTS);
                    int[] pixels = new int[size * size];
                    for (int y = 0; y < size; ++y) {
                        for (int x = 0; x < size; ++x) {
                            if (!matrix.get(x, y)) continue;
                            pixels[y * size + x] = color;
                        }
                    }
                    Bitmap bitmap = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    bitmap.setPixels(pixels, 0, size, 0, 0, size, size);
                    return bitmap;
                }
                catch (Exception e) {
                    return null;
                }
            }

            protected void onPostExecute(Bitmap bitmap) {
                if (delegate != null) {
                    if (bitmap != null) {
                        delegate.onEncodeQRCodeSuccess(bitmap);
                    } else {
                        delegate.onEncodeQRCodeFailure();
                    }
                }
            }
        }.execute((Object[])new Void[0]);
    }

    static {
        HINTS.put(EncodeHintType.CHARACTER_SET, "utf-8");
    }

    public static interface Delegate {
        public void onEncodeQRCodeSuccess(Bitmap var1);

        public void onEncodeQRCodeFailure();
    }
}

