/*
 * Decompiled with CFR 0.152.
 */
package cn.bingoogolapple.qrcode.zxing;

import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.text.TextUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;

public class QRCodeDecoder {
    public static final Map<DecodeHintType, Object> HINTS = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);

    private QRCodeDecoder() {
    }

    public static void decodeQRCode(final Bitmap bitmap, final Delegate delegate) {
        new AsyncTask<Void, Void, String>(){

            protected String doInBackground(Void ... params) {
                try {
                    int width = bitmap.getWidth();
                    int height = bitmap.getHeight();
                    int[] pixels = new int[width * height];
                    bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
                    RGBLuminanceSource source = new RGBLuminanceSource(width, height, pixels);
                    Result result = new MultiFormatReader().decode(new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source)), HINTS);
                    return result.getText();
                }
                catch (Exception e) {
                    return null;
                }
            }

            protected void onPostExecute(String result) {
                if (delegate != null) {
                    if (TextUtils.isEmpty((CharSequence)result)) {
                        delegate.onDecodeQRCodeFailure();
                    } else {
                        delegate.onDecodeQRCodeSuccess(result);
                    }
                }
            }
        }.execute((Object[])new Void[0]);
    }

    static {
        ArrayList<BarcodeFormat> allFormats = new ArrayList<BarcodeFormat>();
        allFormats.add(BarcodeFormat.AZTEC);
        allFormats.add(BarcodeFormat.CODABAR);
        allFormats.add(BarcodeFormat.CODE_39);
        allFormats.add(BarcodeFormat.CODE_93);
        allFormats.add(BarcodeFormat.CODE_128);
        allFormats.add(BarcodeFormat.DATA_MATRIX);
        allFormats.add(BarcodeFormat.EAN_8);
        allFormats.add(BarcodeFormat.EAN_13);
        allFormats.add(BarcodeFormat.ITF);
        allFormats.add(BarcodeFormat.MAXICODE);
        allFormats.add(BarcodeFormat.PDF_417);
        allFormats.add(BarcodeFormat.QR_CODE);
        allFormats.add(BarcodeFormat.RSS_14);
        allFormats.add(BarcodeFormat.RSS_EXPANDED);
        allFormats.add(BarcodeFormat.UPC_A);
        allFormats.add(BarcodeFormat.UPC_E);
        allFormats.add(BarcodeFormat.UPC_EAN_EXTENSION);
        HINTS.put(DecodeHintType.POSSIBLE_FORMATS, allFormats);
        HINTS.put(DecodeHintType.CHARACTER_SET, "utf-8");
    }

    public static interface Delegate {
        public void onDecodeQRCodeSuccess(String var1);

        public void onDecodeQRCodeFailure();
    }
}

