/*
 * Decompiled with CFR 0.152.
 */
package cn.dreamtobe.kpswitch.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import cn.dreamtobe.kpswitch.util.KeyboardUtil;
import cn.dreamtobe.kpswitch.util.StatusBarHeightUtil;

public class ViewUtil {
    private static final String TAG = "ViewUtil";

    public static boolean refreshHeight(View view, int aimHeight) {
        if (view.isInEditMode()) {
            return false;
        }
        Log.d((String)TAG, (String)String.format("refresh Height %d %d", view.getHeight(), aimHeight));
        if (view.getHeight() == aimHeight) {
            return false;
        }
        if (Math.abs(view.getHeight() - aimHeight) == StatusBarHeightUtil.getStatusBarHeight(view.getContext())) {
            return false;
        }
        int validPanelHeight = KeyboardUtil.getValidPanelHeight(view.getContext());
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new ViewGroup.LayoutParams(-1, validPanelHeight);
            view.setLayoutParams(layoutParams);
        } else {
            layoutParams.height = validPanelHeight;
            view.requestLayout();
        }
        return true;
    }

    public static boolean isFullScreen(Activity activity) {
        return (activity.getWindow().getAttributes().flags & 0x400) != 0;
    }

    @TargetApi(value=19)
    public static boolean isTranslucentStatus(Activity activity) {
        if (Build.VERSION.SDK_INT >= 19) {
            return (activity.getWindow().getAttributes().flags & 0x4000000) != 0;
        }
        return false;
    }

    @TargetApi(value=16)
    static boolean isFitsSystemWindows(Activity activity) {
        if (Build.VERSION.SDK_INT >= 16) {
            return ((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0).getFitsSystemWindows();
        }
        return false;
    }
}

