/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.captcha;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.core.util.ImageUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.concurrent.ThreadLocalRandom;

public class LineCaptcha
extends AbstractCaptcha {
    private static final long serialVersionUID = 8691294460763091089L;

    public LineCaptcha(int width, int height) {
        this(width, height, 5, 150);
    }

    public LineCaptcha(int width, int height, int codeCount, int lineCount) {
        super(width, height, codeCount, lineCount);
    }

    @Override
    public Image createImage(String code) {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        ThreadLocalRandom random = RandomUtil.getRandom();
        Graphics2D g = ImageUtil.createGraphics(image, ObjectUtil.defaultIfNull(this.background, Color.WHITE));
        this.drawInterfere(g, random);
        g.setFont(this.font);
        FontMetrics metrics = g.getFontMetrics();
        int minY = metrics.getAscent() - metrics.getLeading() - metrics.getDescent();
        int len = this.generator.getLength();
        int charWidth = this.width / len;
        for (int i = 0; i < len; ++i) {
            g.setColor(ImageUtil.randomColor(random));
            g.drawString(String.valueOf(code.charAt(i)), i * charWidth, RandomUtil.randomInt(minY, this.height));
        }
        return image;
    }

    private void drawInterfere(Graphics2D g, ThreadLocalRandom random) {
        for (int i = 0; i < this.interfereCount; ++i) {
            int xs = random.nextInt(this.width);
            int ys = random.nextInt(this.height);
            int xe = xs + random.nextInt(this.width / 8);
            int ye = ys + random.nextInt(this.height / 8);
            g.setColor(ImageUtil.randomColor(random));
            g.drawLine(xs, ys, xe, ye);
        }
    }
}

