/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.ds.tomcat;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.db.DbRuntimeException;
import cn.hutool.db.dialect.DriverUtil;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.setting.Setting;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;

public class TomcatDSFactory
extends DSFactory {
    public static final String DS_NAME = "Tomcat-Jdbc-Pool";
    private Map<String, DataSource> dsMap = new ConcurrentHashMap<String, DataSource>();

    public TomcatDSFactory() {
        this(null);
    }

    public TomcatDSFactory(Setting setting) {
        super(DS_NAME, DataSource.class, setting);
    }

    public synchronized DataSource getDataSource(String group) {
        DataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        DataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        DataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            ds.close();
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<DataSource> values = this.dsMap.values();
            for (DataSource ds : values) {
                if (null == ds) continue;
                ds.close();
            }
            this.dsMap.clear();
        }
    }

    private DataSource createDataSource(String group) {
        Setting config;
        if (group == null) {
            group = "";
        }
        if (CollUtil.isEmpty(config = this.setting.getSetting(group))) {
            throw new DbRuntimeException("No Tomcat jdbc pool config for group: [{}]", group);
        }
        PoolProperties poolProps = new PoolProperties();
        String url = config.getAndRemoveStr(KEY_ALIAS_URL);
        if (StrUtil.isBlank(url)) {
            throw new DbRuntimeException("No JDBC URL for group: [{}]", group);
        }
        poolProps.setUrl(url);
        String driver = this.getAndRemoveProperty(config, "driver", "driverClassName");
        poolProps.setDriverClassName(StrUtil.isNotBlank(driver) ? driver : DriverUtil.identifyDriver(url));
        poolProps.setUsername(config.getAndRemoveStr(KEY_ALIAS_USER));
        poolProps.setPassword(config.getAndRemoveStr(KEY_ALIAS_PASSWORD));
        config.toBean(poolProps);
        DataSource ds = new DataSource((PoolConfiguration)poolProps);
        return ds;
    }

    private String getAndRemoveProperty(Setting setting, String key1, String key2) {
        String value = setting.remove(key1);
        if (StrUtil.isBlank(value)) {
            value = setting.remove(key2);
        }
        return value;
    }
}

