/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.analytics.page;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import cn.jiguang.analytics.page.PushSA;
import cn.jiguang.api.JCoreManager;
import cn.jiguang.bh.f;
import cn.jiguang.cb.b;
import cn.jiguang.cb.d;
import cn.jiguang.d.a;
import cn.jiguang.f.e;
import cn.jiguang.internal.JConstants;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

@TargetApi(value=14)
public final class ActivityLifecycle
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "ActivityLifecycle";
    public static int activityTaskCount = 0;
    public static long lastWakeTime = 0L;
    public static final long WAKE_VIOLATION_DURATION = 50L;
    public static final long WAKE_VIOLATION_COUNT = 5L;
    private List<Application.ActivityLifecycleCallbacks> mActivityCallbacks = new ArrayList<Application.ActivityLifecycleCallbacks>();
    private boolean isFromSync = false;
    private boolean aidlBuildSuccess = false;
    private static final String SAVE_KEY = "save_key";
    private WeakReference<Activity> mWeakReference;

    public void onActivityCreated(Activity activity, Bundle bundle) {
        try {
            if (JConstants.jAnalyticsAction != null) {
                JConstants.jAnalyticsAction.dispatchStatus((Context)activity, "onCreate");
            }
            if (this.aidlBuildSuccess) {
                for (Application.ActivityLifecycleCallbacks activityLifecycleCallbacks : this.mActivityCallbacks) {
                    activityLifecycleCallbacks.onActivityCreated(activity, bundle);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onActivityStarted(Activity activity) {
        try {
            if (JConstants.jAnalyticsAction != null) {
                JConstants.jAnalyticsAction.dispatchStatus((Context)activity, "onStart");
            }
            if (this.aidlBuildSuccess) {
                for (Application.ActivityLifecycleCallbacks activityLifecycleCallbacks : this.mActivityCallbacks) {
                    activityLifecycleCallbacks.onActivityStarted(activity);
                }
            }
            this.cacheBeforeInit(activity);
            if (activityTaskCount == 0 && JConstants.isCallInit.get()) {
                cn.jiguang.bf.d.c(TAG, "isForeground");
                if (activity != null) {
                    int n2 = 1;
                    JCoreManager.onEvent(activity.getApplicationContext(), "JCore", 66, null, null, n2);
                }
            }
            if (!this.isFromSync) {
                ++activityTaskCount;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void reportWakeViolation(final Context context) {
        d.a("FUTURE_TASK", new b(){

            @Override
            public void a() {
                try {
                    JSONObject jSONObject = new JSONObject();
                    a.a(context, jSONObject, "wake_violation");
                    f.a(context, (Object)jSONObject);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    public void onActivityResumed(Activity activity) {
        try {
            if (JConstants.jAnalyticsAction != null) {
                JConstants.jAnalyticsAction.dispatchResume((Context)activity);
            }
            if (this.aidlBuildSuccess) {
                for (Application.ActivityLifecycleCallbacks activityLifecycleCallbacks : this.mActivityCallbacks) {
                    activityLifecycleCallbacks.onActivityResumed(activity);
                }
            }
            if (!JConstants.isInstrumentationHookFailed && JConstants.isCallInit.get()) {
                PushSA.getInstance().onResume((Context)activity);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onActivityPaused(Activity activity) {
        try {
            if (JConstants.jAnalyticsAction != null) {
                JConstants.jAnalyticsAction.dispatchPause((Context)activity);
            }
            if (this.aidlBuildSuccess) {
                for (Application.ActivityLifecycleCallbacks activityLifecycleCallbacks : this.mActivityCallbacks) {
                    activityLifecycleCallbacks.onActivityPaused(activity);
                }
            }
            if (!JConstants.isInstrumentationHookFailed && JConstants.isCallInit.get()) {
                PushSA.getInstance().onPause((Context)activity);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onActivityStopped(Activity activity) {
        try {
            if (this.aidlBuildSuccess) {
                for (Application.ActivityLifecycleCallbacks activityLifecycleCallbacks : this.mActivityCallbacks) {
                    activityLifecycleCallbacks.onActivityStopped(activity);
                }
            }
            if (activityTaskCount > 0) {
                --activityTaskCount;
            }
            cn.jiguang.bf.d.c(TAG, "onActivityStopped activityTaskCount:" + activityTaskCount);
            if (activityTaskCount == 0 && JConstants.isCallInit.get()) {
                Application.ActivityLifecycleCallbacks activityLifecycleCallbacks;
                cn.jiguang.bf.d.c(TAG, "is not Foreground");
                int n2 = 0;
                activityLifecycleCallbacks = activity.getApplicationContext();
                JCoreManager.onEvent((Context)activityLifecycleCallbacks, "JCore", 66, null, null, n2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        try {
            if (this.aidlBuildSuccess) {
                for (Application.ActivityLifecycleCallbacks activityLifecycleCallbacks : this.mActivityCallbacks) {
                    activityLifecycleCallbacks.onActivitySaveInstanceState(activity, bundle);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onActivityDestroyed(Activity activity) {
        try {
            if (this.aidlBuildSuccess) {
                for (Application.ActivityLifecycleCallbacks activityLifecycleCallbacks : this.mActivityCallbacks) {
                    activityLifecycleCallbacks.onActivityDestroyed(activity);
                }
            }
            if (activityTaskCount == 0 && activity != null && JConstants.isCallInit.get()) {
                JCoreManager.onEvent(activity.getApplicationContext(), "JCore", 110, null, null, new Object[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean isTranslucentNotitleTheme(Activity activity) {
        try {
            Resources.Theme theme = activity.getTheme();
            TypedArray typedArray = theme.obtainStyledAttributes(new int[]{16842838, 16842841, 16842836, 16842840, 16843435});
            boolean bl = typedArray.getBoolean(0, false);
            Drawable drawable2 = typedArray.getDrawable(1);
            int n2 = typedArray.getColor(2, -1);
            boolean bl2 = typedArray.getBoolean(3, false);
            Drawable drawable3 = typedArray.getDrawable(4);
            cn.jiguang.bf.d.c(TAG, "notitle:" + bl + ", overlay:" + drawable2 + ", color:" + n2 + ", translucent:" + bl2 + "background:" + drawable3);
            typedArray.recycle();
            if (bl && bl2 && drawable2 == null && drawable3 == null && n2 == activity.getResources().getColor(17170445)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            cn.jiguang.bf.d.i(TAG, "check TranslucentNotitleTheme failed :" + throwable);
        }
        return false;
    }

    private boolean isWakeActivity(Activity activity) {
        boolean bl = false;
        try {
            if (activity != null && activity.getIntent() != null && !TextUtils.isEmpty((CharSequence)activity.getIntent().getAction()) && "cn.jpush.android.intent.DActivity".equals(activity.getIntent().getAction())) {
                bl = true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public void sendCurrentState() {
        try {
            Activity activity;
            this.aidlBuildSuccess = true;
            JCoreManager.onEvent((Context)e.a(), "JCore", 66, null, null, activityTaskCount == 0 ? 0 : 1);
            if (activityTaskCount <= 0) {
                return;
            }
            if (this.mWeakReference != null && (activity = (Activity)this.mWeakReference.get()) != null && !activity.isFinishing()) {
                this.isFromSync = true;
                this.onActivityCreated(activity, null);
                this.onActivityStarted(activity);
                this.onActivityResumed(activity);
                this.isFromSync = false;
            }
            this.clearLocal();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void cacheBeforeInit(Activity activity) {
        try {
            if (!this.aidlBuildSuccess) {
                this.clearLocal();
                this.mWeakReference = new WeakReference<Activity>(activity);
            } else {
                this.clearLocal();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void clearLocal() {
        if (this.mWeakReference != null) {
            this.mWeakReference.clear();
            this.mWeakReference = null;
        }
    }

    public void addActivityLifecycleCallbacks(Application.ActivityLifecycleCallbacks activityLifecycleCallbacks) {
        try {
            if (activityLifecycleCallbacks != null) {
                if (this.mActivityCallbacks == null) {
                    this.mActivityCallbacks = new ArrayList<Application.ActivityLifecycleCallbacks>();
                }
                this.mActivityCallbacks.add(activityLifecycleCallbacks);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void removeActivityLifecycleCallbacks(Application.ActivityLifecycleCallbacks activityLifecycleCallbacks) {
        try {
            if (activityLifecycleCallbacks != null) {
                this.mActivityCallbacks.remove(activityLifecycleCallbacks);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

