/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.api.utils;

import cn.jiguang.ca.d;
import java.math.BigInteger;

public class OutputDataUtil {
    private static final String TAG = "OutputDataUtil";
    private byte[] array;
    private int pos;
    private int saved_pos;
    private static final BigInteger TWO_64 = BigInteger.ONE.shiftLeft(64);

    public OutputDataUtil(int n2) {
        this.array = new byte[n2];
        this.pos = 0;
        this.saved_pos = -1;
    }

    public OutputDataUtil() {
        this(32);
    }

    public int current() {
        return this.pos;
    }

    private void check(long l2, int n2) {
        long l3 = 1L;
        if (l2 < 0L || l2 > (l3 <<= n2)) {
            d.c(TAG, l2 + " out of range for " + n2 + " bit value max:" + l3);
        }
    }

    private void need(int n2) {
        if (this.array.length - this.pos >= n2) {
            return;
        }
        int n3 = this.array.length * 2;
        if (n3 < this.pos + n2) {
            n3 = this.pos + n2;
        }
        byte[] byArray = new byte[n3];
        System.arraycopy(this.array, 0, byArray, 0, this.pos);
        this.array = byArray;
    }

    public void jump(int n2) {
        if (n2 > this.pos) {
            throw new IllegalArgumentException("cannot jump past end of data");
        }
        this.pos = n2;
    }

    public void save() {
        this.saved_pos = this.pos;
    }

    public void restore() {
        if (this.saved_pos < 0) {
            throw new IllegalStateException("no previous state");
        }
        this.pos = this.saved_pos;
        this.saved_pos = -1;
    }

    public void writeU8(int n2) {
        this.check(n2, 8);
        this.need(1);
        this.array[this.pos++] = (byte)(n2 & 0xFF);
    }

    public void writeU8At(int n2, int n3) {
        this.check(n2, 8);
        if (n3 > this.pos - 1) {
            throw new IllegalArgumentException("cannot write past end of data");
        }
        this.array[n3] = (byte)(n2 & 0xFF);
    }

    public void writeU16(int n2) {
        this.check(n2, 16);
        this.need(2);
        this.array[this.pos++] = (byte)(n2 >>> 8 & 0xFF);
        this.array[this.pos++] = (byte)(n2 & 0xFF);
    }

    public void writeU16At(int n2, int n3) {
        this.check(n2, 16);
        if (n3 > this.pos - 2) {
            throw new IllegalArgumentException("cannot write past end of data");
        }
        this.array[n3++] = (byte)(n2 >>> 8 & 0xFF);
        this.array[n3++] = (byte)(n2 & 0xFF);
    }

    public void writeU32(long l2) {
        this.check(l2, 32);
        this.need(4);
        this.array[this.pos++] = (byte)(l2 >>> 24 & 0xFFL);
        this.array[this.pos++] = (byte)(l2 >>> 16 & 0xFFL);
        this.array[this.pos++] = (byte)(l2 >>> 8 & 0xFFL);
        this.array[this.pos++] = (byte)(l2 & 0xFFL);
    }

    public void writeU32At(long l2, int n2) {
        this.check(l2, 32);
        if (n2 > this.pos - 4) {
            throw new IllegalArgumentException("cannot write past end of data");
        }
        this.array[n2++] = (byte)(l2 >>> 24 & 0xFFL);
        this.array[n2++] = (byte)(l2 >>> 16 & 0xFFL);
        this.array[n2++] = (byte)(l2 >>> 8 & 0xFFL);
        this.array[n2++] = (byte)(l2 & 0xFFL);
    }

    public static int encodeZigZag32(int n2) {
        return n2 << 1 ^ n2 >> 31;
    }

    public static long encodeZigZag64(long l2) {
        return l2 << 1 ^ l2 >> 63;
    }

    public void writeU64(long l2) {
        long l3 = l2;
        this.need(8);
        this.array[this.pos++] = (byte)(l3 >>> 56 & 0xFFL);
        this.array[this.pos++] = (byte)(l3 >>> 48 & 0xFFL);
        this.array[this.pos++] = (byte)(l3 >>> 40 & 0xFFL);
        this.array[this.pos++] = (byte)(l3 >>> 32 & 0xFFL);
        this.array[this.pos++] = (byte)(l3 >>> 24 & 0xFFL);
        this.array[this.pos++] = (byte)(l3 >>> 16 & 0xFFL);
        this.array[this.pos++] = (byte)(l3 >>> 8 & 0xFFL);
        this.array[this.pos++] = (byte)(l3 & 0xFFL);
    }

    public void writeU64At(long l2, int n2) {
        this.array[n2++] = (byte)(l2 >>> 56 & 0xFFL);
        this.array[n2++] = (byte)(l2 >>> 48 & 0xFFL);
        this.array[n2++] = (byte)(l2 >>> 40 & 0xFFL);
        this.array[n2++] = (byte)(l2 >>> 32 & 0xFFL);
        this.array[n2++] = (byte)(l2 >>> 24 & 0xFFL);
        this.array[n2++] = (byte)(l2 >>> 16 & 0xFFL);
        this.array[n2++] = (byte)(l2 >>> 8 & 0xFFL);
        this.array[n2++] = (byte)(l2 & 0xFFL);
    }

    public void writeRawLittleEndian16(int n2) {
        this.array[this.pos++] = (byte)(n2 & 0xFF);
        this.array[this.pos++] = (byte)(n2 >> 8 & 0xFF);
    }

    public void writeRawLittleEndian32(int n2) {
        this.array[this.pos++] = (byte)(n2 & 0xFF);
        this.array[this.pos++] = (byte)(n2 >> 8 & 0xFF);
        this.array[this.pos++] = (byte)(n2 >> 16 & 0xFF);
        this.array[this.pos++] = (byte)(n2 >> 24 & 0xFF);
    }

    public void writeRawLittleEndian64(long l2) {
        this.array[this.pos++] = (byte)((int)l2 & 0xFF);
        this.array[this.pos++] = (byte)((int)(l2 >> 8) & 0xFF);
        this.array[this.pos++] = (byte)((int)(l2 >> 16) & 0xFF);
        this.array[this.pos++] = (byte)((int)(l2 >> 24) & 0xFF);
        this.array[this.pos++] = (byte)((int)(l2 >> 32) & 0xFF);
        this.array[this.pos++] = (byte)((int)(l2 >> 40) & 0xFF);
        this.array[this.pos++] = (byte)((int)(l2 >> 48) & 0xFF);
        this.array[this.pos++] = (byte)((int)(l2 >> 56) & 0xFF);
    }

    public void writeByteArray(byte[] byArray, int n2, int n3) {
        this.need(n3);
        System.arraycopy(byArray, n2, this.array, this.pos, n3);
        this.pos += n3;
    }

    public void writeByteArrayincludeLength(byte[] byArray) {
        this.writeU16(byArray.length);
        this.writeByteArray(byArray, 0, byArray.length);
    }

    public void writeByteArray(byte[] byArray) {
        this.writeByteArray(byArray, 0, byArray.length);
    }

    public void writeCountedString(byte[] byArray) {
        if (byArray.length > 255) {
            throw new IllegalArgumentException("Invalid counted string");
        }
        this.need(1 + byArray.length);
        this.array[this.pos++] = (byte)(byArray.length & 0xFF);
        this.writeByteArray(byArray, 0, byArray.length);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.pos];
        System.arraycopy(this.array, 0, byArray, 0, this.pos);
        return byArray;
    }
}

